/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.toast;

import androidx.annotation.ColorInt;
import com.yy.appbase.R;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;

public class GlobalBottomToastUtils {
    private static final long SHORT_DURATION_TIMEOUT = 3000L;
    private static final long LONG_DURATION_TIMEOUT = 5000L;
    public static final int LOW = 0;
    public static final int MIDDLE = 10;
    public static final int HIGH = 20;

    public static void showErrorToast(CharSequence text, int duration) {
        GlobalBottomToastUtils.showToast(text, ResourceUtils.getColor((int)R.color.error_toast_bg), duration, 20);
    }

    public static void showToast(CharSequence text, int duration, @ColorInt int bgColor, boolean isShowSingleLine) {
        long realDuration = duration == 1 ? 5000L : 3000L;
        GlobalBottomToastUtils.showToast(text, bgColor, realDuration, 20, 0.0f, isShowSingleLine);
    }

    public static void showToast(CharSequence text, int duration) {
        GlobalBottomToastUtils.showToast(text, ResourceUtils.getColor((int)R.color.warn_toast_bg), duration, 10);
    }

    public static void showToast(CharSequence text, @ColorInt int bgColor, int duration, int priority) {
        long realDuration = duration == 1 ? 5000L : 3000L;
        GlobalBottomToastUtils.showToast(text, bgColor, realDuration, priority, 0.0f, false);
    }

    public static void showToast(CharSequence text, @ColorInt int bgColor, int duration, float marginTop) {
        long realDuration = duration == 1 ? 5000L : 3000L;
        GlobalBottomToastUtils.showToast(text, bgColor, realDuration, 10, marginTop, false);
    }

    public static void showToast(CharSequence text, @ColorInt int bgColor, long duration, int priority, float marginTop, boolean isShowSingleLine) {
        ToastMessage msg = new ToastMessage();
        msg.msg = text;
        msg.color = bgColor;
        msg.duration = duration;
        msg.priority = priority;
        msg.marginTop = marginTop;
        msg.isShowSignleLine = isShowSingleLine;
        GlobalBottomToastUtils.notifyToast(msg);
    }

    public static void showToast(ToastMessage msg) {
        if (msg != null) {
            GlobalBottomToastUtils.notifyToast(msg);
        }
    }

    private static void notifyToast(ToastMessage msg) {
        final Notification notification = Notification.obtain((int)NotificationIdDef.GLOBAL_BOTTOM_TOAST, (Object)msg);
        if (YYTaskExecutor.isMainThread()) {
            NotificationCenter.getGlobalInstance().notify(notification);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().notify(notification);
                }
            });
        }
    }
}

