/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.press;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.AnimRes;
import com.yy.appbase.R;
import javax.annotation.Nonnull;

public class ClickScaleAnimProvider {
    private View mTargetView;
    private Animation mDownAnim;
    private Animation mUpAnim;

    public static void apply(@Nonnull View target) {
        new ClickScaleAnimProvider(target, true);
    }

    public ClickScaleAnimProvider(@Nonnull View target, boolean canSetTouchEvent) {
        this.mTargetView = target;
        if (canSetTouchEvent) {
            TouchScaleListener listener2 = new TouchScaleListener(){

                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (v.getTag(R.id.clear_scale) == this) {
                        ClickScaleAnimProvider.this.onTouchEvent(event);
                    }
                    return false;
                }
            };
            this.mTargetView.setTag(R.id.clear_scale, (Object)listener2);
            this.mTargetView.setOnTouchListener((View.OnTouchListener)listener2);
        }
    }

    public static void clear(View view) {
        view.setTag(R.id.clear_scale, null);
    }

    public void onTouchEvent(MotionEvent event) {
        if (this.mTargetView != null) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    if (this.mDownAnim == null) {
                        this.mDownAnim = this.createAnim(this.getTouchDownAnim(event));
                    }
                    this.beginScale(this.mDownAnim);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    if (this.mUpAnim == null) {
                        this.mUpAnim = this.createAnim(this.getTouchUpAnim(event));
                    }
                    this.beginScale(this.mUpAnim);
                    break;
                }
            }
        }
    }

    private synchronized Animation createAnim(int animation) {
        if (this.mTargetView != null) {
            Animation an = AnimationUtils.loadAnimation((Context)this.mTargetView.getContext(), (int)animation);
            an.setDuration(80L);
            an.setFillAfter(true);
            return an;
        }
        return null;
    }

    private void beginScale(Animation animation) {
        if (animation != null && this.mTargetView != null) {
            this.mTargetView.startAnimation(animation);
        }
    }

    @AnimRes
    protected int getTouchDownAnim(MotionEvent event) {
        return R.anim.btn_click_to_zoom_out_anim;
    }

    @AnimRes
    protected int getTouchUpAnim(MotionEvent event) {
        return R.anim.btn_click_to_zoom_in_anim;
    }

    private static class TouchScaleListener
    implements View.OnTouchListener {
        private TouchScaleListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            return false;
        }
    }
}

