/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.panel;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.data.MenuItemData;
import com.yy.appbase.ui.panel.IPanelItemClick;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.BasePanel;
import java.util.List;

public abstract class AbstractSharePanel
extends BasePanel {
    private LinearLayout mContainer;
    private GridView mGridView;
    private TextView mTitle;
    private List<MenuItemData> mDatas;
    private IPanelItemClick mPanelItemClick;
    private int mStyle;
    private LinearLayout mContentContainer;
    public static final int STYLE_WHITE = 0;
    public static final int STYLE_BLACK = 1;

    public AbstractSharePanel(Context context, IPanelItemClick iPanelItemClick) {
        this(context, iPanelItemClick, 1);
    }

    public AbstractSharePanel(Context context, IPanelItemClick iPanelItemClick, int style2) {
        super(context);
        this.mStyle = style2;
        this.init();
        this.mPanelItemClick = iPanelItemClick;
    }

    private void init() {
        int leftPadding = ResourceUtils.getDimen((int)R.dimen.share_panel_left_padding);
        int titleTextSize = ResourceUtils.getDimen((int)R.dimen.share_panel_title_textsize);
        int titleBottomMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_title_bottom_margin);
        int itemRightMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_item_right_padding);
        int itemBottomMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_item_bottom_padding);
        this.mContainer = new YYLinearLayout(this.getContext());
        this.mContentContainer = new YYLinearLayout(this.getContext());
        this.mGridView = new GridView(this.getContext());
        this.mTitle = new YYTextView(this.getContext());
        this.mTitle.setGravity(17);
        this.mContainer.setOrientation(1);
        this.mContentContainer.setOrientation(1);
        this.mContentContainer.setPadding(0, 0, 0, leftPadding);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 1;
        layoutParams.bottomMargin = titleBottomMargin;
        this.mTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 1;
        this.mGridView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mGridView.setPadding(leftPadding, 0, leftPadding, 0);
        this.mTitle.setTextSize(0, (float)titleTextSize);
        this.mTitle.setTextColor(this.getTextColor());
        this.mTitle.setPadding(0, leftPadding, 0, 0);
        this.mGridView.setHorizontalSpacing(itemRightMargin);
        this.mGridView.setVerticalSpacing(itemBottomMargin);
        this.mGridView.setNumColumns(this.getNumColumns());
        this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4) {
                MenuItemData data2;
                if (var2 instanceof TextView && (data2 = (MenuItemData)var2.getTag()) != null) {
                    AbstractSharePanel.this.mPanelItemClick.onItemClicked(data2.itemId, AbstractSharePanel.this);
                }
            }
        });
        this.mContainer.setBackgroundColor(ResourceUtils.getColor((int)R.color.transparent));
        this.mContentContainer.setBackgroundColor(this.getBackgroundColor());
        if (this.mStyle == 0) {
            YYView shadow = new YYView(this.getContext());
            shadow.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)20.0f)));
            shadow.setBackgroundResource(R.drawable.share_panel_shadow);
            this.mContainer.addView((View)shadow);
        }
        this.mContainer.addView((View)this.mContentContainer);
        this.mContentContainer.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mContentContainer.addView((View)this.mTitle);
        this.mContentContainer.addView((View)this.mGridView);
        this.mGridView.setAdapter((ListAdapter)new BaseAdapter(){

            public boolean areAllItemsEnabled() {
                return true;
            }

            public boolean isEnabled(int i) {
                return true;
            }

            public int getCount() {
                if (AbstractSharePanel.this.mDatas != null) {
                    return AbstractSharePanel.this.mDatas.size();
                }
                return 0;
            }

            public Object getItem(int i) {
                if (AbstractSharePanel.this.mDatas != null && i < AbstractSharePanel.this.mDatas.size()) {
                    AbstractSharePanel.this.mDatas.get(i);
                }
                return null;
            }

            public long getItemId(int i) {
                return i;
            }

            public boolean hasStableIds() {
                return false;
            }

            public View getView(int i, View view, ViewGroup viewGroup) {
                if (AbstractSharePanel.this.mDatas == null || AbstractSharePanel.this.mDatas.size() == 0) {
                    return null;
                }
                if (view == null) {
                    view = AbstractSharePanel.this.getItemView((MenuItemData)AbstractSharePanel.this.mDatas.get(i));
                }
                AbstractSharePanel.this.updateItem((MenuItemData)AbstractSharePanel.this.mDatas.get(i), (TextView)view);
                return view;
            }

            public int getItemViewType(int i) {
                return 0;
            }

            public int getViewTypeCount() {
                return 1;
            }

            public boolean isEmpty() {
                return AbstractSharePanel.this.mDatas == null || AbstractSharePanel.this.mDatas.size() == 0;
            }
        });
        this.mGridView.setSelector((Drawable)new ColorDrawable(0));
        this.mContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
        this.setContent((View)this.mContainer, this.getContentLayoutParams());
    }

    private TextView getItemView(MenuItemData item) {
        int itemTextSize = ResourceUtils.getDimen((int)R.dimen.share_panel_item_textsize);
        YYTextView itemView = new YYTextView(this.getContext());
        itemView.setTextColor(this.getTextColor());
        itemView.setTextSize(0, (float)itemTextSize);
        itemView.setGravity(1);
        return itemView;
    }

    private void updateItem(MenuItemData item, TextView view) {
        int iconBottomMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_item_icon_bottom_margin);
        int itemHeight = ResourceUtils.getDimen((int)R.dimen.share_panel_item_icon_height);
        Drawable drawable2 = ResourceUtils.getDrawable((int)item.iconRes);
        drawable2.setBounds(0, 0, itemHeight, itemHeight);
        view.setCompoundDrawables(null, drawable2, null, null);
        view.setCompoundDrawablePadding(iconBottomMargin);
        view.setText((CharSequence)item.title);
        view.setTag((Object)item);
    }

    public void updateItems(List<MenuItemData> items, String title) {
        this.mDatas = items;
        this.mTitle.setText((CharSequence)title);
        ((BaseAdapter)this.mGridView.getAdapter()).notifyDataSetChanged();
    }

    private int getTextColor() {
        return ResourceUtils.getColor((int)(this.mStyle == 1 ? R.color.share_panel_text_color : R.color.share_dialog_text_color));
    }

    private int getBackgroundColor() {
        return ResourceUtils.getColor((int)(this.mStyle == 1 ? R.color.share_panel_bg_color : R.color.share_dialog_bg_color));
    }

    public void hidePanel(boolean anim2) {
        super.hide(anim2);
    }

    protected abstract int getNumColumns();

    protected abstract RelativeLayout.LayoutParams getContentLayoutParams();
}

