/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.UnderlineSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.yy.appbase.R;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;

public class PunishToastDialog
implements BaseDialog {
    public static final int BLOCK_TYPE_CHANNEL = 1;
    public static final int BLOCK_TYPE_PERSON = 2;
    private YYTextView punishContent;
    private YYImageView punishImg;
    private YYTextView punishOk;
    private YYTextView tvTitle;
    private YYTextView tvConcel;
    private YYTextView tvAppeal;
    private YYTextView tvMoreReport;
    private String msg;
    private int imgPath = 0;
    private String bannedTime;
    private boolean isClickOk = false;
    private CancelReport cancelReport;
    private OkCancelDialogListener okCancelDialogListener;
    private BlockListener blockListener;
    private int blockType = -1;

    public void setBlockType(int blockType) {
        this.blockType = blockType;
    }

    public void setPunishOkTitle(String title) {
        if (this.punishOk != null) {
            this.punishOk.setText((CharSequence)title);
        }
    }

    public PunishToastDialog(int img) {
        this.imgPath = img;
    }

    public PunishToastDialog(int img, String date, String msg, OkCancelDialogListener okCancelDialogListener) {
        this.imgPath = img;
        this.bannedTime = date;
        this.msg = msg;
        this.okCancelDialogListener = okCancelDialogListener;
    }

    public PunishToastDialog(int img, String msg, OkCancelDialogListener okCancelDialogListener) {
        this.imgPath = img;
        this.msg = msg;
        this.okCancelDialogListener = okCancelDialogListener;
    }

    public PunishToastDialog(int img, OkCancelDialogListener okCancelDialogListener) {
        this.imgPath = img;
        this.okCancelDialogListener = okCancelDialogListener;
    }

    public void init(Dialog dialog) {
        Window window = dialog.getWindow();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        if (window == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.bannedTime) && !TextUtils.isEmpty((CharSequence)this.msg)) {
            View contentView = LayoutInflater.from((Context)dialog.getContext()).inflate(R.layout.layout_login_punish_toast_window, null);
            window.setContentView(contentView);
            this.initLoginPunish(window, dialog);
        } else if (!TextUtils.isEmpty((CharSequence)this.msg)) {
            View contentView = LayoutInflater.from((Context)dialog.getContext()).inflate(R.layout.layout_login_punish_toast_window, null);
            window.setContentView(contentView);
            this.initRoomListPunish(window, dialog);
        } else {
            View contentView = LayoutInflater.from((Context)dialog.getContext()).inflate(R.layout.layout_punish_toast_window, null);
            window.setContentView(contentView);
            window.setGravity(80);
            ViewGroup.LayoutParams layoutParams = contentView.getLayoutParams();
            layoutParams.width = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext);
            contentView.setLayoutParams(layoutParams);
            this.initRoomPunish(window, dialog);
        }
        this.punishImg = (YYImageView)window.findViewById(R.id.punish_img);
        if (this.imgPath != 0) {
            this.punishImg.setImageResource(this.imgPath);
        }
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (!PunishToastDialog.this.isClickOk && PunishToastDialog.this.cancelReport != null) {
                    PunishToastDialog.this.cancelReport.cancelReport();
                }
            }
        });
    }

    private void initRoomPunish(Window window, final Dialog dialog) {
        this.punishContent = (YYTextView)window.findViewById(R.id.punish_context_tv);
        this.tvMoreReport = (YYTextView)window.findViewById(R.id.tv_more_report);
        this.punishOk = (YYTextView)window.findViewById(R.id.punish_ok_tv);
        if (this.blockType != -1) {
            this.punishOk.setVisibility(0);
        } else {
            this.punishOk.setVisibility(8);
        }
        String strPunishOk = ResourceUtils.getString((int)R.string.btn_block_room);
        if (this.blockType == 2) {
            strPunishOk = ResourceUtils.getString((int)R.string.btn_block_person);
        }
        if (strPunishOk.length() > 20) {
            this.punishOk.setTextSize(12.0f);
        } else {
            this.punishOk.setTextSize(16.0f);
        }
        this.punishOk.setText((CharSequence)strPunishOk);
        this.punishContent.setTextColor(ResourceUtils.getColor((int)R.color.common_color_9));
        this.punishOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PunishToastDialog.this.isClickOk = true;
                if (PunishToastDialog.this.blockListener != null) {
                    PunishToastDialog.this.blockListener.onBlockClick(PunishToastDialog.this.blockType);
                }
                dialog.dismiss();
            }
        });
    }

    private void initLoginPunish(Window window, final Dialog dialog) {
        String barrageMessage = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.short_tips_feedback_banned_time), (Object[])new Object[]{this.bannedTime});
        SpannableStringBuilder style2 = new SpannableStringBuilder((CharSequence)this.msg);
        style2.setSpan((Object)new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.color_1b1b1b)), 0, this.msg.length(), 33);
        this.tvConcel = (YYTextView)window.findViewById(R.id.tv_cancel);
        this.tvAppeal = (YYTextView)window.findViewById(R.id.tv_appeal);
        this.tvTitle = (YYTextView)window.findViewById(R.id.action_sheet_text_new);
        this.tvConcel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
            }
        });
        this.tvAppeal.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
                if (PunishToastDialog.this.okCancelDialogListener != null) {
                    PunishToastDialog.this.okCancelDialogListener.onOk();
                }
            }
        });
        style2.append((CharSequence)barrageMessage);
        this.tvTitle.setText((CharSequence)style2);
    }

    private void initRoomListPunish(Window window, final Dialog dialog) {
        this.tvConcel = (YYTextView)window.findViewById(R.id.tv_cancel);
        this.tvAppeal = (YYTextView)window.findViewById(R.id.tv_appeal);
        this.tvTitle = (YYTextView)window.findViewById(R.id.action_sheet_text_new);
        this.tvConcel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
            }
        });
        this.tvAppeal.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
                if (PunishToastDialog.this.okCancelDialogListener != null) {
                    PunishToastDialog.this.okCancelDialogListener.onOk();
                }
            }
        });
        this.tvTitle.setText((CharSequence)this.msg);
    }

    public void setOkCancelDialogListener(OkCancelDialogListener okCancelDialogListener) {
        this.okCancelDialogListener = okCancelDialogListener;
    }

    public void setCancelReport(CancelReport cancelReport) {
        this.cancelReport = cancelReport;
    }

    public void setBlockListener(BlockListener listener2) {
        this.blockListener = listener2;
    }

    public void showMoreReport() {
        if (this.tvMoreReport != null) {
            this.tvMoreReport.setVisibility(0);
            this.punishContent.setVisibility(8);
            String udata = ResourceUtils.getString((int)R.string.btn_more_report);
            SpannableString content = new SpannableString((CharSequence)udata);
            content.setSpan((Object)new UnderlineSpan(), 0, udata.length(), 0);
            this.tvMoreReport.setText((CharSequence)content);
            this.tvMoreReport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PunishToastDialog.this.cancelReport != null) {
                        PunishToastDialog.this.cancelReport.onMoreReportClick();
                    }
                }
            });
        }
    }

    public int getId() {
        return 0;
    }

    public static interface BlockListener {
        public void onBlockClick(int var1);
    }

    public static interface CancelReport {
        public void cancelReport();

        public void onMoreReportClick();
    }
}

