/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.country;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import android.widget.TextView;
import androidx.core.widget.TextViewCompat;
import com.yy.appbase.R;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.appbase.ui.country.ICountrySelectCallBack;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.indexablelist.IndexableListView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import java.util.List;
import java.util.Locale;

public class CountrySelectWindow
extends DefaultWindow {
    private TextView mTitle;
    private TextView mCancel;
    private IndexableListView mListView;
    private List<CountryHelper.CountryInfo> mAllItems;
    private ICountrySelectCallBack mMyCallBack;
    private static final String RU_LANGUAGE = "ru";

    public CountrySelectWindow(Context context, ICountrySelectCallBack callBacks) {
        super(context, (UICallBacks)callBacks, "CountrySelect");
        this.mMyCallBack = callBacks;
        this.initViews();
        this.updateDatas();
        this.setBackgroundColor(ResourceUtils.getColor((int)R.color.common_window_white_bg));
    }

    private void initViews() {
        int titleBarHeight = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_height);
        int titleTextSize = ResourceUtils.getDimen((int)R.dimen.country_select_title_textsize);
        int cancelTextSize = ResourceUtils.getDimen((int)R.dimen.country_select_cancel_textsize);
        int lineLeftMargin = ResourceUtils.getDimen((int)R.dimen.country_select_line_left_margin);
        YYLinearLayout container = new YYLinearLayout(this.getContext());
        YYLinearLayout textContainer = new YYLinearLayout(this.getContext());
        textContainer.setOrientation(0);
        this.mTitle = new YYTextView(this.getContext());
        this.mCancel = new YYTextView(this.getContext());
        this.mListView = new IndexableListView(this.getContext());
        container.setOrientation(1);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, titleBarHeight);
        textContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        FrameLayout.LayoutParams fLayoutParams = new FrameLayout.LayoutParams(-2, titleBarHeight);
        fLayoutParams.leftMargin = lineLeftMargin;
        LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)fLayoutParams);
        this.mCancel.setLayoutParams((ViewGroup.LayoutParams)fLayoutParams);
        fLayoutParams = new FrameLayout.LayoutParams(-1, -2);
        fLayoutParams.gravity = 17;
        this.mTitle.setLayoutParams((ViewGroup.LayoutParams)fLayoutParams);
        layoutParams = new LinearLayout.LayoutParams(-1, -1);
        this.mListView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        textContainer.addView((View)this.mCancel);
        textContainer.addView((View)this.mTitle, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        container.addView((View)textContainer);
        container.addView((View)this.mListView);
        this.getBaseLayer().addView((View)container, new ViewGroup.LayoutParams(-1, -1));
        this.mCancel.setGravity(16);
        this.mCancel.setTextSize(0, (float)cancelTextSize);
        this.mCancel.setTextColor(ResourceUtils.getColor((int)R.color.login_country_select_title));
        this.mCancel.setText((CharSequence)ResourceUtils.getString((int)R.string.login_country_select_cancle));
        LayoutUtil.setPadding((View)this.mTitle, ResolutionUtils.dip2Px((float)16.0f), 0, 0, 0);
        this.mTitle.setGravity(16);
        TextViewCompat.setAutoSizeTextTypeUniformWithConfiguration((TextView)this.mTitle, (int)8, (int)19, (int)1, (int)2);
        this.mTitle.setTextSize(0, (float)titleTextSize);
        this.mTitle.setTextColor(ResourceUtils.getColor((int)R.color.login_country_select_title));
        this.mTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.login_country_select_title));
        if (Build.VERSION.SDK_INT >= 17) {
            this.mTitle.setTextAlignment(5);
        }
        this.changeSizeByLanguageChange(this.mTitle, RU_LANGUAGE, 16.0f);
    }

    private void changeSizeByLanguageChange(TextView textView, String language, float textSize) {
        if (textView == null) {
            return;
        }
        if (Locale.getDefault() != null && language.equals(Locale.getDefault().getLanguage())) {
            textView.setTextSize(textSize);
        }
    }

    private void updateDatas() {
        this.mAllItems = CountryHelper.getAllCountryList();
        final CountryAdapter countryAdapter = new CountryAdapter(this.getContext(), this.mAllItems);
        this.mListView.setAdapter((ListAdapter)countryAdapter);
        this.mListView.setDivider(null);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                CountryHelper.CountryInfo info = (CountryHelper.CountryInfo)countryAdapter.getItem(i);
                if (!info.isIndex && CountrySelectWindow.this.mMyCallBack != null) {
                    CountrySelectWindow.this.mMyCallBack.onCountrySelected(info);
                }
            }
        });
        this.mListView.setFastScrollEnabled(true);
        this.mCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CountrySelectWindow.this.mMyCallBack != null) {
                    CountrySelectWindow.this.mMyCallBack.onBackIconClicked((AbstractWindow)CountrySelectWindow.this);
                }
            }
        });
    }

    private class CountryAdapter
    extends BaseAdapter
    implements SectionIndexer {
        private static final String INDEX = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private List<CountryHelper.CountryInfo> mInfos;

        public CountryAdapter(Context context, List<CountryHelper.CountryInfo> infos) {
            this.mInfos = infos;
        }

        public int getCount() {
            return this.mInfos == null ? 0 : this.mInfos.size();
        }

        public Object getItem(int position) {
            return this.mInfos == null ? null : this.mInfos.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            final CountryHelper.CountryInfo info = this.mInfos.get(position);
            if (info.isIndex) {
                if (convertView == null || !(convertView instanceof IndexItemView)) {
                    convertView = new IndexItemView(parent.getContext());
                }
                if (convertView instanceof IndexItemView) {
                    ((IndexItemView)((Object)convertView)).updateData(info);
                }
            } else {
                CountryHelper.CountryInfo nextInfo = null;
                if (position < this.mInfos.size() - 1) {
                    nextInfo = this.mInfos.get(position + 1);
                }
                if (convertView == null || !(convertView instanceof ItemView)) {
                    convertView = new ItemView(parent.getContext());
                }
                if (convertView instanceof ItemView) {
                    ((ItemView)((Object)convertView)).updateData(info);
                    if (nextInfo != null && nextInfo.isIndex) {
                        ((ItemView)((Object)convertView)).showLine(false);
                    } else {
                        ((ItemView)((Object)convertView)).showLine(true);
                    }
                }
                convertView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (info != null && !info.isIndex && CountrySelectWindow.this.mMyCallBack != null) {
                            CountrySelectWindow.this.mMyCallBack.onCountrySelected(info);
                        }
                    }
                });
            }
            return convertView;
        }

        public Object[] getSections() {
            Object[] sections = new String[INDEX.length()];
            for (int i = 0; i < INDEX.length(); ++i) {
                sections[i] = String.valueOf(INDEX.charAt(i));
            }
            return sections;
        }

        public int getPositionForSection(int sectionIndex) {
            char section = ((String)this.getSections()[sectionIndex]).charAt(0);
            CountryHelper.CountryInfo ci = null;
            for (int i = 0; i < this.mInfos.size(); ++i) {
                ci = this.mInfos.get(i);
                if (!ci.isIndex || !CountryHelper.matchIgnoreCase(section, ci.englishName.charAt(0))) continue;
                return i;
            }
            return 0;
        }

        public int getSectionForPosition(int position) {
            return 0;
        }

        private class ItemView
        extends YYFrameLayout {
            private TextView mTitle;
            private TextView mCode;
            private View mLine;

            public ItemView(Context context) {
                super(context);
                this.mTitle = null;
                this.mCode = null;
                int lineHeight = ResourceUtils.getDimen((int)R.dimen.country_select_line_height);
                int itemHeight = ResourceUtils.getDimen((int)R.dimen.country_select_item_height);
                int codeTextSize = ResourceUtils.getDimen((int)R.dimen.country_select_item_code_textsize);
                int itemTextSize = ResourceUtils.getDimen((int)R.dimen.country_select_item_textsize);
                int itemLeftMargin = ResourceUtils.getDimen((int)R.dimen.country_select_item_left_margin);
                int lineLeftMargin = ResourceUtils.getDimen((int)R.dimen.country_select_line_left_margin);
                int itemRightMargin = ResourceUtils.getDimen((int)R.dimen.country_select_item_right_margin);
                int lineRightMargin = ResourceUtils.getDimen((int)R.dimen.country_select_line_right_margin);
                this.mTitle = new YYTextView(this.getContext());
                this.mCode = new YYTextView(this.getContext());
                this.mLine = new YYView(this.getContext());
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                layoutParams.gravity = 8388627;
                layoutParams.leftMargin = itemLeftMargin;
                LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)layoutParams);
                this.mTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                layoutParams = new FrameLayout.LayoutParams(-2, -2);
                layoutParams.gravity = 8388629;
                layoutParams.rightMargin = itemRightMargin;
                LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)layoutParams);
                this.mCode.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                layoutParams = new FrameLayout.LayoutParams(-1, lineHeight);
                layoutParams.gravity = 80;
                layoutParams.leftMargin = lineLeftMargin;
                layoutParams.rightMargin = lineRightMargin;
                LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)layoutParams);
                this.mLine.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mTitle.setTextSize(0, (float)itemTextSize);
                this.mCode.setTextSize(0, (float)codeTextSize);
                this.mTitle.setTextColor(ResourceUtils.getColor((int)R.color.login_country_select_title));
                this.mCode.setTextColor(ResourceUtils.getColor((int)R.color.login_country_select_code));
                this.addView((View)this.mTitle);
                this.addView((View)this.mCode);
                this.addView(this.mLine);
                this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, itemHeight));
                this.mLine.setBackgroundColor(ResourceUtils.getColor((int)R.color.login_country_select_line));
                StateListDrawable bgColorDrawable = new StateListDrawable();
                bgColorDrawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(ResourceUtils.getColor((int)R.color.login_country_select_item_press)));
                bgColorDrawable.addState(new int[0], (Drawable)new ColorDrawable(0));
                this.setBackgroundDrawable((Drawable)bgColorDrawable);
            }

            public void showLine(boolean show2) {
                this.mLine.setVisibility(show2 ? 0 : 4);
            }

            public void updateData(CountryHelper.CountryInfo info) {
                if (info != null) {
                    this.mTitle.setText((CharSequence)info.englishName);
                    this.mCode.setText((CharSequence)("+" + info.numberCode));
                }
            }
        }

        private class IndexItemView
        extends YYFrameLayout {
            private TextView mTitle;

            public IndexItemView(Context context) {
                super(context);
                this.mTitle = null;
                int indexHeight = ResourceUtils.getDimen((int)R.dimen.country_select_index_height);
                int itemLeftMargin = ResourceUtils.getDimen((int)R.dimen.country_select_item_left_margin);
                int indexTextSize = ResourceUtils.getDimen((int)R.dimen.country_select_index_textsize);
                this.mTitle = new YYTextView(this.getContext());
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                layoutParams.gravity = 8388627;
                layoutParams.leftMargin = itemLeftMargin;
                LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)layoutParams);
                this.mTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mTitle.setTextSize(0, (float)indexTextSize);
                this.mTitle.setTextColor(ResourceUtils.getColor((int)R.color.login_country_select_index));
                this.addView((View)this.mTitle);
                this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, indexHeight));
                this.setBackgroundColor(ResourceUtils.getColor((int)R.color.login_country_index_bg));
            }

            public void updateData(CountryHelper.CountryInfo info) {
                if (info != null) {
                    this.mTitle.setText((CharSequence)info.englishName);
                }
            }
        }
    }
}

