/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.country;

import com.yy.appbase.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CountryHelper {
    private static final String TAG = "CountryHelper";
    public static final String INDEX = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String SEPERATE = "--";
    private static List<CountryInfo> mCountryList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CountryInfo> getAllCountryList() {
        if (mCountryList != null && mCountryList.size() > 0) {
            return mCountryList;
        }
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = RuntimeContext.sApplicationContext.getResources().openRawResource(R.raw.country_new);
            br = new BufferedReader(new InputStreamReader(is));
            ArrayList<CountryInfo> results = new ArrayList<CountryInfo>();
            String line = null;
            String index = "";
            String tempIndex = "";
            while ((line = br.readLine()) != null) {
                CountryInfo info = CountryInfo.parseString(line);
                if (info == null) continue;
                if (info.englishName != null && info.englishName.length() > 0) {
                    tempIndex = info.englishName.substring(0, 1);
                    if (StringUtils.isEmpty((String)index) || !StringUtils.equals((String)index, (String)tempIndex)) {
                        index = info.englishName.substring(0, 1);
                        results.add(CountryHelper.createIndex(index));
                    }
                }
                results.add(info);
            }
            mCountryList = results;
        }
        catch (Exception ex) {
            mCountryList = new ArrayList<CountryInfo>(0);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return mCountryList;
    }

    public static String getNumberCodeByCode(String countryCode) {
        List<CountryInfo> infos = CountryHelper.getAllCountryList();
        if (FP.empty(infos)) {
            return "";
        }
        for (CountryInfo info : infos) {
            if (!info.code.equals(countryCode)) continue;
            return info.numberCode;
        }
        return "";
    }

    public static CountryInfo getCountryInfoByCode(String countryCode) {
        List<CountryInfo> infos = CountryHelper.getAllCountryList();
        if (FP.empty(infos)) {
            return null;
        }
        for (CountryInfo info : infos) {
            if (!info.code.equalsIgnoreCase(countryCode)) continue;
            return info;
        }
        return null;
    }

    private static CountryInfo createIndex(String indexName) {
        CountryInfo info = new CountryInfo();
        info.isIndex = true;
        info.englishName = indexName;
        return info;
    }

    public static boolean matchIgnoreCase(char a, char b) {
        boolean match = a == b || a - 32 == b || a + 32 == b;
        return match;
    }

    public static class CountryInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String englishName = "";
        public String code = "";
        public String numberCode = "";
        public boolean isIndex = false;

        public static CountryInfo parseString(String content) {
            if (content == null || content.length() <= 0) {
                MLog.error((Object)CountryHelper.TAG, (String)"\u83b7\u53d6\u56fd\u5bb6\u533a\u53f7\u51fa\u9519\uff1acontent\u4e3a\u7a7a", (Object[])new Object[0]);
                return null;
            }
            String[] fileds = content.split(CountryHelper.SEPERATE);
            if (fileds == null || fileds.length <= 2) {
                MLog.error((Object)CountryHelper.TAG, (String)"\u83b7\u53d6\u56fd\u5bb6\u533a\u53f7\u51fa\u9519\uff1a\u65e0\u5b57\u6bb5", (Object[])new Object[0]);
                return null;
            }
            CountryInfo info = new CountryInfo();
            info.englishName = fileds[0];
            info.code = fileds[1];
            info.numberCode = fileds[2];
            return info;
        }

        public String toString() {
            return "CountryInfo{englishName='" + this.englishName + '\'' + ", code='" + this.code + '\'' + ", numberCode='" + this.numberCode + '\'' + ", isIndex=" + this.isIndex + '}';
        }
    }
}

