/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.service.dres;

import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.service.dres.FetchTask;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002J0\u0010\u000f\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J \u0010\u0013\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J,\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u0003J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eJ*\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0007J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/yy/appbase/service/dres/ResDownloadUtils;", "", "dirPath", "", "(Ljava/lang/String;)V", "downloadingTask", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/yy/appbase/service/dres/FetchTask;", "addTask", "", "url", "path", "callback", "Lcom/yy/appbase/callback/ICommonCallback;", "callbackFail", "code", "", "msg", "callbackSuccess", "download", "fetchAsync", "suffix", "fetchFile", "getFilePath", "handleFail", "handleSuccess", "handleTimeout", "task", "Companion", "appbase_debug"})
public final class ResDownloadUtils {
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<FetchTask>> downloadingTask;
    private final String dirPath;
    @NotNull
    public static final String TAG = "ResDownloadUtils";
    private static final String DIR = "res-download";
    private static final long TIMEOUT = 30000L;
    public static final Companion Companion = new Companion(null);

    public final void fetchFile(@NotNull String url, @Nullable ICommonCallback<String> callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.fetchFile(url, null, callback);
    }

    public final void fetchFile(@NotNull String url, @Nullable String suffix, @Nullable ICommonCallback<String> callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        MLog.info((Object)TAG, (String)"fetchFile url: %s", (Object[])new Object[]{url});
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.callbackFail(callback, url, -1, "url is empty");
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(this, url, suffix, callback){
                final /* synthetic */ ResDownloadUtils this$0;
                final /* synthetic */ String $url;
                final /* synthetic */ String $suffix;
                final /* synthetic */ ICommonCallback $callback;

                public final void run() {
                    ResDownloadUtils.access$fetchAsync(this.this$0, this.$url, this.$suffix, this.$callback);
                }
                {
                    this.this$0 = resDownloadUtils;
                    this.$url = string2;
                    this.$suffix = string3;
                    this.$callback = iCommonCallback;
                }
            });
        } else {
            this.fetchAsync(url, suffix, callback);
        }
    }

    public static /* synthetic */ void fetchFile$default(ResDownloadUtils resDownloadUtils, String string2, String string3, ICommonCallback iCommonCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        resDownloadUtils.fetchFile(string2, string3, iCommonCallback);
    }

    @WorkerThread
    @Nullable
    public final String getFilePath(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String urlMd5 = MD5Utils.getMD5String((String)url);
        String path = this.dirPath + urlMd5;
        if (YYFileUtils.isFileExisted((String)path)) {
            return path;
        }
        return null;
    }

    @WorkerThread
    private final void fetchAsync(String url, String suffix, ICommonCallback<String> callback) {
        String urlMd5 = !TextUtils.isEmpty((CharSequence)suffix) ? MD5Utils.getMD5String((String)url) + suffix : MD5Utils.getMD5String((String)url);
        String path = this.dirPath + File.separator + urlMd5;
        if (YYFileUtils.isFileExisted((String)path)) {
            this.callbackSuccess(callback, path);
            return;
        }
        if (callback != null) {
            this.addTask(url, path, callback);
        }
        this.download(url, path);
    }

    static /* synthetic */ void fetchAsync$default(ResDownloadUtils resDownloadUtils, String string2, String string3, ICommonCallback iCommonCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        resDownloadUtils.fetchAsync(string2, string3, iCommonCallback);
    }

    private final void download(String url, String path) {
        CharSequence charSequence = url;
        boolean bl = false;
        if (!(charSequence.length() == 0)) {
            HttpUtil.downloadFile(url, path, (Callback<File>)((Callback)new Callback<File>(this, url, path){
                final /* synthetic */ ResDownloadUtils this$0;
                final /* synthetic */ String $url;
                final /* synthetic */ String $path;

                public void onResponse(@NotNull Call<File> call, @NotNull Response<File> response) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull(response, (String)"response");
                    Object[] objectArray = new Object[1];
                    Object object = response.body();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.body()");
                    objectArray[0] = ((File)object).getAbsolutePath();
                    MLog.info((Object)"ResDownloadUtils", (String)"downloadRes onResponse file: %s", (Object[])objectArray);
                    ResDownloadUtils.access$handleSuccess(this.this$0, this.$url, this.$path);
                }

                public void onFailure(@NotNull Call<File> call, @NotNull Throwable e) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    MLog.error((Object)"ResDownloadUtils", (String)"downloadRes error", (Throwable)e, (Object[])new Object[0]);
                    ResDownloadUtils.access$handleFail(this.this$0, this.$url, NetworkUtils.getErrorCodeByExc((Throwable)e), "download fail " + e);
                }
                {
                    this.this$0 = $outer;
                    this.$url = $captured_local_variable$1;
                    this.$path = $captured_local_variable$2;
                }
            }));
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, url){
                final /* synthetic */ ResDownloadUtils this$0;
                final /* synthetic */ String $url;

                public final void run() {
                    ResDownloadUtils.access$handleFail(this.this$0, this.$url, -99, "download fail, url empty");
                }
                {
                    this.this$0 = resDownloadUtils;
                    this.$url = string2;
                }
            });
        }
    }

    private final void addTask(String url, String path, ICommonCallback<String> callback) {
        CopyOnWriteArrayList<FetchTask> taskList = this.downloadingTask.get(url);
        if (taskList == null) {
            taskList = new CopyOnWriteArrayList();
            ((Map)this.downloadingTask).put(url, taskList);
        }
        FetchTask task2 = new FetchTask(url, path, callback, new FetchTask.ITimeoutCallback(this){
            final /* synthetic */ ResDownloadUtils this$0;

            public void onTimeout(@NotNull FetchTask task2) {
                Intrinsics.checkParameterIsNotNull((Object)task2, (String)"task");
                ResDownloadUtils.access$handleTimeout(this.this$0, task2, -1, "wait timeout");
            }
            {
                this.this$0 = $outer;
            }
        });
        YYTaskExecutor.postToMainThread((Runnable)task2, (long)30000L);
        taskList.add(task2);
    }

    private final void handleTimeout(FetchTask task2, int code, String msg) {
        CopyOnWriteArrayList<FetchTask> taskList;
        CopyOnWriteArrayList<FetchTask> copyOnWriteArrayList = taskList = this.downloadingTask.get(task2.getUrl());
        if (copyOnWriteArrayList != null) {
            copyOnWriteArrayList.remove(task2);
        }
        this.callbackFail(task2.getCallback(), task2.getUrl(), code, msg);
        if (FP.empty((Collection)taskList)) {
            this.downloadingTask.remove(task2.getUrl());
        }
    }

    private final void handleFail(String url, int code, String msg) {
        CopyOnWriteArrayList<FetchTask> taskList;
        CopyOnWriteArrayList<FetchTask> copyOnWriteArrayList = taskList = this.downloadingTask.remove(url);
        if (copyOnWriteArrayList != null) {
            Iterable $this$forEach$iv = copyOnWriteArrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FetchTask it = (FetchTask)element$iv;
                boolean bl = false;
                YYTaskExecutor.removeTask((Runnable)it);
                this.callbackFail(it.getCallback(), it.getUrl(), code, msg);
            }
        }
    }

    private final void handleSuccess(String url, String path) {
        CopyOnWriteArrayList<FetchTask> taskList;
        CopyOnWriteArrayList<FetchTask> copyOnWriteArrayList = taskList = this.downloadingTask.remove(url);
        if (copyOnWriteArrayList != null) {
            Iterable $this$forEach$iv = copyOnWriteArrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FetchTask it = (FetchTask)element$iv;
                boolean bl = false;
                YYTaskExecutor.removeTask((Runnable)it);
                this.callbackSuccess(it.getCallback(), path);
            }
        }
    }

    private final void callbackSuccess(ICommonCallback<String> callback, String path) {
        MLog.info((Object)TAG, (String)"fetchFile success path: %s", (Object[])new Object[]{path});
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onSuccess(path, new Object[0]);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(callback, path){
                final /* synthetic */ ICommonCallback $callback;
                final /* synthetic */ String $path;

                public final void run() {
                    this.$callback.onSuccess(this.$path, new Object[0]);
                }
                {
                    this.$callback = iCommonCallback;
                    this.$path = string2;
                }
            });
        }
    }

    private final void callbackFail(ICommonCallback<String> callback, String url, int code, String msg) {
        MLog.info((Object)TAG, (String)"fetchFile fail code: %d, url: %s, msg: %s", (Object[])new Object[]{code, url, msg});
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFail(code, msg, new Object[0]);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(callback, code, msg){
                final /* synthetic */ ICommonCallback $callback;
                final /* synthetic */ int $code;
                final /* synthetic */ String $msg;

                public final void run() {
                    this.$callback.onFail(this.$code, this.$msg, new Object[0]);
                }
                {
                    this.$callback = iCommonCallback;
                    this.$code = n;
                    this.$msg = string2;
                }
            });
        }
    }

    public ResDownloadUtils(@NotNull String dirPath) {
        Intrinsics.checkParameterIsNotNull((Object)dirPath, (String)"dirPath");
        this.dirPath = dirPath;
        this.downloadingTask = new ConcurrentHashMap();
    }

    public /* synthetic */ ResDownloadUtils(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            File file = FileStorageUtils.getInstance().getInternalCacheDir(DIR);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileStorageUtils.getInst\u2026.getInternalCacheDir(DIR)");
            String string3 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileStorageUtils.getInst\u2026acheDir(DIR).absolutePath");
            string2 = string3;
        }
        this(string2);
    }

    public ResDownloadUtils() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$fetchAsync(ResDownloadUtils $this, String url, String suffix, ICommonCallback callback) {
        $this.fetchAsync(url, suffix, callback);
    }

    public static final /* synthetic */ void access$handleSuccess(ResDownloadUtils $this, String url, String path) {
        $this.handleSuccess(url, path);
    }

    public static final /* synthetic */ void access$handleFail(ResDownloadUtils $this, String url, int code, String msg) {
        $this.handleFail(url, code, msg);
    }

    public static final /* synthetic */ void access$handleTimeout(ResDownloadUtils $this, FetchTask task2, int code, String msg) {
        $this.handleTimeout(task2, code, msg);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/yy/appbase/service/dres/ResDownloadUtils$Companion;", "", "()V", "DIR", "", "TAG", "TIMEOUT", "", "appbase_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

