/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.helper;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.NonNull;
import com.yy.appbase.R;
import com.yy.appbase.permission.AndPermission;
import com.yy.appbase.permission.Permission;
import com.yy.appbase.permission.SettingService;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelperUtil;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.NotificationsUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;

public class PermissionHelper {
    private static final String TAG = "PermissionHelper";
    private static boolean sLocationTipsDialogShowing = false;
    private static boolean sContactTipsDialogShowing = false;

    public static boolean hasContactUserTipShow() {
        return SettingFlags.getBoolean((String)"show_contacts_use_tips", (boolean)false);
    }

    public static boolean hasLocationTipShow() {
        return RuntimeContext.isHagoPartySdk() || SettingFlags.getBoolean((String)"show_location_tips", (boolean)false);
    }

    public static boolean hasQuizContactUserTipShow() {
        return SettingFlags.getBoolean((String)"show_quiz_contacts_use_tips", (boolean)false);
    }

    public static boolean hasLocationPermissionNotRequest(Activity activity) {
        return PermissionHelper.hasLocationPermissionInner(activity);
    }

    public static boolean hasLocationPermission(Activity activity) {
        if (RuntimeContext.isHagoPartySdk()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return PermissionHelper.hasLocationPermissionInner(activity);
        }
        if (sLocationTipsDialogShowing) {
            return false;
        }
        sLocationTipsDialogShowing = true;
        boolean hasShow = PermissionHelper.hasLocationTipShow();
        if (hasShow) {
            String[] permissions = Permission.Group.LOCATION;
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"hasContactPermission", (Object[])new Object[0]);
            }
            sLocationTipsDialogShowing = false;
            return PermissionHelperUtil.hasPermission(activity, permissions);
        }
        PermissionHelper.requestLocationPermissionInner(activity, new IPermissionListener(){

            @Override
            public void onPermissionGranted(@NonNull String[] permission) {
                sLocationTipsDialogShowing = false;
            }

            @Override
            public void onPermissionDenied(@NonNull String[] permission) {
                sLocationTipsDialogShowing = false;
            }
        }, ResourceUtils.getString((int)R.string.permission_location_access_illustate), false);
        return false;
    }

    private static boolean hasLocationPermissionInner(Activity activity) {
        String[] permissions = Permission.Group.LOCATION;
        return PermissionHelperUtil.hasPermission(activity, permissions);
    }

    public static void requestLocationPermission(Activity activity, IPermissionListener listener2, boolean forceRequest) {
        String[] permissions = Permission.Group.LOCATION;
        if (PermissionHelper.hasLocationPermission(activity)) {
            if (listener2 != null) {
                listener2.onPermissionGranted(permissions);
            }
            return;
        }
        boolean flag = PermissionHelper.hasLocationTipShow();
        if (flag) {
            if (forceRequest) {
                PermissionHelper.requestLocationPermissionInner(activity, listener2, "", false);
            } else if (listener2 != null) {
                listener2.onPermissionDenied(permissions);
            }
        } else {
            PermissionHelper.requestLocationPermissionInner(activity, listener2, ResourceUtils.getString((int)R.string.permission_location_access_illustate), false);
        }
    }

    public static void requestLocationPermission(Activity activity, IPermissionListener listener2, String illustateTip) {
        String[] permissions = Permission.Group.LOCATION;
        if (PermissionHelper.hasLocationPermission(activity)) {
            if (listener2 != null) {
                listener2.onPermissionGranted(permissions);
            }
            return;
        }
        String remindTip = "";
        String denyTip = ResourceUtils.getString((int)R.string.permission_location_settting_instructions);
        PermissionHelperUtil.requestPermission(activity, illustateTip, remindTip, denyTip, permissions, false, listener2);
    }

    private static void requestLocationPermissionInner(Activity activity, IPermissionListener listener2, String illustateTip, boolean fromHasPermission) {
        MLog.info((Object)TAG, (String)"checkLocationPermission", (Object[])new Object[0]);
        SettingFlags.setBoolean((String)"show_location_tips", (boolean)true);
        String[] permissions = Permission.Group.LOCATION;
        String remindTip = "";
        String denyTip = ResourceUtils.getString((int)R.string.permission_location_settting_instructions);
        PermissionHelperUtil.requestPermission(activity, illustateTip, remindTip, denyTip, permissions, fromHasPermission, listener2);
        MLog.info((Object)TAG, (String)"checkLocationPermission end", (Object[])new Object[0]);
    }

    public static void checkStoragePermission(Activity activity, IPermissionListener listener2) {
        MLog.info((Object)TAG, (String)"checkStoragePermission", (Object[])new Object[0]);
        String[] permissions = Permission.Group.STORAGE;
        String remindTip = "";
        String denyTip = ResourceUtils.getString((int)R.string.permission_storage_setting_instructions);
        PermissionHelperUtil.requestPermission(activity, "", remindTip, denyTip, permissions, listener2);
        MLog.info((Object)TAG, (String)"checkStoragePermission end", (Object[])new Object[0]);
    }

    public static void showStorageRemindDialog(final Activity activity, final IPermissionListener listener2) {
        DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)activity);
        OkCancelDialog tipsDialog = new OkCancelDialog(ResourceUtils.getString((int)R.string.permission_storage_access_suggestion), ResourceUtils.getString((int)R.string.contact_dialog_ok), ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, false, new OkCancelDialogListener(){

            @Override
            public void onCancel() {
                activity.finish();
            }

            @Override
            public void onOk() {
                PermissionHelper.checkStoragePermission(activity, listener2);
            }
        });
        tipsDialog.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                activity.finish();
            }
        });
        dialogLinkManager.showDialog((BaseDialog)tipsDialog);
    }

    public static void requestCameraPermission(Activity activity, IPermissionListener listener2) {
        MLog.info((Object)TAG, (String)"checkCameraPermission", (Object[])new Object[0]);
        String[] permissions = Permission.Group.CAMERA;
        String remindTip = ResourceUtils.getString((int)R.string.permission_camera_access_instructions);
        String denyTip = activity.getString(R.string.toast_no_camera_permission);
        PermissionHelperUtil.requestPermission(activity, "", remindTip, denyTip, permissions, listener2);
        MLog.info((Object)TAG, (String)"checkCameraPermission end", (Object[])new Object[0]);
    }

    public static void requestStoreAndCameraPermission(Activity activity, IPermissionListener listener2) {
        MLog.info((Object)TAG, (String)"requestStoreAndCameraPermission", (Object[])new Object[0]);
        String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
        String remindTip = ResourceUtils.getString((int)R.string.permission_camera_access_instructions);
        String denyTip = activity.getString(R.string.toast_no_camera_permission);
        PermissionHelperUtil.requestPermission(activity, "", remindTip, denyTip, permissions, listener2);
        MLog.info((Object)TAG, (String)"requestStoreAndCameraPermission end", (Object[])new Object[0]);
    }

    public static boolean hasCameraPermission(Activity activity) {
        MLog.info((Object)TAG, (String)"hasCameraPermission", (Object[])new Object[0]);
        String[] permissions = Permission.Group.CAMERA;
        return PermissionHelperUtil.hasPermission(activity, permissions);
    }

    public static void requestRecordAudioPermission(Activity activity, IPermissionListener listener2) {
        MLog.info((Object)TAG, (String)"checkRecordAudioPermission", (Object[])new Object[0]);
        String[] permissions = Permission.Group.RECORD_AUDIO;
        String remindTip = ResourceUtils.getString((int)R.string.permissionhelper_record_audio_access_instructions);
        String denyTip = ResourceUtils.getString((int)R.string.permission_record_audio_setting_instructions);
        PermissionHelperUtil.requestPermission(activity, "", remindTip, denyTip, permissions, listener2);
        MLog.info((Object)TAG, (String)"checkRecordAudioPermission end", (Object[])new Object[0]);
    }

    public static void requestRecordAudioPermission(Activity activity, String remindTip, IPermissionListener listener2) {
        MLog.info((Object)TAG, (String)"checkRecordAudioPermission", (Object[])new Object[0]);
        String[] permissions = Permission.Group.RECORD_AUDIO;
        String denyTip = ResourceUtils.getString((int)R.string.permission_record_audio_setting_instructions);
        PermissionHelperUtil.requestPermission(activity, "", remindTip, denyTip, permissions, listener2);
        MLog.info((Object)TAG, (String)"checkRecordAudioPermission end", (Object[])new Object[0]);
    }

    public static boolean hasRecordAudioPermission(Activity activity) {
        if (activity == null) {
            return false;
        }
        String[] permissions = Permission.Group.RECORD_AUDIO;
        boolean doubleCheck = false;
        if (StringUtils.equal((String)(Build.BRAND + Build.DEVICE), (String)"")) {
            // empty if block
        }
        boolean result = PermissionHelperUtil.hasPermissioWithDoubleCheck(activity, permissions);
        MLog.info((Object)TAG, (String)"hasRecordAudioPermission %s %s", (Object[])new Object[]{result ? "true" : "false", Build.BRAND + Build.DEVICE});
        return result;
    }

    private static boolean hasContactPermissionInner(Activity activity) {
        String[] permissions = Permission.Group.CONTACTS_READ;
        boolean result = PermissionHelperUtil.hasPermission(activity, permissions);
        MLog.info((Object)TAG, (String)"hasContactPermissionInner %s", (Object[])new Object[]{result ? "true" : "false"});
        return result;
    }

    public static boolean hasContactPermission(Activity activity) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"hasContactPermission", (Object[])new Object[0]);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return PermissionHelper.hasContactPermissionInner(activity);
        }
        if (sContactTipsDialogShowing) {
            return false;
        }
        boolean hasShow = PermissionHelper.hasContactUserTipShow();
        if (hasShow) {
            String[] permissions = Permission.Group.CONTACTS_READ;
            sContactTipsDialogShowing = false;
            return PermissionHelperUtil.hasPermission(activity, permissions);
        }
        sContactTipsDialogShowing = true;
        String illustateTip = ResourceUtils.getString((int)R.string.contact_pemission_access_illustate);
        PermissionHelper.requestContactPermissionInner(activity, new IPermissionListener(){

            @Override
            public void onPermissionGranted(@NonNull String[] permission) {
                sContactTipsDialogShowing = false;
            }

            @Override
            public void onPermissionDenied(@NonNull String[] permission) {
                sContactTipsDialogShowing = false;
            }
        }, illustateTip, true);
        return false;
    }

    public static void requestContactPermission(Activity activity, IPermissionListener listener2) {
        String[] permissions = Permission.Group.CONTACTS_READ;
        boolean hasShow = PermissionHelper.hasContactUserTipShow();
        if (hasShow || sContactTipsDialogShowing) {
            if (PermissionHelper.hasContactPermission(activity)) {
                if (listener2 != null) {
                    listener2.onPermissionGranted(permissions);
                }
            } else {
                PermissionHelper.requestContactPermissionInner(activity, listener2, "", false);
            }
        } else {
            String illustateTip = ResourceUtils.getString((int)R.string.contact_pemission_access_illustate);
            PermissionHelper.requestContactPermissionInner(activity, listener2, illustateTip, false);
        }
    }

    public static void requestQuizContactPermission(Activity activity, IPermissionListener listener2) {
        String[] permissions = Permission.Group.CONTACTS_READ;
        boolean hasShow = PermissionHelper.hasQuizContactUserTipShow();
        if (hasShow || sContactTipsDialogShowing) {
            if (PermissionHelper.hasContactPermission(activity)) {
                if (listener2 != null) {
                    listener2.onPermissionGranted(permissions);
                }
            } else {
                PermissionHelper.requestContactPermissionInner(activity, listener2, "", false);
            }
        } else {
            String illustateTip = ResourceUtils.getString((int)R.string.summary_quiz_contact_permission);
            PermissionHelper.requestContactPermissionInner(activity, listener2, illustateTip, false);
        }
    }

    private static void requestContactPermissionInner(Activity activity, IPermissionListener listener2, String illustateTip, boolean fromHasPermission) {
        MLog.info((Object)TAG, (String)"checkContactPermission", (Object[])new Object[0]);
        String[] permissions = Permission.Group.CONTACTS_READ;
        String remindTip = "";
        String denyTip = ResourceUtils.getString((int)R.string.contact_pemission_tips);
        PermissionHelperUtil.requestPermission(activity, illustateTip, remindTip, denyTip, permissions, fromHasPermission, listener2);
    }

    @SuppressLint(value={"NewApi"})
    public static boolean checkNotificationPermission(Context context) {
        return NotificationsUtils.isNotificationEnabled((Context)RuntimeContext.sApplicationContext);
    }

    public static boolean checkShortCutPermission(Activity activity) {
        return PermissionHelperUtil.hasPermissioWithDoubleCheck(activity, "com.android.launcher.permission.INSTALL_SHORTCUT");
    }

    public static void actionToPermissionSetttingPager(Activity activity) {
        SettingService settingService = AndPermission.permissionSetting(activity);
        settingService.execute();
    }

    public static boolean hasFloatWinPermission(Activity activity) {
        MLog.info((Object)TAG, (String)"hasFloatWinPermission", (Object[])new Object[0]);
        if (Build.VERSION.SDK_INT >= 23) {
            MLog.info((Object)TAG, (String)("Build.VERSION_CODES$" + Build.VERSION.SDK_INT), (Object[])new Object[0]);
            if ("vivo".equalsIgnoreCase(Build.MANUFACTURER) && Build.VERSION.SDK_INT < 28) {
                int query = PermissionHelper.getVivoFloatPermissionStatus((Context)activity);
                MLog.info((Object)TAG, (String)("query " + query), (Object[])new Object[0]);
                if (query == 0) {
                    MLog.info((Object)TAG, (String)"hasFloatWinPermission", (Object[])new Object[0]);
                    return true;
                }
                return false;
            }
            return Settings.canDrawOverlays((Context)activity);
        }
        return true;
    }

    public static boolean filterVivoDevice() {
        return "vivo".equalsIgnoreCase(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 28;
    }

    public static void gotoSetFloatWinPermission(Activity activity) {
        MLog.info((Object)TAG, (String)"gotoSetFloatWinPermission", (Object[])new Object[0]);
        if (Build.VERSION.SDK_INT >= 23) {
            if ("vivo".equalsIgnoreCase(Build.MANUFACTURER)) {
                if (!PermissionHelper.gotoVivoFuntouchFloatWinSetting(activity)) {
                    PermissionHelper.gotoFloatWinSetting(activity);
                }
            } else {
                PermissionHelper.gotoFloatWinSetting(activity);
            }
        }
    }

    private static boolean gotoVivoFuntouchFloatWinSetting(Activity activity) {
        MLog.info((Object)TAG, (String)"gotoVivoFuntouchFloatWinSetting", (Object[])new Object[0]);
        Intent intent = new Intent();
        intent.setPackage("com.vivo.permissionmanager");
        intent.setAction("com.iqoo.secure.FLOATWINDOWMANAGER");
        if (PermissionHelper.isIntentAvailable((Context)activity, intent)) {
            activity.startActivity(intent);
            return true;
        }
        return false;
    }

    private static boolean isIntentAvailable(Context context, Intent intent) {
        return context.getPackageManager().resolveActivity(intent, 64) != null;
    }

    private static void gotoFloatWinSetting(Activity activity) {
        MLog.info((Object)TAG, (String)"gotoFloatWinSetting", (Object[])new Object[0]);
        try {
            activity.startActivityForResult(new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + RuntimeContext.sApplicationContext.getPackageName()))), 99);
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"open float win exception", (Object[])new Object[0]);
        }
    }

    public static int getVivoFloatPermissionStatus(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        String packageName = context.getPackageName();
        Uri uri = Uri.parse((String)"content://com.iqoo.secure.provider.secureprovider/allowfloatwindowapp");
        String selection = "pkgname = ?";
        String[] selectionArgs = new String[]{packageName};
        Cursor cursor = context.getContentResolver().query(uri, null, selection, selectionArgs, null);
        if (cursor != null) {
            cursor.getColumnNames();
            if (cursor.moveToFirst()) {
                int currentmode = cursor.getInt(cursor.getColumnIndex("currentlmode"));
                cursor.close();
                return currentmode;
            }
            cursor.close();
            return PermissionHelper.getVivoFloatPermissionStatus2(context);
        }
        return PermissionHelper.getVivoFloatPermissionStatus2(context);
    }

    private static int getVivoFloatPermissionStatus2(Context context) {
        String packageName = context.getPackageName();
        Uri uri2 = Uri.parse((String)"content://com.vivo.permissionmanager.provider.permission/float_window_apps");
        String selection = "pkgname = ?";
        String[] selectionArgs = new String[]{packageName};
        Cursor cursor = context.getContentResolver().query(uri2, null, selection, selectionArgs, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                int currentmode = cursor.getInt(cursor.getColumnIndex("currentmode"));
                cursor.close();
                return currentmode;
            }
            cursor.close();
            return 1;
        }
        return 1;
    }
}

