/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.checker;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import androidx.annotation.RequiresPermission;
import com.yy.appbase.permission.checker.PermissionTest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;

public class LocationTest
implements PermissionTest {
    private static LocationTestInner sLocationTestInner = new LocationTestInner();

    public LocationTest(Context context) {
    }

    @Override
    public boolean test() throws Throwable {
        return sLocationTestInner.test();
    }

    private static class LocationTestInner
    implements PermissionTest,
    INotify {
        private volatile boolean mHasLocationPer = true;
        private volatile boolean mHasTest = false;
        private volatile LocationListener mLocationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };

        LocationTestInner() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
                }
            });
        }

        @Override
        @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
        public synchronized boolean test() throws Throwable {
            block4: {
                if (this.mHasTest) {
                    return this.mHasLocationPer;
                }
                LocationManager locationManager = null;
                try {
                    this.mHasLocationPer = true;
                    locationManager = SystemServiceUtils.getLocationManager((Context)RuntimeContext.sApplicationContext);
                    locationManager.requestLocationUpdates("gps", 10000L, 10000.0f, this.mLocationListener);
                    locationManager.removeUpdates(this.mLocationListener);
                    MLog.info((Object)"LocationTest", (String)"location true", (Object[])new Object[0]);
                }
                catch (Throwable e) {
                    this.mHasLocationPer = false;
                    if (locationManager != null) {
                        locationManager.removeUpdates(this.mLocationListener);
                    }
                    if (!RuntimeContext.sIsDebuggable) break block4;
                    MLog.error((Object)"LocationTest", (Throwable)e);
                }
            }
            this.mHasTest = true;
            return this.mHasLocationPer;
        }

        public void notify(Notification notification) {
            if (notification == null || notification.id != NotificationDef.N_FOREGROUND_CHANGE) {
                return;
            }
            if (notification.extObj instanceof Boolean && ((Boolean)notification.extObj).booleanValue()) {
                this.mHasTest = false;
            }
        }
    }
}

