/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.checker;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import com.yy.appbase.permission.checker.PermissionTest;

class ContactsWriteTest
implements PermissionTest {
    private static final String DISPLAY_NAME = "PERMISSION";
    private ContentResolver mResolver;

    ContactsWriteTest(ContentResolver resolver) {
        this.mResolver = resolver;
    }

    @Override
    public boolean test() throws Throwable {
        Cursor cursor = this.mResolver.query(ContactsContract.Data.CONTENT_URI, new String[]{"raw_contact_id"}, "mimetype=? and data1=?", new String[]{"vnd.android.cursor.item/name", DISPLAY_NAME}, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                long rawContactId = cursor.getLong(0);
                cursor.close();
                return this.update(rawContactId);
            }
            cursor.close();
            return this.insert();
        }
        return false;
    }

    private boolean insert() {
        ContentValues values = new ContentValues();
        Uri rawContractUri = this.mResolver.insert(ContactsContract.RawContacts.CONTENT_URI, values);
        long rawContactId = ContentUris.parseId((Uri)rawContractUri);
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("data1", DISPLAY_NAME);
        values.put("data2", DISPLAY_NAME);
        values.put("mimetype", "vnd.android.cursor.item/name");
        Uri dataUri = this.mResolver.insert(ContactsContract.Data.CONTENT_URI, values);
        return ContentUris.parseId((Uri)dataUri) > 0L;
    }

    private void delete(long contactId, long dataId) {
        this.mResolver.delete(ContactsContract.RawContacts.CONTENT_URI, "_id=?", new String[]{Long.toString(contactId)});
        this.mResolver.delete(ContactsContract.Data.CONTENT_URI, "_id=?", new String[]{Long.toString(dataId)});
    }

    private boolean update(long rawContactId) {
        ContentValues values = new ContentValues();
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("data1", DISPLAY_NAME);
        values.put("data2", DISPLAY_NAME);
        values.put("mimetype", "vnd.android.cursor.item/name");
        Uri dataUri = this.mResolver.insert(ContactsContract.Data.CONTENT_URI, values);
        return ContentUris.parseId((Uri)dataUri) > 0L;
    }
}

