/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.pagechange;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.commoneventreport.CommonEventName;
import com.yy.appbase.commoneventreport.CommonEventReportService;
import com.yy.appbase.commoneventreport.ReportEvent;
import com.yy.appbase.pagechange.PageStateReportService;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\fH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0004J\u0012\u0010'\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0002JD\u0010)\u001a\u00020%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2.\u0010+\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a0\u0017j\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a`\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0017j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\u0019\u001a.\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a\u0018\u00010\u0017j\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a\u0018\u0001`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/yy/appbase/pagechange/PageStateReportService;", "", "()V", "KEY_FROM", "", "KEY_STAY", "KEY_STAY_DURATION", "KEY_TO", "KEY_UID", "TAG", "mCurrentDurationList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "mCurrentWindowName", "mDurationTask", "Ljava/lang/Runnable;", "getMDurationTask", "()Ljava/lang/Runnable;", "mDurationTask$delegate", "Lkotlin/Lazy;", "mLastDuration", "mLastWindowName", "mNeedReportPageMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "mPageStayReportList", "", "showTime", "", "createPageChangeReportEvent", "Lcom/yy/appbase/commoneventreport/ReportEvent;", "fromWindow", "toWindow", "duration", "createPageStayReportEvent", "pageName", "onWindowShown", "", "shownWindow", "startCalculateDuration", "name", "updatePageStateReportConfig", "pageArr", "pageStateMap", "appbase_debug"})
public final class PageStateReportService {
    private static final String TAG = "PageChangeService";
    private static final String KEY_FROM = "from";
    private static final String KEY_TO = "to";
    private static final String KEY_UID = "uid";
    private static final String KEY_STAY = "stay";
    private static final String KEY_STAY_DURATION = "duration";
    private static String mLastWindowName;
    private static String mCurrentWindowName;
    private static long showTime;
    private static int mLastDuration;
    private static CopyOnWriteArrayList<Integer> mCurrentDurationList;
    private static final Lazy mDurationTask$delegate;
    private static HashMap<String, String> mNeedReportPageMap;
    private static HashMap<String, List<Integer>> mPageStayReportList;
    public static final PageStateReportService INSTANCE;

    private final Runnable getMDurationTask() {
        Lazy lazy = mDurationTask$delegate;
        PageStateReportService pageStateReportService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Runnable)lazy.getValue();
    }

    public final void updatePageStateReportConfig(@NotNull List<String> pageArr, @NotNull HashMap<String, List<Integer>> pageStateMap) {
        Intrinsics.checkParameterIsNotNull(pageArr, (String)"pageArr");
        Intrinsics.checkParameterIsNotNull(pageStateMap, (String)"pageStateMap");
        mNeedReportPageMap.clear();
        Iterable $this$forEach$iv = pageArr;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String page = (String)element$iv;
            boolean bl = false;
            ((Map)mNeedReportPageMap).put(page, page);
        }
        mPageStayReportList = pageStateMap;
    }

    public final void onWindowShown(@Nullable String shownWindow) {
        block6: {
            String enterWindow = shownWindow;
            if (RuntimeContext.isInGray()) {
                MLog.debug((Object)TAG, (String)"enter window=%s, current window=%s, last window=%s", (Object[])new Object[]{enterWindow, mCurrentWindowName, mLastWindowName});
            }
            if (enterWindow == null) {
                enterWindow = "";
            }
            if (Intrinsics.areEqual((Object)enterWindow, (Object)mCurrentWindowName)) {
                return;
            }
            mLastWindowName = mCurrentWindowName;
            long duration = showTime == 0L ? 0L : (System.currentTimeMillis() - showTime) / (long)1000;
            String from = mCurrentWindowName;
            mCurrentWindowName = enterWindow;
            showTime = System.currentTimeMillis();
            HashMap<String, List<Integer>> hashMap = mPageStayReportList;
            if (hashMap != null) {
                if (hashMap.containsKey(enterWindow)) {
                    mLastDuration = 0;
                    this.startCalculateDuration(shownWindow);
                }
            }
            if (!mNeedReportPageMap.containsKey(from) && !mNeedReportPageMap.containsKey(enterWindow)) {
                MLog.debug((Object)TAG, (String)("window=" + enterWindow + " needn't report"), (Object[])new Object[0]);
                return;
            }
            MLog.debug((Object)TAG, (String)("report page change event from=" + from + ", to=" + enterWindow + ", duration=" + duration), (Object[])new Object[0]);
            ReportEvent reportEvent2 = this.createPageChangeReportEvent(from, enterWindow, (int)duration);
            if (reportEvent2 == null) break block6;
            ReportEvent reportEvent3 = reportEvent2;
            boolean bl = false;
            boolean bl2 = false;
            ReportEvent it = reportEvent3;
            boolean bl3 = false;
            CommonEventReportService.INSTANCE.reportEvent(it);
        }
    }

    private final ReportEvent createPageChangeReportEvent(String fromWindow, String toWindow, int duration) {
        try {
            JSONObject dataJs = JsonParser.obtainJSONObject();
            dataJs.put(KEY_FROM, (Object)fromWindow);
            dataJs.put(KEY_TO, (Object)toWindow);
            dataJs.put(KEY_UID, AccountUtil.getUid());
            dataJs.put(KEY_STAY_DURATION, duration);
            String string2 = dataJs.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dataJs.toString()");
            return new ReportEvent(CommonEventName.PAGE_CHANGED, string2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final ReportEvent createPageStayReportEvent(String pageName, int duration) {
        try {
            JSONObject dataJs = JsonParser.obtainJSONObject();
            dataJs.put(KEY_STAY, (Object)pageName);
            dataJs.put(KEY_STAY_DURATION, duration);
            String string2 = dataJs.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dataJs.toString()");
            return new ReportEvent(CommonEventName.PAGE_STAY, string2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void startCalculateDuration(String name) {
        block7: {
            block6: {
                if (name == null || FP.empty((Map)mPageStayReportList)) break block6;
                HashMap<String, List<Integer>> hashMap = mPageStayReportList;
                if (hashMap == null) {
                    Intrinsics.throwNpe();
                }
                if (!FP.empty((Collection)hashMap.get(name))) break block7;
            }
            return;
        }
        HashMap<String, List<Integer>> hashMap = mPageStayReportList;
        if (hashMap == null) {
            Intrinsics.throwNpe();
        }
        mCurrentDurationList = new CopyOnWriteArrayList(hashMap.get(name));
        Collection collection = mCurrentDurationList;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            Integer duration = mCurrentDurationList.remove(0);
            YYTaskExecutor.postToMainThread((Runnable)this.getMDurationTask(), (long)((long)duration.intValue() * 1000L));
            Integer n = duration;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)KEY_STAY_DURATION);
            mLastDuration = n;
        }
    }

    private PageStateReportService() {
    }

    static {
        PageStateReportService pageStateReportService;
        INSTANCE = pageStateReportService = new PageStateReportService();
        mLastWindowName = "";
        mCurrentWindowName = "";
        mCurrentDurationList = new CopyOnWriteArrayList();
        mDurationTask$delegate = LazyKt.lazy((Function0)mDurationTask.2.INSTANCE);
        mNeedReportPageMap = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"HomePageNew#Channel", (Object)"HomePageNew#Channel"), TuplesKt.to((Object)"HomePage", (Object)"HomePage"), TuplesKt.to((Object)"ChatSession", (Object)"ChatSession")});
    }

    public static final /* synthetic */ ReportEvent access$createPageStayReportEvent(PageStateReportService $this, String pageName, int duration) {
        return $this.createPageStayReportEvent(pageName, duration);
    }

    public static final /* synthetic */ String access$getMCurrentWindowName$p(PageStateReportService $this) {
        PageStateReportService pageStateReportService = $this;
        return mCurrentWindowName;
    }

    public static final /* synthetic */ void access$setMCurrentWindowName$p(PageStateReportService $this, String string2) {
        PageStateReportService pageStateReportService = $this;
        mCurrentWindowName = string2;
    }

    public static final /* synthetic */ int access$getMLastDuration$p(PageStateReportService $this) {
        PageStateReportService pageStateReportService = $this;
        return mLastDuration;
    }

    public static final /* synthetic */ void access$setMLastDuration$p(PageStateReportService $this, int n) {
        PageStateReportService pageStateReportService = $this;
        mLastDuration = n;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getMCurrentDurationList$p(PageStateReportService $this) {
        PageStateReportService pageStateReportService = $this;
        return mCurrentDurationList;
    }

    public static final /* synthetic */ void access$setMCurrentDurationList$p(PageStateReportService $this, CopyOnWriteArrayList copyOnWriteArrayList) {
        PageStateReportService pageStateReportService = $this;
        mCurrentDurationList = copyOnWriteArrayList;
    }

    public static final /* synthetic */ Runnable access$getMDurationTask$p(PageStateReportService $this) {
        return $this.getMDurationTask();
    }
}

