/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.kvomodule;

import com.yy.appbase.kvomodule.BaseModule;
import com.yy.appbase.kvomodule.IKvoModule;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
public class KvoModuleManager {
    private static final String TAG = "KvoModuleManager";
    private static IServiceManager gService;
    private static Environment gEnv;
    private static final Map<Class<? extends IKvoModule>, IKvoModule> gModules;
    private static final Map<Class<? extends IKvoModule>, ModuleFetcher> gModuleFetchers;
    private static final List<IKvoModule> sModulesEnvCaches;
    private static volatile boolean sKvoInited;
    private static volatile boolean sKvoInitEnved;
    private static ArrayList<InitEnvCallback> sInitEnvCallbacks;

    private KvoModuleManager() {
    }

    public static boolean isKvoInitEnved() {
        return sKvoInitEnved;
    }

    public static boolean isInited() {
        return sKvoInited && sKvoInitEnved;
    }

    private static void checkInit() {
        if (!sKvoInited && RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, (String)"checkInit fail", (Object[])new Object[0]);
            throw new IllegalStateException("call init first");
        }
    }

    private static void checkInitEnv() {
        if (!sKvoInitEnved && RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, (String)"checkInitEnv fail", (Object[])new Object[0]);
            throw new IllegalStateException("call initEnv first");
        }
    }

    private static void checkThread() {
        if (!YYTaskExecutor.isMainThread()) {
            throw new IllegalStateException("should call in UI thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitEnv(IKvoModule module) {
        List<IKvoModule> list = sModulesEnvCaches;
        synchronized (list) {
            if (!sModulesEnvCaches.contains(module)) {
                if (RuntimeContext.isInGray()) {
                    MLog.error((Object)TAG, (String)"ensureInitEnv module : %s", (Object[])new Object[]{module});
                }
                if (gService == null) {
                    gService = ServiceManagerProxy.getServiceManager();
                }
                module.onCreate(gService, gEnv);
                sModulesEnvCaches.add(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compat() {
        Class<UserInfoModule> clazz = UserInfoModule.class;
        synchronized (UserInfoModule.class) {
            KvoModuleManager.getModule(UserInfoModule.class, false).onCreate(gService, gEnv);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <Module extends IKvoModule> Module getModule(Class<Module> moduleClass, boolean checkEnv) {
        Class<Module> clazz = moduleClass;
        synchronized (clazz) {
            IKvoModule cacheModule;
            KvoModuleManager.checkInit();
            if (checkEnv && moduleClass != UserInfoModule.class) {
                KvoModuleManager.checkInitEnv();
            }
            MLog.debug((Object)TAG, (String)"getModule : %s", (Object[])new Object[]{moduleClass});
            if (gModules.containsKey(moduleClass) && (cacheModule = gModules.get(moduleClass)) != null) {
                KvoModuleManager.ensureInitEnv(cacheModule);
                return (Module)cacheModule;
            }
            MLog.debug((Object)TAG, (String)"getModule from fetcher: %s", (Object[])new Object[]{moduleClass});
            ModuleFetcher fetcher = gModuleFetchers.get(moduleClass);
            if (fetcher != null) {
                Object module = fetcher.getModule();
                KvoModuleManager.ensureInitEnv(module);
                gModules.put((Class<? extends IKvoModule>)moduleClass, (IKvoModule)module);
                return module;
            }
            MLog.error((Object)TAG, (String)"getModule fetcher is null: %s", (Object[])new Object[]{moduleClass});
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException(String.format("fetcher is null: %s , please call registerModule first", moduleClass));
            }
            return null;
        }
    }

    public static <Module extends IKvoModule> Module getModule(Class<Module> moduleClass) {
        return KvoModuleManager.getModule(moduleClass, true);
    }

    public static KvoSource getModuleData(Class<? extends IKvoModule> module) {
        IKvoModule obj = KvoModuleManager.getModule(module);
        if (obj != null && obj instanceof BaseModule) {
            return ((BaseModule)obj).getData();
        }
        return null;
    }

    public static <T extends IKvoModule> void registerModule(Class<T> moduleClass, ModuleFetcher<T> fetcher) {
        KvoModuleManager.checkThread();
        MLog.debug((Object)TAG, (String)"registerModule moudle=%s, fetcher=%s", (Object[])new Object[]{moduleClass, fetcher});
        if (moduleClass != null && fetcher != null && !gModuleFetchers.containsKey(moduleClass)) {
            gModuleFetchers.put(moduleClass, fetcher);
        }
    }

    public static void init(IServiceManager serviceManager, Environment evn) {
        KvoModuleManager.checkThread();
        if (sKvoInited) {
            MLog.info((Object)TAG, (String)"KvoModuleManger has init ", (Object[])new Object[0]);
            return;
        }
        gService = serviceManager;
        gEnv = evn;
        MLog.info((Object)TAG, (String)"KvoModuleManger init", (Object[])new Object[0]);
        sKvoInited = true;
    }

    public static void initEnv() {
        KvoModuleManager.initEnv(null);
    }

    public static void initEnv(InitEnvCallback initEnvCallback) {
        KvoModuleManager.checkThread();
        KvoModuleManager.checkInit();
        if (sKvoInitEnved) {
            MLog.info((Object)TAG, (String)"KvoModuleManger has initEnv ", (Object[])new Object[0]);
            if (initEnvCallback != null) {
                initEnvCallback.onInitEnv();
            }
            return;
        }
        if (gService != null && gEnv != null) {
            for (Class clazz : gModuleFetchers.keySet()) {
                Object module = KvoModuleManager.getModule(clazz, false);
                if (module == null) continue;
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)TAG, (String)"initEnv:  %s", (Object[])new Object[]{module});
                }
                KvoModuleManager.ensureInitEnv(module);
            }
        }
        sKvoInitEnved = true;
        if (initEnvCallback != null) {
            initEnvCallback.onInitEnv();
        }
        if (sInitEnvCallbacks != null) {
            for (InitEnvCallback initEnvCallback2 : sInitEnvCallbacks) {
                initEnvCallback2.onInitEnv();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinit() {
        KvoModuleManager.checkThread();
        sKvoInited = false;
        gService = null;
        gEnv = null;
        Collection<IKvoModule> modules = gModules.values();
        for (IKvoModule service2 : modules) {
            service2.onDestroy();
        }
        gModules.clear();
        gModuleFetchers.clear();
        List<IKvoModule> list = sModulesEnvCaches;
        synchronized (list) {
            sModulesEnvCaches.clear();
        }
        if (sInitEnvCallbacks != null) {
            sInitEnvCallbacks.clear();
            sInitEnvCallbacks = null;
        }
    }

    public static void autoBindingToModuleData(Class<? extends IKvoModule> source, Object target) {
        Object data2;
        KvoModuleManager.checkThread();
        if (source == null) {
            return;
        }
        IKvoModule module = KvoModuleManager.getModule(source);
        if (module != null && (data2 = module.getData()) instanceof KvoSource) {
            Kvo.autoBindingTo((KvoSource)((KvoSource)data2), (Object)target);
        }
    }

    public static void addInitEnvCallback(InitEnvCallback initEnvCallback) {
        KvoModuleManager.checkThread();
        if (initEnvCallback == null) {
            return;
        }
        if (KvoModuleManager.isKvoInitEnved()) {
            initEnvCallback.onInitEnv();
        } else {
            if (sInitEnvCallbacks == null) {
                sInitEnvCallbacks = new ArrayList();
            }
            sInitEnvCallbacks.add(initEnvCallback);
        }
    }

    static {
        gModules = new HashMap<Class<? extends IKvoModule>, IKvoModule>();
        gModuleFetchers = new ConcurrentHashMap<Class<? extends IKvoModule>, ModuleFetcher>();
        sModulesEnvCaches = new ArrayList<IKvoModule>();
        sKvoInited = false;
        sKvoInitEnved = false;
        sInitEnvCallbacks = null;
    }

    public static interface ModuleFetcher<Module extends IKvoModule> {
        public Module getModule();
    }

    public static interface InitEnvCallback {
        public void onInitEnv();
    }
}

