/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http;

import android.content.Context;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.okhttp.GraceWrapper;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.grace.Headers;
import com.yy.grace.Request;
import com.yy.grace.networkinterceptor.BizScenc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class GraceInterceptor
extends GraceWrapper.BaseGraceInterceptor {
    private static final String TAG = "GraceInterceptor";

    public com.yy.grace.Request<?> intercept(com.yy.grace.Request<?> request) {
        Request.Builder build = request.newBuilder();
        Request.Group group2 = request.group();
        int groupValue = group2 != null ? group2.group() : BizScenc.NONE.group();
        String oldUrl = request.url().toString();
        HashMap<String, String> addMap = new HashMap<String, String>();
        ArrayList<String> removeList = new ArrayList<String>(0);
        boolean needReplaceHttp = CommonHttpHeader.checkHttpHeaderUpdate(oldUrl, request.url().host(), request.tag(), addMap, removeList, SystemUtils.isShowEnvSetting() ? request.headers().toString() : "", groupValue);
        Headers requestHeaders = request.headers();
        boolean notReplaceCustomHeader = requestHeaders != null && StringUtils.equal((String)"1", (String)requestHeaders.get("not_replace_custom_header"));
        boolean needAdd = false;
        Set requestHeaderKeys = requestHeaders != null ? requestHeaders.names() : null;
        for (Map.Entry entry : addMap.entrySet()) {
            needAdd = true;
            if (requestHeaderKeys != null && requestHeaderKeys.size() > 0 && notReplaceCustomHeader) {
                for (String requestKey : requestHeaderKeys) {
                    if (requestKey == null || !StringUtils.endsWithIgnoreCase((String)requestKey, (String)((String)entry.getKey())) || requestHeaders.get(requestKey) == null) continue;
                    needAdd = false;
                    break;
                }
            }
            if (!needAdd || groupValue == BizScenc.WEB.group() && request.headers().get((String)entry.getKey()) != null) continue;
            build.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        for (String remove : removeList) {
            build.removeHeader(remove);
        }
        build.removeHeader("not_replace_custom_header");
        String newUrl = this.checkGetNewUrl(oldUrl, request.url().host(), needReplaceHttp);
        if (StringUtils.equal((String)oldUrl, (String)newUrl)) {
            return build.build();
        }
        return build.url(newUrl).build();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request.Builder build = originalRequest.newBuilder();
        String oldUrl = originalRequest.url().toString();
        HashMap<String, String> addMap = new HashMap<String, String>();
        ArrayList<String> removeList = new ArrayList<String>(0);
        boolean needReplaceHttp = CommonHttpHeader.checkHttpHeaderUpdate(oldUrl, originalRequest.url().host(), originalRequest.tag(), addMap, removeList, SystemUtils.isShowEnvSetting() ? originalRequest.headers().toString() : "", BizScenc.NONE.group());
        okhttp3.Headers requestHeaders = originalRequest.headers();
        boolean needAdd = false;
        Set requestHeaderKeys = requestHeaders != null ? requestHeaders.names() : null;
        boolean notReplaceCustomHeader = requestHeaders != null && StringUtils.equal((String)"1", (String)requestHeaders.get("not_replace_custom_header"));
        for (Map.Entry entry : addMap.entrySet()) {
            needAdd = true;
            if (requestHeaderKeys != null && requestHeaderKeys.size() > 0 && notReplaceCustomHeader) {
                for (String requestKey : requestHeaderKeys) {
                    if (requestKey == null || !StringUtils.endsWithIgnoreCase((String)requestKey, (String)((String)entry.getKey())) || requestHeaders.get(requestKey) == null) continue;
                    needAdd = false;
                    break;
                }
            }
            if (!needAdd) continue;
            build.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        for (String remove : removeList) {
            build.removeHeader(remove);
        }
        build.removeHeader("not_replace_custom_header");
        String newUrl = this.checkGetNewUrl(oldUrl, originalRequest.url().host(), needReplaceHttp);
        if (StringUtils.equal((String)oldUrl, (String)newUrl)) {
            originalRequest = build.build();
        } else {
            originalRequest = build.url(newUrl).build();
            MLog.debug((Object)"HttpInterceptor", (String)("originHttpUrl: " + oldUrl + ", originHost: " + originalRequest.url().host() + ", newUrl: " + newUrl), (Object[])new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("URL\u57df\u540d\u66ff\u6362\uff0c\u539f\u59cbHOST\uff1a" + originalRequest.url().host() + ", \u65b0URL\uff1a" + newUrl), (int)1);
            }
        }
        return chain.proceed(originalRequest);
    }

    private String checkGetNewUrl(String oldUrl, String oldHost, boolean needReplace) {
        String newUrl = URLUtils.replaceUrl((String)oldUrl, (String)oldHost);
        if (newUrl.startsWith("http://") && needReplace) {
            newUrl = URLUtils.replaceHttpByConfig((String)newUrl, (String)oldHost);
            MLog.debug((Object)TAG, (String)"http request %s, be careful, newUrl:%s!", (Object[])new Object[]{oldUrl, newUrl});
        }
        if (SystemUtils.isShowEnvSetting() && newUrl != null && !newUrl.contains("/ymicro/api")) {
            PerfActionLog.add((String)"Net_url:%s", (Object[])new Object[]{newUrl});
        }
        return newUrl;
    }
}

