/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.growth;

import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.IABConfig;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.base.logger.MLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005J\b\u0010\u0012\u001a\u00020\u0010H\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J\b\u0010#\u001a\u00020\u001dH\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0017H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0010\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\bH\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/yy/appbase/growth/BaseGrowth;", "Lcom/yy/appbase/unifyconfig/IConfigListener;", "Lcom/yy/appbase/unifyconfig/config/AConfigData;", "()V", "mBindABConfig", "Lcom/yy/appbase/abtest/IABConfig;", "mLastConfig", "mTag", "", "getMTag", "()Ljava/lang/String;", "setMTag", "(Ljava/lang/String;)V", "mTest", "Lcom/yy/appbase/abtest/IAB;", "bindABConfig", "", "abConfig", "cleanAB", "getAccount", "", "getBindABConfig", "getConfig", "Lcom/yy/appbase/unifyconfig/config/GrowthBusinessConfig;", "bssCode", "Lcom/yy/appbase/unifyconfig/BssCode;", "getConfigOrDefault", "getCurrentAB", "isGuest", "", "isLogin", "isNewUser", "matchA", "matchB", "matchC", "matchD", "onConfigUpdate", "config", "onOtherConfigUpdate", "onUpdateConfig", "data", "setTag", "tag", "appbase_debug"})
public abstract class BaseGrowth
implements IConfigListener<AConfigData> {
    @NotNull
    private String mTag = "BaseGrowth";
    private IAB mTest;
    private AConfigData mLastConfig;
    private IABConfig<?> mBindABConfig;

    @NotNull
    protected final String getMTag() {
        return this.mTag;
    }

    protected final void setMTag(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.mTag = string2;
    }

    public void onConfigUpdate(@NotNull GrowthBusinessConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
    }

    public void onOtherConfigUpdate(@NotNull AConfigData config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
    }

    protected final void setTag(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.mTag = tag;
    }

    public final boolean isLogin() {
        return AccountUtil.getUid() > 0L;
    }

    public final boolean isNewUser() {
        return AccountUtil.isTodayRegister();
    }

    public final boolean isGuest() {
        return AccountUtil.isLoginByGuest();
    }

    public final long getAccount() {
        return AccountUtil.getUid();
    }

    public final void bindABConfig(@NotNull IABConfig<?> abConfig) {
        Intrinsics.checkParameterIsNotNull(abConfig, (String)"abConfig");
        MLog.debug((Object)this.mTag, (String)("bind ab config: " + abConfig.getTestId()), (Object[])new Object[0]);
        this.mBindABConfig = abConfig;
    }

    @Nullable
    public final IABConfig<?> getBindABConfig() {
        return this.mBindABConfig;
    }

    @Nullable
    public final IAB getCurrentAB() {
        IABConfig<?> abConfig = this.mBindABConfig;
        if (this.mTest == null) {
            IABConfig<?> iABConfig = abConfig;
            if (iABConfig != null) {
                if (iABConfig.isValid()) {
                    this.mTest = abConfig.getTest();
                }
            }
        }
        return this.mTest;
    }

    protected final void cleanAB() {
        this.mTest = null;
    }

    public boolean matchA() {
        IABConfig<?> iABConfig = this.mBindABConfig;
        return iABConfig != null ? iABConfig.matchA() : false;
    }

    public boolean matchB() {
        IABConfig<?> iABConfig = this.mBindABConfig;
        return iABConfig != null ? iABConfig.matchB() : false;
    }

    public boolean matchC() {
        IABConfig<?> iABConfig = this.mBindABConfig;
        return iABConfig != null ? iABConfig.matchC() : false;
    }

    public boolean matchD() {
        IABConfig<?> iABConfig = this.mBindABConfig;
        return iABConfig != null ? iABConfig.matchD() : false;
    }

    @Override
    public final void onUpdateConfig(@Nullable AConfigData data2) {
        if (this.mLastConfig != data2 && data2 != null) {
            this.mLastConfig = data2;
            if (data2 instanceof GrowthBusinessConfig) {
                this.onConfigUpdate((GrowthBusinessConfig)data2);
            } else {
                this.onOtherConfigUpdate(data2);
            }
        }
    }

    @NotNull
    public final GrowthBusinessConfig getConfigOrDefault() {
        GrowthBusinessConfig growthBusinessConfig = this.getConfig();
        if (growthBusinessConfig == null) {
            growthBusinessConfig = new GrowthBusinessConfig();
        }
        return growthBusinessConfig;
    }

    @Nullable
    public final GrowthBusinessConfig getConfig() {
        AConfigData config = this.getConfig(BssCode.GROWTH_BUSINESS);
        return config instanceof GrowthBusinessConfig ? (GrowthBusinessConfig)config : null;
    }

    @Nullable
    public final AConfigData getConfig(@NotNull BssCode bssCode) {
        AConfigData config;
        Intrinsics.checkParameterIsNotNull((Object)((Object)bssCode), (String)"bssCode");
        this.mLastConfig = config = UnifyConfig.INSTANCE.getConfigData(bssCode, this);
        return config;
    }
}

