/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db.orm.wrapper;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.db.orm.bean.KvoDbBean;
import com.yy.appbase.db.orm.wrapper.QueryFunction;
import com.yy.base.logger.MLog;
import io.objectbox.Property;
import io.objectbox.query.PropertyQuery;
import io.objectbox.query.Query;
import java.util.List;

public class QueryWrapper<T extends KvoDbBean> {
    private final Query<T> mQueryImpl;

    public QueryWrapper(@NonNull Query<T> queryImpl) {
        this.mQueryImpl = queryImpl;
    }

    public T findPrimary() {
        return (T)((Object)((KvoDbBean)((Object)this.mQueryImpl.findFirst())));
    }

    @Nullable
    public T findFirst() {
        return (T)((Object)((KvoDbBean)((Object)this.mQueryImpl.findFirst())));
    }

    @Nullable
    public T findUnique() {
        return (T)((Object)((KvoDbBean)((Object)this.mQueryImpl.findUnique())));
    }

    @NonNull
    public List<T> find() {
        return this.mQueryImpl.find();
    }

    @NonNull
    public List<T> find(long offset, long limit) {
        return this.mQueryImpl.find(offset, limit);
    }

    @NonNull
    public PropertyQuery property(@NonNull Property<T> property) {
        return this.mQueryImpl.property(property);
    }

    public long count() {
        return this.mQueryImpl.count();
    }

    public long remove() {
        try {
            return this.mQueryImpl.remove();
        }
        catch (Exception e) {
            MLog.error((Object)"QueryWrapper", (String)("remove : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
            return -1L;
        }
    }

    public QueryWrapper<T> setParameter(@NonNull QueryFunction queryFunction, @NonNull Property<T> property, @NonNull Object value) {
        queryFunction.setParameter(this.mQueryImpl, property, value);
        return this;
    }

    @NonNull
    public QueryWrapper<T> setParameter(@NonNull Property<T> property, @NonNull Object value) {
        return this.setParameter(QueryFunction.getFunction(value.getClass()), property, value);
    }
}

