/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db.orm.wrapper;

import androidx.annotation.NonNull;
import com.yy.appbase.db.orm.bean.KvoDbBean;
import com.yy.appbase.db.orm.wrapper.QueryFunction;
import com.yy.appbase.db.orm.wrapper.QueryWrapper;
import io.objectbox.Box;
import io.objectbox.Property;
import io.objectbox.query.QueryBuilder;
import java.util.Comparator;
import java.util.Date;

public class QueryBuilderWrapper<T extends KvoDbBean> {
    protected QueryBuilder<T> mBuilderImpl;

    public QueryBuilderWrapper(@NonNull Box<T> mBox) {
        this.mBuilderImpl = mBox.query();
    }

    public QueryBuilderWrapper<T> equal(@NonNull Property<T> property, @NonNull Object value) {
        QueryFunction.getFunction(value.getClass()).equal(this.mBuilderImpl, property, value);
        return this;
    }

    public QueryBuilderWrapper<T> notEqual(@NonNull Property<T> property, @NonNull Object value) {
        QueryFunction.getFunction(value.getClass()).notEqual(this.mBuilderImpl, property, value);
        return this;
    }

    public QueryBuilderWrapper<T> greater(@NonNull Property<T> property, @NonNull Object value) {
        QueryFunction.getFunction(value.getClass()).greater(this.mBuilderImpl, property, value);
        return this;
    }

    public QueryBuilderWrapper<T> less(@NonNull Property<T> property, @NonNull Object value) {
        QueryFunction.getFunction(value.getClass()).less(this.mBuilderImpl, property, value);
        return this;
    }

    public QueryBuilderWrapper<T> order(@NonNull Property<T> property, int flags) {
        this.mBuilderImpl.order(property, flags);
        return this;
    }

    public QueryBuilderWrapper<T> sort(Comparator<T> comparator) {
        this.mBuilderImpl.sort(comparator);
        return this;
    }

    public QueryBuilderWrapper<T> or() {
        this.mBuilderImpl.or();
        return this;
    }

    public QueryBuilderWrapper<T> and() {
        this.mBuilderImpl.and();
        return this;
    }

    public QueryBuilderWrapper<T> isNull(@NonNull Property<T> property) {
        this.mBuilderImpl.isNull(property);
        return this;
    }

    public QueryBuilderWrapper<T> notNull(@NonNull Property<T> property) {
        this.mBuilderImpl.notNull(property);
        return this;
    }

    public QueryBuilderWrapper<T> in(@NonNull Property<T> property, @NonNull long[] values) {
        this.mBuilderImpl.in(property, values);
        return this;
    }

    public QueryBuilderWrapper<T> in(@NonNull Property<T> property, @NonNull int[] values) {
        this.mBuilderImpl.in(property, values);
        return this;
    }

    public QueryBuilderWrapper<T> notIn(@NonNull Property<T> property, @NonNull long[] values) {
        this.mBuilderImpl.notIn(property, values);
        return this;
    }

    public QueryBuilderWrapper<T> notIn(@NonNull Property<T> property, @NonNull int[] values) {
        this.mBuilderImpl.notIn(property, values);
        return this;
    }

    public QueryBuilderWrapper<T> between(Property<T> property, long value1, long value2) {
        this.mBuilderImpl.between(property, value1, value2);
        return this;
    }

    public QueryBuilderWrapper<T> between(Property<T> property, Date value1, Date value2) {
        this.mBuilderImpl.between(property, value1, value2);
        return this;
    }

    public QueryWrapper<T> build() {
        return new QueryWrapper(this.mBuilderImpl.build());
    }
}

