/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db.orm;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.db.orm.JTableInfoBuilder;
import com.yy.appbase.db.orm.bean.KvoDbBean;
import com.yy.appbase.db.orm.wrapper.QueryBuilderWrapper;
import com.yy.appbase.db.orm.wrapper.QueryFunction;
import com.yy.appbase.db.orm.wrapper.QueryWrapper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.thread.ThreadBus;
import com.yy.base.utils.SystemUtils;
import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class JTableInfo<T extends KvoDbBean> {
    private static final String TAG_PREFIX = "JTableInfo_";
    @NonNull
    private final String mTag;
    @NonNull
    protected final BoxStore mStore;
    @NonNull
    protected final Box<T> mBox;
    @Nullable
    protected final Property<T> mPrimaryProperty;
    @Nullable
    protected final Field mPrimaryField;
    @Nullable
    private final QueryWrapper<T> mCachedPrimaryQuery;
    private final QueryFunction mPrimaryQueryFunction;
    private volatile boolean mIsWaiting = false;
    private final HashSet<T> mToSaveDatas = new HashSet();
    private final Object mBatchSaveLock = new byte[0];

    public JTableInfo(@NonNull JTableInfoBuilder<T> builder) {
        this.mTag = TAG_PREFIX + builder.entityClass.getSimpleName();
        this.mStore = builder.store;
        this.mBox = this.mStore.boxFor(builder.entityClass);
        this.mPrimaryProperty = builder.primaryProperty;
        this.mPrimaryField = this.buildPrimaryField();
        this.mPrimaryQueryFunction = this.buildPrimaryKeyQueryFunction();
        this.mCachedPrimaryQuery = this.buildPrimaryKeyQuery();
        if (!this.mPrimaryField.isAccessible()) {
            this.mPrimaryField.setAccessible(true);
        }
    }

    @Nullable
    public T get(@NonNull Object primaryValue) {
        return this.queryByPrimaryKey(primaryValue);
    }

    private T queryByPrimaryKey(@NonNull Object primaryValue) {
        return this.mCachedPrimaryQuery.setParameter(this.mPrimaryQueryFunction, this.mPrimaryProperty, primaryValue).findPrimary();
    }

    @NonNull
    public List<T> getAll() {
        ArrayList resultList;
        block3: {
            resultList = null;
            try {
                resultList = this.mBox.getAll();
            }
            catch (Throwable e) {
                MLog.error((Object)this.mTag, (String)("getAll: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                if (!SystemUtils.isShowEnvSetting()) break block3;
                throw new RuntimeException(this.mTag + " getAll error");
            }
        }
        if (resultList == null || resultList == Collections.EMPTY_LIST) {
            resultList = new ArrayList();
        }
        MLog.info((Object)this.mTag, (String)("getAll size: " + resultList.size()), (Object[])new Object[0]);
        return resultList;
    }

    public void deleteByPrimaryKey(@NonNull Object primaryValue) {
        ThreadBus.callThreadSafe((int)3, () -> this.mCachedPrimaryQuery.setParameter(this.mPrimaryQueryFunction, this.mPrimaryProperty, primaryValue).remove());
    }

    public void save(@NonNull T data2) {
        this.scheduleSave(Collections.singletonList(data2));
    }

    public void save(@NonNull Collection<T> datas) {
        this.scheduleSave(datas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSave(@NonNull Collection<T> datas) {
        MLog.info((Object)this.mTag, (String)("scheduleSave size: " + datas.size()), (Object[])new Object[0]);
        Object object = this.mBatchSaveLock;
        synchronized (object) {
            this.mToSaveDatas.addAll(datas);
            if (this.mIsWaiting) {
                return;
            }
            this.mIsWaiting = true;
        }
        ThreadBus.postDelayed((int)3, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList toSaveList;
                Object object = JTableInfo.this.mBatchSaveLock;
                synchronized (object) {
                    toSaveList = new ArrayList(JTableInfo.this.mToSaveDatas);
                    JTableInfo.this.mToSaveDatas.clear();
                    JTableInfo.this.mIsWaiting = false;
                }
                JTableInfo.this.doSave(toSaveList);
            }
        }, (long)700L);
    }

    private void doSave(@NonNull Collection<T> datas) {
        block7: {
            block6: {
                MLog.info((Object)this.mTag, (String)("doSave size: " + datas.size()), (Object[])new Object[0]);
                if (datas.isEmpty()) {
                    return;
                }
                try {
                    if (this.mPrimaryProperty == null) {
                        this.mBox.put(datas);
                        return;
                    }
                }
                catch (Throwable e) {
                    MLog.error((Object)this.mTag, (String)("doSave no primary key: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                    if (!SystemUtils.isShowEnvSetting()) break block6;
                    throw new RuntimeException(this.mTag + " doSave error");
                }
            }
            try {
                this.mStore.runInTx(() -> {
                    block3: {
                        try {
                            ArrayList<T> toRemovedDatas = new ArrayList<T>();
                            for (KvoDbBean data2 : datas) {
                                T existData;
                                if (data2.id != 0L || (existData = this.queryByPrimaryKey(this.mPrimaryField.get((Object)data2))) == null) continue;
                                toRemovedDatas.add(existData);
                            }
                            this.mBox.remove(toRemovedDatas);
                            this.mBox.put(datas);
                        }
                        catch (Throwable e) {
                            MLog.error((Object)this.mTag, (String)("doSave : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                            if (!SystemUtils.isShowEnvSetting()) break block3;
                            throw new RuntimeException(this.mTag + " doSave error");
                        }
                    }
                });
            }
            catch (Throwable e) {
                MLog.error((Object)this.mTag, (String)("doSave runInTx: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                if (!SystemUtils.isShowEnvSetting()) break block7;
                throw new RuntimeException(this.mTag + " doSave runInTx error");
            }
        }
    }

    public void clearAndSave(final @NonNull Collection<T> datas) {
        MLog.info((Object)this.mTag, (String)("clearAndSave datas size: " + datas.size()), (Object[])new Object[0]);
        ThreadBus.callThreadSafe((int)3, (Runnable)new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        JTableInfo.this.mBox.getStore().runInTx(() -> {
                            block2: {
                                try {
                                    JTableInfo.this.mBox.removeAll();
                                    JTableInfo.this.mBox.put(datas);
                                }
                                catch (Throwable e) {
                                    MLog.error((Object)JTableInfo.this.mTag, (String)("clearAndSave : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                                    if (!SystemUtils.isShowEnvSetting()) break block2;
                                    throw new RuntimeException(JTableInfo.this.mTag + " clearAndSave error");
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        MLog.error((Object)JTableInfo.this.mTag, (String)("clearAndSave runInTx: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                        if (!SystemUtils.isShowEnvSetting()) break block2;
                        throw new RuntimeException(JTableInfo.this.mTag + " clearAndSave runInTx error");
                    }
                }
            }
        });
    }

    public void delete(@NonNull T data2) {
        ThreadBus.callThreadSafe((int)3, () -> {
            block7: {
                try {
                    if (data2.id != 0L) {
                        this.mBox.remove((Object)data2);
                        return;
                    }
                }
                catch (Throwable e) {
                    MLog.error((Object)this.mTag, (String)("delete no id : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                    if (!SystemUtils.isShowEnvSetting()) break block7;
                    throw new RuntimeException(this.mTag + " delete no id error");
                }
            }
            if (this.mPrimaryProperty != null) {
                try {
                    T existData = this.queryByPrimaryKey(this.mPrimaryField.get(data2));
                    if (existData == null) return;
                    this.mBox.remove(((KvoDbBean)((Object)((Object)existData))).id);
                    return;
                }
                catch (Throwable e) {
                    MLog.error((Object)this.mTag, (String)("delete : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                    if (!SystemUtils.isShowEnvSetting()) return;
                    throw new RuntimeException(this.mTag + " delete error");
                }
            } else {
                MLog.error((Object)this.mTag, (String)("delete data: " + ((Object)data2).toString() + " error, you must either has a id or has primaryKey"), (Object[])new Object[0]);
                if (!RuntimeContext.sIsDebuggable) return;
                throw new IllegalArgumentException("JTableInfo delete data: " + ((Object)data2).toString() + " must either has a id or has primaryKey");
            }
        });
    }

    public void delete(@NonNull Collection<T> datas) {
        MLog.info((Object)this.mTag, (String)("delete datas size: " + datas.size()), (Object[])new Object[0]);
        ThreadBus.callThreadSafe((int)3, () -> {
            block6: {
                block5: {
                    try {
                        if (this.mPrimaryProperty == null) {
                            this.mBox.remove(datas);
                            return;
                        }
                    }
                    catch (Throwable e) {
                        MLog.error((Object)this.mTag, (String)("delete collection no primary key : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                        if (!SystemUtils.isShowEnvSetting()) break block5;
                        throw new RuntimeException(this.mTag + " delete collection no primary key error");
                    }
                }
                try {
                    this.mStore.runInTx(() -> {
                        block5: {
                            try {
                                ArrayList<Object> toRemovedDatas = new ArrayList<Object>();
                                for (KvoDbBean data2 : datas) {
                                    if (data2.id == 0L) {
                                        T existData = this.queryByPrimaryKey(this.mPrimaryField.get((Object)data2));
                                        if (existData != null) {
                                            toRemovedDatas.add(existData);
                                            continue;
                                        }
                                        MLog.error((Object)this.mTag, (String)("delete collection but no id : " + (Object)((Object)data2)), (Object[])new Object[0]);
                                        continue;
                                    }
                                    toRemovedDatas.add((Object)data2);
                                }
                                this.mBox.remove(toRemovedDatas);
                            }
                            catch (Throwable e) {
                                MLog.error((Object)this.mTag, (String)("delete collection: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                                if (!SystemUtils.isShowEnvSetting()) break block5;
                                throw new RuntimeException(this.mTag + " delete collection error");
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    MLog.error((Object)this.mTag, (String)("delete collection runInTx: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                    if (!SystemUtils.isShowEnvSetting()) break block6;
                    throw new RuntimeException(this.mTag + " delete collection runInTx error");
                }
            }
        });
    }

    public void clear() {
        MLog.info((Object)this.mTag, (String)"clear", (Object[])new Object[0]);
        ThreadBus.callThreadSafe((int)3, (Runnable)new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        JTableInfo.this.mBox.removeAll();
                    }
                    catch (Throwable e) {
                        MLog.error((Object)JTableInfo.this.mTag, (String)("clear : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                        if (!SystemUtils.isShowEnvSetting()) break block2;
                        throw new RuntimeException(JTableInfo.this.mTag + " clear error");
                    }
                }
            }
        });
    }

    public QueryBuilderWrapper<T> query() {
        return new QueryBuilderWrapper<T>(this.mBox);
    }

    private Field buildPrimaryField() {
        try {
            if (this.mPrimaryProperty == null) {
                return null;
            }
            return this.mBox.getEntityClass().getDeclaredField(this.mPrimaryProperty.name);
        }
        catch (NoSuchFieldException e) {
            MLog.error((Object)this.mTag, (String)("build primary field error: " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
            return null;
        }
    }

    private QueryFunction buildPrimaryKeyQueryFunction() {
        if (this.mPrimaryProperty == null) {
            return null;
        }
        return QueryFunction.getFunction(this.mPrimaryField.getType());
    }

    private QueryWrapper<T> buildPrimaryKeyQuery() {
        if (this.mPrimaryProperty == null) {
            return null;
        }
        return this.query().equal(this.mPrimaryProperty, this.mPrimaryQueryFunction.defaultValue).build();
    }
}

