/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db;

import android.util.Log;
import com.yy.appbase.data.MyObjectBox;
import com.yy.appbase.db.DataBox;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.filestorage.FileStorageUtils;
import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.BoxStoreBuilder;
import io.objectbox.android.AndroidObjectBrowser;
import java.io.File;
import java.util.HashMap;

public class ChannelDataBox {
    private static final String DB_PREFIX = "db_channel_";
    private volatile BoxStore mCurUserBoxStore;
    private final HashMap<Class, Box> mCurUserBoxs = new HashMap();
    private volatile long mCurUid = -1L;

    public ChannelDataBox(long uid) {
        DataBox.loadLibrary();
        this.mCurUid = uid;
        this.initUserDb(uid);
    }

    private synchronized void initUserDb(long uid) {
        if (this.mCurUserBoxStore == null) {
            File androidFileDir = new File(FileStorageUtils.getInstance().getInternalFileRootDir());
            if (androidFileDir != null && !androidFileDir.exists()) {
                androidFileDir.mkdirs();
            }
            File dir = this.getUserDbDir(uid);
            BoxStoreBuilder builder = MyObjectBox.builder();
            this.mCurUserBoxStore = builder.directory(dir).build();
            if (RuntimeContext.sIsDebuggable) {
                new AndroidObjectBrowser(this.mCurUserBoxStore).start(RuntimeContext.sApplicationContext);
            }
        }
        Log.i((String)"ChannelDataBox", (String)("initUserDb uid:" + uid));
    }

    private File getUserDbDir(long uid) {
        return FileStorageUtils.getInstance().getDirAndCreate(true, DB_PREFIX + uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Box<T> boxForCurUser(Class entityClass) {
        BoxStore curUserBoxStore = this.mCurUserBoxStore;
        if (curUserBoxStore == null) {
            return null;
        }
        HashMap<Class, Box> hashMap = this.mCurUserBoxs;
        synchronized (hashMap) {
            Box box = this.mCurUserBoxs.get(entityClass);
            if (box == null) {
                box = curUserBoxStore.boxFor(entityClass);
                this.mCurUserBoxs.put(entityClass, box);
            }
            return box;
        }
    }

    public long getCurUid() {
        return this.mCurUid;
    }
}

