/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data.oas;

import androidx.annotation.Nullable;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.oas.OfficialAccountsDb_;
import com.yy.appbase.data.oas.OfficialAccountsMsgDb;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import io.objectbox.BoxStore;
import io.objectbox.annotation.Backlink;
import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import io.objectbox.relation.ToMany;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

@Entity
public class OfficialAccountsDb
extends BaseDBBean {
    private static final String TAG = "OfficialAccountsDb";
    @Id
    long id;
    @Index
    String said;
    int saType;
    String ownerId;
    int jumpType;
    long ts;
    String avatar;
    @Backlink
    ToMany<OfficialAccountsMsgDb> msgs = new ToMany((Object)this, OfficialAccountsDb_.msgs);
    transient BoxStore __boxStore;

    @Override
    public Object getIndex() {
        return this.said;
    }

    @Override
    protected long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id2) {
        this.id = id2;
    }

    public static OfficialAccountsDb fromJson(JSONObject json) {
        OfficialAccountsDb db = new OfficialAccountsDb();
        db.said = json.optString("said");
        db.saType = json.optInt("satype");
        db.ownerId = json.optString("ownerid");
        db.jumpType = json.optInt("jump_type");
        db.ts = json.optLong("ts");
        db.avatar = json.optString("avatar");
        JSONArray ja = json.optJSONArray("msgs");
        if (ja != null) {
            int size = ja.length();
            for (int i = 0; i < size; ++i) {
                JSONObject msg = ja.optJSONObject(i);
                if (msg == null) continue;
                OfficialAccountsMsgDb msgDb = OfficialAccountsMsgDb.fromJson(msg, db);
                db.msgs.add((Object)msgDb);
            }
        }
        return db;
    }

    public void update(OfficialAccountsDb db) {
        if (db.saType != this.saType) {
            MLog.error((Object)TAG, (String)"\u540c\u4e00\u4e2a said: %s, saType \u53ef\u4ee5\u4e0d\u4e00\u6837\uff1f old saType: %d, db.saType: %d", (Object[])new Object[]{this.said, this.saType, db.saType});
            this.saType = db.saType;
        }
        if (!StringUtils.equal((String)db.ownerId, (String)this.ownerId)) {
            MLog.error((Object)TAG, (String)"\u540c\u4e00\u4e2a said: %s, ownerId \u53ef\u4ee5\u4e0d\u4e00\u6837\uff1f old ownerId: %s, db.ownerId: %s", (Object[])new Object[]{this.said, this.ownerId, db.ownerId});
            this.ownerId = db.ownerId;
        }
        if (db.jumpType != this.jumpType) {
            MLog.error((Object)TAG, (String)"\u540c\u4e00\u4e2a said: %s, jumpType \u53ef\u4ee5\u4e0d\u4e00\u6837\uff1f old jumpType: %d, db.jumpType: %d", (Object[])new Object[]{this.said, this.jumpType, db.jumpType});
            this.jumpType = db.jumpType;
        }
        if (db.msgs != null) {
            this.msgs.addAll(db.msgs);
        }
    }

    public void addMsg(OfficialAccountsMsgDb msg) {
        this.msgs.add((Object)msg);
    }

    public void removeMsg(OfficialAccountsMsgDb msg) {
        this.msgs.remove((Object)msg);
    }

    public String getSaid() {
        return this.said;
    }

    public int getSaType() {
        return this.saType;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public int getJumpType() {
        return this.jumpType;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public List<OfficialAccountsMsgDb> readOnlyMsgs() {
        return this.msgs;
    }

    public ToMany<OfficialAccountsMsgDb> getMsgs() {
        return this.msgs;
    }

    public long getTs() {
        return this.ts;
    }

    @Nullable
    public OfficialAccountsMsgDb findMsg(String msgId) {
        for (OfficialAccountsMsgDb m : this.msgs) {
            if (!StringUtils.equal((String)m.msgId, (String)msgId)) continue;
            return m;
        }
        return null;
    }

    public static interface SaType {
        public static final int none = 0;
        public static final int game = 1;
        public static final int activity = 2;
        public static final int gameAll = 3;
    }

    public static interface JumpType {
        public static final int none = 0;
        public static final int direct = 1;
        public static final int msg = 2;
    }
}

