/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.badger.impl;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.R;
import com.yy.appbase.badger.Badger;
import com.yy.appbase.badger.ShortcutBadger;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class XiaoMiHomeBadger
implements Badger {
    private static final String TAG = "XiaoMiHomeBadger";
    private static final String CHANNEL_DEFAULT = "default";

    @Override
    public void executeBadge(Context context, ComponentName componentName, int badgeCount) {
        try {
            Notification notification = ShortcutBadger.getCurrentNotification();
            if (notification == null) {
                MLog.debug((Object)TAG, (String)"executeBadge create default notification, badgeCount: %d", (Object[])new Object[]{badgeCount});
                notification = this.getDefaultNotification("");
            } else {
                MLog.debug((Object)TAG, (String)"executeBadge has notification, badgeCount: %d", (Object[])new Object[]{badgeCount});
            }
            this.applyNotification(notification, badgeCount);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"executeBadge error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private Notification getDefaultNotification(String title) {
        Context context = RuntimeContext.sApplicationContext;
        NotificationManager notificationManager = (NotificationManager)RuntimeContext.sApplicationContext.getSystemService("notification");
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_DEFAULT);
        if (Build.VERSION.SDK_INT > 27) {
            builder.setSmallIcon(R.drawable.push_logo_white);
        } else {
            builder.setSmallIcon(R.drawable.push_logo);
        }
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)title);
        Notification notification = builder.build();
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_DEFAULT, (CharSequence)CHANNEL_DEFAULT, 3);
            channel.setShowBadge(true);
            notificationManager.createNotificationChannel(channel);
        }
        notification.when = System.currentTimeMillis();
        notification.flags |= 0x10;
        notification.contentIntent = this.getBackPendingIntent();
        return notification;
    }

    private PendingIntent getBackPendingIntent() {
        Intent intent = new Intent();
        intent.setClassName(RuntimeContext.sApplicationContext, AppKeysDef.getLauncherActivity());
        intent.addFlags(0x10000000);
        return PendingIntent.getActivity((Context)RuntimeContext.sApplicationContext, (int)0, (Intent)intent, (int)0x10000000);
    }

    private void applyNotification(Notification notification, int badgeCount) {
        try {
            Field field = notification.getClass().getDeclaredField("extraNotification");
            Object extraNotification = field.get(notification);
            Method method = extraNotification.getClass().getDeclaredMethod("setMessageCount", Integer.TYPE);
            method.invoke(extraNotification, badgeCount);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"Unable to execute badge", (Throwable)e, (Object[])new Object[0]);
        }
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Arrays.asList("com.miui.miuilite", "com.miui.home", "com.miui.miuihome", "com.miui.miuihome2", "com.miui.mihome", "com.miui.mihome2", "com.i.miui.launcher");
    }
}

