/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.badger;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import com.yy.appbase.badger.ShortcutBadgeException;
import java.util.Collections;
import java.util.List;

public class BroadcastHelper {
    public static List<ResolveInfo> resolveBroadcast(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List<ResolveInfo> receivers = packageManager.queryBroadcastReceivers(intent, 0);
        return receivers != null ? receivers : Collections.emptyList();
    }

    public static void sendIntentExplicitly(Context context, Intent intent) throws ShortcutBadgeException {
        List<ResolveInfo> resolveInfos = BroadcastHelper.resolveBroadcast(context, intent);
        if (resolveInfos.size() == 0) {
            return;
        }
        for (ResolveInfo info : resolveInfos) {
            Intent actualIntent = new Intent(intent);
            if (info == null) continue;
            actualIntent.setPackage(info.resolvePackageName);
            context.sendBroadcast(actualIntent);
        }
    }

    public static void sendDefaultIntentExplicitly(Context context, Intent intent) throws ShortcutBadgeException {
        boolean oreoIntentSuccess = false;
        if (Build.VERSION.SDK_INT >= 26) {
            Intent oreoIntent = new Intent(intent);
            oreoIntent.setAction("com.yy.hiyo.BADGE_COUNT_UPDATE");
            try {
                BroadcastHelper.sendIntentExplicitly(context, oreoIntent);
                oreoIntentSuccess = true;
            }
            catch (ShortcutBadgeException e) {
                oreoIntentSuccess = false;
            }
        }
        if (oreoIntentSuccess) {
            return;
        }
        BroadcastHelper.sendIntentExplicitly(context, intent);
    }
}

