/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.analogai;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.analogai.AiBehaviorCallBack;
import com.yy.base.logger.MLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.Map;
import net.ihago.social.api.aiencourage.InvokeAiMsgReq;
import net.ihago.social.api.aiencourage.InvokeAiMsgRsp;
import net.ihago.social.api.aiencourage.InvokePushGameReq;
import net.ihago.social.api.aiencourage.InvokePushGameRsp;

public class AnalogAiModel {
    private static final String TAG = "AnalogAiModel";
    private static final int REQUEST_SUCCESS = 0;
    private static final int REQUEST_FAIL = -1;

    public static AnalogAiModel getInstance() {
        return Instance.instance;
    }

    public void requestAiBehavior(@NonNull int type2, long aiUid, Map<Integer, String> integerStringMap, final AiBehaviorCallBack callBack) {
        InvokeAiMsgReq req = integerStringMap != null ? new InvokeAiMsgReq.Builder().invoke_type(Integer.valueOf(type2)).extend_info(integerStringMap).ai_uid(Long.valueOf(aiUid)).build() : new InvokeAiMsgReq.Builder().invoke_type(Integer.valueOf(type2)).ai_uid(Long.valueOf(aiUid)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<InvokeAiMsgRsp>(){

            public void onResponse(@Nullable InvokeAiMsgRsp message) {
                int code = -1;
                if (message != null) {
                    code = message.ret;
                }
                MLog.info((Object)AnalogAiModel.TAG, (String)"requestAiInvite onResponse code = %d", (Object[])new Object[]{code});
                if (code == 0 && callBack != null) {
                    callBack.onSuccess();
                } else if (code == -1 && callBack != null) {
                    callBack.onError();
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public void requestPushBehavior(@NonNull String gid, final AiBehaviorCallBack callBack) {
        InvokePushGameReq req = new InvokePushGameReq.Builder().game_id(gid).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<InvokePushGameRsp>(){

            public void onResponse(@Nullable InvokePushGameRsp message) {
                int code = -1;
                if (message != null) {
                    code = message.ret;
                }
                MLog.info((Object)AnalogAiModel.TAG, (String)"requestPushBehavior onResponse code = %d", (Object[])new Object[]{code});
                if (code == 0 && callBack != null) {
                    callBack.onSuccess();
                } else if (code == -1 && callBack != null) {
                    callBack.onError();
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    private static class Instance {
        static AnalogAiModel instance = new AnalogAiModel();

        private Instance() {
        }
    }
}

