/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import com.yy.appbase.R;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class DiskCacheChecker {
    private static boolean sStorageNotEnoughDialogHasShowed = false;
    private static boolean sStorageCheckFinished = false;
    private static INotify sForeGroundListener;
    private static long sAvailableInternalStorgeSize;

    public static boolean hasStorageNotEnoughDialogShowed() {
        return sStorageNotEnoughDialogHasShowed;
    }

    public static boolean hasStorageCheckFinished() {
        return sStorageCheckFinished;
    }

    public static void clearCache() {
        ImageLoader.clearDiskCache();
    }

    public static boolean isAvailableInternalStorgeNotEnough() {
        long available;
        if (!SettingFlags.getBoolean((String)"checksasize", (boolean)true)) {
            MLog.error((Object)"DiskCacheChecker", (String)"switch off!", (Object[])new Object[0]);
            return false;
        }
        int minNum = SettingFlags.getIntValue((String)"storage_warning_value", (int)30) * 1024;
        if (minNum > 102400) {
            minNum = 102400;
        }
        if (RuntimeContext.sIsDebuggable && (minNum = 1024 * SettingFlags.getIntValue((String)"checkstoragetestvalue", (int)30)) <= 0) {
            minNum = 30720;
        }
        if ((available = sAvailableInternalStorgeSize) <= 0L) {
            available = sAvailableInternalStorgeSize = YYFileUtils.getAvailableInternalStorgeSize();
        }
        if (available > 0L && available < (long)minNum) {
            MLog.error((Object)"DiskCacheChecker", (String)"AvailableInternalStorgeSize %d not enough, check size %d!", (Object[])new Object[]{(int)available, minNum});
            return true;
        }
        MLog.error((Object)"DiskCacheChecker", (String)"AvailableInternalStorgeSize %d enough, check size %d!", (Object[])new Object[]{(int)available, minNum});
        return false;
    }

    public static void startCheckInnerStorage(final ICheckCallBack mCallBack, final Activity activity) {
        MLog.error((Object)"DiskCacheChecker", (String)"startCheck!", (Object[])new Object[0]);
        if (DiskCacheChecker.isAvailableInternalStorgeNotEnough()) {
            if (!sStorageNotEnoughDialogHasShowed) {
                DiskCacheChecker.clearCache();
            }
            sAvailableInternalStorgeSize = 0L;
            sStorageNotEnoughDialogHasShowed = true;
            final DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)activity);
            OkCancelDialog tipsDialog = new OkCancelDialog(ResourceUtils.getString((int)R.string.storage_not_enough_title), ResourceUtils.getString((int)R.string.storage_not_enough_go_clear), ResourceUtils.getString((int)R.string.storage_not_enough_continue_use), true, false, new OkCancelDialogListener(){

                @Override
                public void onCancel() {
                    MLog.error((Object)"DiskCacheChecker", (String)"cancel clicked!", (Object[])new Object[0]);
                    DiskCacheChecker.statDialogResult(false);
                    DiskCacheChecker.finishCheck(mCallBack);
                }

                @Override
                public void onOk() {
                    MLog.error((Object)"DiskCacheChecker", (String)"go clear clicked!", (Object[])new Object[0]);
                    DiskCacheChecker.statDialogResult(true);
                    try {
                        Intent intent = new Intent("android.settings.INTERNAL_STORAGE_SETTINGS");
                        activity.startActivity(intent);
                        sForeGroundListener = new INotify(){

                            public void notify(Notification notification) {
                                if (notification != null && notification.id == NotificationDef.N_FOREGROUND_CHANGE && RuntimeContext.sIsForeground) {
                                    MLog.error((Object)"DiskCacheChecker", (String)"\u5230\u524d\u53f0\uff0c\u91cd\u65b0\u68c0\u67e5\uff01", (Object[])new Object[0]);
                                    dialogLinkManager.dismissDialog();
                                    sForeGroundListener = null;
                                    if (DiskCacheChecker.isAvailableInternalStorgeNotEnough()) {
                                        DiskCacheChecker.statAfterClear(false);
                                    } else {
                                        DiskCacheChecker.statAfterClear(true);
                                    }
                                    DiskCacheChecker.startCheckInnerStorage(mCallBack, activity);
                                }
                            }
                        };
                    }
                    catch (Throwable e) {
                        MLog.error((Object)"DiskCacheChecker", (Throwable)e);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                dialogLinkManager.dismissDialog();
                                DiskCacheChecker.finishCheck(mCallBack);
                            }
                        }, (long)1000L);
                    }
                }
            });
            tipsDialog.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    MLog.error((Object)"DiskCacheChecker", (String)"cancel clicked!", (Object[])new Object[0]);
                    DiskCacheChecker.statDialogResult(false);
                    DiskCacheChecker.finishCheck(mCallBack);
                }
            });
            dialogLinkManager.showDialog((BaseDialog)tipsDialog);
        } else {
            DiskCacheChecker.finishCheck(mCallBack);
        }
    }

    private static void finishCheck(ICheckCallBack mCallBack) {
        MLog.error((Object)"DiskCacheChecker", (String)"finish!", (Object[])new Object[0]);
        sForeGroundListener = null;
        sStorageCheckFinished = true;
        mCallBack.onFinished();
    }

    public static void onForeGroundChange(boolean fore) {
        if (fore && sForeGroundListener != null) {
            sForeGroundListener.notify(Notification.obtain((int)NotificationDef.N_FOREGROUND_CHANGE));
        }
    }

    private static void statDialogResult(boolean clear) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", "1");
        statContent.put("ifieldtwo", clear ? "1" : "0");
        statContent.put("perftype", "checkinnerstorage");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private static void statAfterClear(boolean enoughNow) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", "2");
        statContent.put("ifieldtwo", enoughNow ? "1" : "0");
        statContent.put("perftype", "checkinnerstorage");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    static {
        sAvailableInternalStorgeSize = -1L;
    }

    public static interface ICheckCallBack {
        public void onFinished();
    }
}

