/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;

public class AZSidebar
extends YYView {
    public static final String[] DEFAULT_LETTERS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
    public static final int DEFAULT_SELECTED = -1;
    private OnTouchingLetterChangedListener onTouchingLetterChangedListener;
    private String[] mLetters = DEFAULT_LETTERS;
    private int mSelectedIndex = -1;
    private Paint mPaint = new Paint();
    private TextView mTipView;
    private int mLetterHeight;
    private int mLetterTextSize;

    public AZSidebar(Context context) {
        super(context);
        this.init(context);
    }

    public AZSidebar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AZSidebar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mLetterTextSize = ResolutionUtils.dip2Px((float)11.0f);
        this.mLetterHeight = ResolutionUtils.dip2Px((float)14.0f);
    }

    public void setOnTouchingLetterChangedListener(OnTouchingLetterChangedListener onTouchingLetterChangedListener) {
        this.onTouchingLetterChangedListener = onTouchingLetterChangedListener;
    }

    public void setTipView(TextView mTipView) {
        this.mTipView = mTipView;
    }

    public void setLetters(String[] mLetters) {
        this.mLetters = mLetters;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLetters == null || this.mLetters.length == 0) {
            return;
        }
        int width = this.getWidth();
        for (int i = 0; i < this.mLetters.length; ++i) {
            this.mPaint.setColor(-10066330);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setTextSize((float)this.mLetterTextSize);
            float xPos = (float)(width / 2) - this.mPaint.measureText(this.mLetters[i]) / 2.0f;
            float yPos = this.mLetterHeight * (i + 1);
            canvas.drawText(this.mLetters[i], xPos, yPos, this.mPaint);
            this.mPaint.reset();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        float eventY = event.getY();
        int oldSelectedIndex = this.mSelectedIndex;
        int newSelectedIndex = (int)(eventY / (float)this.mLetterHeight);
        switch (event.getAction()) {
            case 1: {
                this.invalidate();
                if (this.mTipView == null) break;
                this.mTipView.setVisibility(4);
                break;
            }
            default: {
                if (oldSelectedIndex == newSelectedIndex || newSelectedIndex < 0 || newSelectedIndex >= this.mLetters.length) break;
                if (this.onTouchingLetterChangedListener != null) {
                    this.onTouchingLetterChangedListener.onTouchingLetterChanged(this.mLetters[newSelectedIndex]);
                }
                if (this.mTipView != null) {
                    this.mTipView.setText((CharSequence)this.mLetters[newSelectedIndex]);
                    this.mTipView.setVisibility(0);
                }
                this.mSelectedIndex = newSelectedIndex;
                this.invalidate();
            }
        }
        return true;
    }

    public static interface OnTouchingLetterChangedListener {
        public void onTouchingLetterChanged(String var1);
    }
}

