/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class TeamGameConfigData
extends AConfigData {
    private static ArrayList<String> sGameKeys = new ArrayList();
    private ConcurrentHashMap<String, GameConfigItem> mGameConfigs = new ConcurrentHashMap();

    @Override
    public BssCode getBssCode() {
        return BssCode.TEAM_GAME_CONFIG;
    }

    @Override
    public void parseConfig(String configs) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)"TeamGameConfigData", (String)"configs %s", (Object[])new Object[]{configs});
        }
        this.mConfigContent = configs;
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)configs);
            this.mGameConfigs.clear();
            if (!jo.has("gamelist")) {
                return;
            }
            JSONArray gameList = jo.getJSONArray("gamelist");
            JSONObject gameItem = null;
            Object gamename = null;
            Object gameId = null;
            for (int i = 0; i < gameList.length(); ++i) {
                gameItem = gameList.optJSONObject(i);
                if (gameItem == null) continue;
                this.parseItem(gameItem);
            }
        }
        catch (Throwable e) {
            MLog.info((Object)"TeamGameConfigData", (String)"parseConfig %s", (Object[])new Object[]{configs});
        }
    }

    private void parseItem(JSONObject data2) {
        if (data2 == null) {
            return;
        }
        try {
            GameConfigItem item = new GameConfigItem();
            if (data2.has("gamename")) {
                item.mGameName = data2.getString("gamename");
            }
            if (data2.has("gameid")) {
                item.mGameId = data2.getString("gameid");
            }
            if (data2.has("bgurl")) {
                item.mBgUrl = data2.getString("bgurl");
            }
            if (data2.has("bgurlLandscape")) {
                item.mBgUrlLandscape = data2.getString("bgurlLandscape");
            }
            if (data2.has("bgurlninepatch")) {
                boolean bl = item.mBgUrlNinePatch = data2.getInt("bgurlninepatch") == 1;
            }
            if (data2.has("guideswitch")) {
                boolean bl = item.mGuideSwitch = data2.getInt("guideswitch") == 1;
            }
            if (data2.has("guideurl")) {
                item.mGuideUrl = data2.getString("guideurl");
            }
            if (data2.has("shareurl")) {
                item.mShareUrl = data2.getString("shareurl");
            }
            if (data2.has("sharecontent")) {
                item.mShareContent = data2.getString("sharecontent");
            }
            if (data2.has("shareimage")) {
                item.mShareImageUrl = data2.getString("shareimage");
            }
            if (data2.has("sharetitle")) {
                item.mShareTitle = data2.getString("sharetitle");
            }
            if (data2.has("sharesubtitle")) {
                item.mShareSubtitle = data2.getString("sharesubtitle");
            }
            if (data2.has("gamebackbtnshow")) {
                item.mGameBackShow = data2.getInt("gamebackbtnshow") == 1;
            }
            this.mGameConfigs.put(item.mGameId, item);
        }
        catch (Throwable e) {
            MLog.info((Object)"TeamGameConfigData", (String)"parseItem value %s", (Object[])new Object[]{data2});
        }
    }

    public GameConfigItem getGame(String gameId) {
        return this.mGameConfigs.get(gameId);
    }

    static {
        sGameKeys.add("wolfgame");
    }

    public static class GameConfigItem {
        String mGameId = "";
        String mGameName = "";
        boolean mGuideSwitch = true;
        boolean mBgUrlNinePatch = false;
        String mGuideUrl = "";
        String mBgUrl = "";
        String mBgUrlLandscape = "";
        String mShareUrl = "";
        String mShareImageUrl = "";
        String mShareTitle = "";
        String mShareSubtitle = "";
        String mShareContent;
        boolean mGameBackShow = true;

        public String getGuideUrl() {
            return this.mGuideUrl;
        }

        public boolean getGuideSwitch() {
            return this.mGuideSwitch;
        }

        public String getBgUrl() {
            return this.mBgUrl;
        }

        public String getBgUrlLandscape() {
            return this.mBgUrlLandscape;
        }

        public boolean getBgUrlNinePatch() {
            return this.mBgUrlNinePatch;
        }

        public String getShareUrl() {
            return this.mShareUrl;
        }

        public String getShareContent() {
            return this.mShareContent;
        }

        public String getShareImageUrl() {
            return this.mShareImageUrl;
        }

        public String getShareTitle() {
            return this.mShareTitle;
        }

        public String getShareSubtitle() {
            return this.mShareSubtitle;
        }

        public boolean ismGameBackShow() {
            return this.mGameBackShow;
        }
    }
}

