/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import androidx.annotation.Nullable;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.SceneOptConfigData;
import com.yy.appbase.unifyconfig.config.SceneOptConfigItem;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;

public class ScenePerformanceOptConfig
extends AConfigData {
    private static final String TAG = "ScenePerformanceOpt_Config";
    private static SceneOptConfigData mData;

    @Override
    public BssCode getBssCode() {
        return BssCode.SCENE_PERFORMANCE_OPT_CONFIG;
    }

    @Override
    public void parseConfig(final String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            MLog.error((Object)TAG, (String)"config is empty!", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScenePerformanceOptConfig.this.parseConfigInner(configs);
                }
            }, (long)0L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        block4: {
            try {
                mData = (SceneOptConfigData)JsonParser.parseJsonObject((String)configs, SceneOptConfigData.class);
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
                } else {
                    MLog.info((Object)TAG, (String)"parse config: %d", (Object[])new Object[]{configs.length()});
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
                if (!SystemUtils.isShowEnvSetting()) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isTotalSwitchOn() {
        if (mData == null) {
            return false;
        }
        return ScenePerformanceOptConfig.mData.swtichOn;
    }

    public static boolean isStatSwitchOn() {
        if (mData == null) {
            return false;
        }
        return ScenePerformanceOptConfig.mData.statSwitchOn;
    }

    @Nullable
    public static SceneOptConfigData getConfigData() {
        return mData;
    }

    public static SceneOptConfigItem getItem(String sceneName) {
        SceneOptConfigData data2 = mData;
        if (data2 == null || StringUtils.isEmpty((String)sceneName)) {
            return null;
        }
        if (!data2.swtichOn) {
            return null;
        }
        if (data2.channels != null && data2.channels.size() > 0 && data2.itemsByChannel != null && data2.itemsByChannel.size() > 0) {
            String curChannel = "";
            RuntimeContext.ChannelHeartItem item = RuntimeContext.getCoexistenceChannel();
            curChannel = item != null && StringUtils.isNotEmpty((String)item.getRoomId()) ? item.getRoomId() : RuntimeContext.getChannelId();
            boolean findChannel = false;
            if (StringUtils.isNotEmpty((String)curChannel)) {
                for (String channelOne : data2.channels) {
                    if (!StringUtils.equal((String)channelOne, (String)curChannel)) continue;
                    findChannel = true;
                    break;
                }
            }
            if (findChannel) {
                for (SceneOptConfigItem itemOne : data2.itemsByChannel) {
                    if (itemOne == null || !StringUtils.equal((String)itemOne.sceneName, (String)sceneName) || !SceneOptConfigItem.isSwitchOnByPhoneType(itemOne.phoneType)) continue;
                    return itemOne;
                }
            }
        }
        if (data2.items != null && data2.items.size() > 0) {
            for (SceneOptConfigItem itemOne : data2.items) {
                if (itemOne == null || !StringUtils.equal((String)itemOne.sceneName, (String)sceneName) || !SceneOptConfigItem.isSwitchOnByPhoneType(itemOne.phoneType)) continue;
                return itemOne;
            }
        }
        return null;
    }
}

