/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;

public class PartyFeedbackEntryConfig
extends AConfigData {
    private EntryConfig entryConfig;

    @Override
    public BssCode getBssCode() {
        return BssCode.PARTY_FEEDBACK_ENTRY_SWITCH;
    }

    @Override
    public void parseConfig(String configs) {
        MLog.info((Object)"PartyFeedbackEntryConfig", (String)"configs : %s", (Object[])new Object[]{configs});
        this.entryConfig = (EntryConfig)JsonParser.parseJsonObject((String)configs, EntryConfig.class);
        this.setDefault();
    }

    @Override
    public boolean parseDefault() {
        return true;
    }

    public synchronized boolean isAppEntryOpen(String countryCode) {
        MLog.info((Object)"PartyFeedbackEntryConfig", (String)"isAppEntryOpen countryCode: %s", (Object[])new Object[]{countryCode});
        if (FP.empty((CharSequence)countryCode)) {
            return false;
        }
        if (this.entryConfig != null && !FP.empty(this.entryConfig.appEntryCountry)) {
            for (String code : this.entryConfig.appEntryCountry) {
                if (!StringUtils.equalsIgnoreCase((String)countryCode, (String)code)) continue;
                return true;
            }
            return false;
        }
        return PartyFeedbackEntryConfig.getDefault(countryCode);
    }

    private void setDefault() {
        String code = AccountUtil.realCountry();
        String uid = String.valueOf(AccountUtil.getUid());
        SettingFlags.setBoolean((String)("feedback_entry_switch" + uid + code), (boolean)this.isAppEntryOpen(code));
    }

    public static boolean getDefault(String code) {
        return SettingFlags.getBoolean((String)("feedback_entry_switch" + AccountUtil.getUid() + code), (boolean)false);
    }

    public class EntryConfig {
        @SerializedName(value="appEntryCountry")
        List<String> appEntryCountry;
    }
}

