/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.google.gson.annotations.SerializedName;
import com.yy.appbase.unifyconfig.config.MetricReportSampleConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;
import java.util.Random;

@DontProguardClass
public class MetricReportSampleConfigData {
    @SerializedName(value="metric_report_array")
    public ArrayList<MetricReportSampleItem> metricReportArray = new ArrayList(0);
    @SerializedName(value="all_report_in_gray")
    public boolean enableInGray = true;
    @SerializedName(value="default_percent")
    public int percent = 4;
    @SerializedName(value="metric_report_white_list")
    public ArrayList<MetricReportSampleItem> whiteList = new ArrayList(0);
    private int randomPercent = new Random().nextInt(100) + 1;

    public boolean enableReport() {
        return this.randomPercent <= this.percent;
    }

    public static boolean enableReport(String metricUri) {
        if (RuntimeContext.isInGray() && MetricReportSampleConfig.enableInGray) {
            return true;
        }
        Boolean enableReport = null;
        if (StringUtils.isNotEmpty((String)metricUri)) {
            enableReport = MetricReportSampleConfig.enableReport(metricUri);
        }
        return enableReport == null ? MetricReportSampleConfigData.isEnableDefaultReport() : enableReport;
    }

    private static boolean isEnableDefaultReport() {
        return MetricReportSampleConfig.enableDefaultReport;
    }

    public static class MetricReportSampleItem {
        private int randomPercent = new Random().nextInt(100) + 1;
        @SerializedName(value="percent")
        public int percent = 4;
        @SerializedName(value="metric_uri")
        public ArrayList<String> metricUris = new ArrayList(0);

        public boolean enableReport() {
            return this.randomPercent <= this.percent;
        }
    }
}

