/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.data.GeneralMonitorBaseSwitchData;
import com.yy.appbase.unifyconfig.config.data.GeneralMonitorConfigData;
import com.yy.appbase.unifyconfig.config.data.GeneralMonitorSwitchData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;

public class GeneralMonitorConfig
extends AConfigData {
    private static final String TAG = "GeneralMonitorConfig";
    private static final String GENERAL_MONITOR_TOTAL_SWITCH = "general_monitor_total_switch";
    private static GeneralMonitorConfigData mData;
    private static int totalSwitchOn;

    @Override
    public BssCode getBssCode() {
        return BssCode.GENERAL_MONITOR_CONFIG;
    }

    @Override
    public boolean parseDefault() {
        totalSwitchOn = 0;
        return super.parseDefault();
    }

    @Override
    public void parseConfig(final String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            totalSwitchOn = 0;
            MLog.error((Object)TAG, (String)"config is empty!", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeneralMonitorConfig.this.parseConfigInner(configs);
                }
            }, (long)0L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        try {
            mData = (GeneralMonitorConfigData)JsonParser.parseJsonObject((String)configs, GeneralMonitorConfigData.class);
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
            } else {
                MLog.info((Object)TAG, (String)"parse config: %d", (Object[])new Object[]{configs.length()});
            }
            if (mData != null && GeneralMonitorConfig.mData.totalSwitch != null) {
                GeneralMonitorBaseSwitchData totalSwitch = GeneralMonitorConfig.mData.totalSwitch;
                totalSwitchOn = totalSwitch.isSwitchOn() ? 1 : 0;
                SettingFlags.setBoolean((String)GENERAL_MONITOR_TOTAL_SWITCH, (totalSwitchOn == 1 ? 1 : 0) != 0);
                MLog.info((Object)TAG, (String)"switchOn:%b, version:%s, percent:%d", (Object[])new Object[]{totalSwitchOn == 1, totalSwitch.version, totalSwitch.percent});
            } else if (SettingFlags.containKey((String)GENERAL_MONITOR_TOTAL_SWITCH)) {
                SettingFlags.setBoolean((String)GENERAL_MONITOR_TOTAL_SWITCH, (boolean)false);
                totalSwitchOn = 0;
            }
        }
        catch (Exception e) {
            totalSwitchOn = 0;
            if (SystemUtils.isShowEnvSetting()) {
                throw new RuntimeException(e);
            }
            MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static boolean isTotalSwitchOn() {
        if (totalSwitchOn != -1) {
            return totalSwitchOn == 1;
        }
        totalSwitchOn = SettingFlags.getBoolean((String)GENERAL_MONITOR_TOTAL_SWITCH, (boolean)false) ? 1 : 0;
        return totalSwitchOn == 1;
    }

    public static boolean isPerfSwitchOn(int type2, int subType, String uri, String subUri) {
        List<GeneralMonitorSwitchData> perfSwitches;
        if (!GeneralMonitorConfig.isTotalSwitchOn()) {
            return false;
        }
        if (mData != null && (perfSwitches = GeneralMonitorConfig.mData.perfSwitches) != null && perfSwitches.size() > 0) {
            for (GeneralMonitorSwitchData item : perfSwitches) {
                if (item == null || !item.isMatch(type2, subType, uri, subUri)) continue;
                return item.isSwitchOn();
            }
        }
        return false;
    }

    static {
        totalSwitchOn = -1;
    }
}

