/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.BussinessLogicOptConfigData;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;

public class BussinessLogicOptConfig
extends AConfigData {
    private static final String TAG = "BussinessLogicOptConfig";
    private static final String CHANNEL_SESSION_DISTURB_OPT_OFF = "channel_session_disturb_opt_off";
    private static BussinessLogicOptConfigData mData;

    @Override
    public BssCode getBssCode() {
        return BssCode.BUSSINESS_LOGIC_OPT_CONFIG;
    }

    @Override
    public void parseConfig(final String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            MLog.error((Object)TAG, (String)"config is empty!", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    BussinessLogicOptConfig.this.parseConfigInner(configs);
                }
            }, (long)0L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        try {
            mData = (BussinessLogicOptConfigData)JsonParser.parseJsonObject((String)configs, BussinessLogicOptConfigData.class);
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
            } else {
                MLog.info((Object)TAG, (String)"parse config: %d", (Object[])new Object[]{configs.length()});
            }
            if (mData != null) {
                MLog.info((Object)TAG, (String)"channelSessionDisturbOpt:%d", (Object[])new Object[]{BussinessLogicOptConfig.mData.channelSessionDisturbOptOff});
                if (BussinessLogicOptConfig.mData.channelSessionDisturbOptOff != -1) {
                    SettingFlags.setBoolean((String)CHANNEL_SESSION_DISTURB_OPT_OFF, (BussinessLogicOptConfig.mData.channelSessionDisturbOptOff == 1 ? 1 : 0) != 0);
                }
            }
        }
        catch (Exception e) {
            if (SystemUtils.isShowEnvSetting()) {
                throw new RuntimeException(e);
            }
            MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static boolean isChannelSessionDisturbOptOff() {
        if (mData != null) {
            return BussinessLogicOptConfig.mData.channelSessionDisturbOptOff == 1;
        }
        return SettingFlags.getBoolean((String)CHANNEL_SESSION_DISTURB_OPT_OFF, (boolean)false);
    }

    public static BussinessLogicOptConfigData getData() {
        return mData;
    }
}

