/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import android.util.SparseArray;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BasicConfigData
extends AConfigData {
    private static final String TAG = "BasicConfigData";
    private int mHomeNoticeInterval;
    private boolean isH265Support;
    private int h265HardDecodeType;
    private final SparseArray<String> mReportList = new SparseArray();
    private ArrayList<String> mWebRedirectBlackList;

    @Override
    public BssCode getBssCode() {
        return null;
    }

    @Override
    public void parseConfig(String configs) {
    }

    public int getHomeNoticeInterval() {
        return this.mHomeNoticeInterval;
    }

    public SparseArray<String> getReportList() {
        return this.mReportList;
    }

    public boolean isH265Support() {
        return this.isH265Support;
    }

    public int get265HardDecodeType() {
        return this.h265HardDecodeType;
    }

    public ArrayList<String> getWebRedirectBlackList() {
        return this.mWebRedirectBlackList;
    }

    private void parseReportList(Map<String, String> configs) {
        if (configs.containsKey("report_type_list")) {
            this.mReportList.clear();
            String datas = configs.get("report_type_list");
            try {
                JSONObject json = JsonParser.obtainJSONObject((String)datas);
                Iterator it = json.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = (String)json.get(key);
                    if (!TextUtils.isDigitsOnly((CharSequence)key)) continue;
                    this.mReportList.put(Integer.valueOf(key).intValue(), (Object)value);
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
        }
    }

    private void parsePerfConfig(String config) {
        if (StringUtils.isNotEmpty((String)config)) {
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)config);
                this.parseIntValueToKeysAndValues(jo, "loglevel");
                this.parseIntValueToKeysAndValues(jo, "lowloglevel");
                this.parseIntValueToKeysAndValues(jo, "livewindowani");
                this.parseIntValueToKeysAndValues(jo, "livewindowdelay");
                this.parseBoolValueToKeysAndValues(jo, "exitkill");
                this.parseBoolValueToKeysAndValues(jo, "autorecycle");
                this.parseBoolValueToKeysAndValues(jo, "recycleimageOn");
                this.parseBoolValueToKeysAndValues(jo, "bigimagerecycle");
                this.parseIntValueToKeysAndValues(jo, "bigimagerecyclesize");
                this.parseBoolValueToKeysAndValues(jo, "lowphoneact");
                int logLevel = this.getIntValue("loglevel", -1);
                int lowPhoneLogLevel = this.getIntValue("lowloglevel", -1);
                if (logLevel != -1) {
                    SettingFlags.setIntValue((String)"loglevel", (int)logLevel);
                }
                if (lowPhoneLogLevel != -1) {
                    SettingFlags.setIntValue((String)"lowloglevel", (int)lowPhoneLogLevel);
                }
                if (this.containsKey("lowphoneact")) {
                    boolean actSuperLowPhoneSwitch = this.getBoolValue("lowphoneact", false);
                    SettingFlags.setBoolean((String)"lowphoneact", (boolean)actSuperLowPhoneSwitch);
                }
                if (this.containsKey("autorecycle")) {
                    boolean localResRecycle = this.getBoolValue("autorecycle", true);
                    SettingFlags.setBoolean((String)"localresrecycle", (boolean)localResRecycle);
                }
                if (this.containsKey("exitkill")) {
                    SettingFlags.setBoolean((String)"exitkillprocess", (boolean)this.getBoolValue("exitkill", true));
                }
                if (this.containsKey("livewindowani")) {
                    SettingFlags.setIntValue((String)"livewindowani", (int)this.getIntValue("livewindowani", 200));
                }
                if (this.containsKey("livewindowdelay")) {
                    SettingFlags.setIntValue((String)"livewindowdelay", (int)this.getIntValue("livewindowdelay", 150));
                }
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    private void parseWebRedirectConfig(Map<String, String> configs) {
        if (!configs.containsKey("Web_Redirect_Config")) {
            return;
        }
        String infos = configs.get("Web_Redirect_Config");
        if (StringUtils.isNotEmpty((String)infos)) {
            try {
                ArrayList<String> items = new ArrayList<String>(5);
                JSONObject object = JsonParser.obtainJSONObject((String)infos);
                JSONArray webBlackListConfig = object.optJSONArray("WebBlackListConfig");
                for (int idx = 0; idx < webBlackListConfig.length(); ++idx) {
                    items.add(webBlackListConfig.get(idx).toString());
                }
                this.mWebRedirectBlackList = items;
            }
            catch (Exception e) {
                MLog.info((Object)TAG, (String)"parser error!", (Object[])new Object[0]);
            }
        } else {
            this.mWebRedirectBlackList = new ArrayList(1);
        }
    }
}

