/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.overscroll;

import android.view.MotionEvent;
import android.view.View;
import com.yy.appbase.ui.widget.overscroll.IOverScrollDecoratorAdapter;
import com.yy.appbase.ui.widget.overscroll.OverScrollBounceEffectDecoratorBase;

public class HorizontalOverScrollBounceEffectDecorator
extends OverScrollBounceEffectDecoratorBase {
    public HorizontalOverScrollBounceEffectDecorator(IOverScrollDecoratorAdapter viewAdapter) {
        this(viewAdapter, 1.5f, 1.0f, -2.0f);
    }

    public HorizontalOverScrollBounceEffectDecorator(IOverScrollDecoratorAdapter viewAdapter, float touchDragRatioFwd, float touchDragRatioBck, float decelerateFactor) {
        super(viewAdapter, decelerateFactor, touchDragRatioFwd, touchDragRatioBck);
    }

    @Override
    protected OverScrollBounceEffectDecoratorBase.MotionAttributes createMotionAttributes() {
        return new MotionAttributesHorizontal();
    }

    @Override
    protected OverScrollBounceEffectDecoratorBase.AnimationAttributes createAnimationAttributes() {
        return new AnimationAttributesHorizontal();
    }

    @Override
    protected void translateView(View view, float offset) {
        view.setTranslationX(offset);
    }

    @Override
    protected void translateViewAndEvent(View view, float offset, MotionEvent event) {
        view.setTranslationX(offset);
        event.offsetLocation(offset - event.getX(0), 0.0f);
    }

    protected static class AnimationAttributesHorizontal
    extends OverScrollBounceEffectDecoratorBase.AnimationAttributes {
        public AnimationAttributesHorizontal() {
            this.mProperty = View.TRANSLATION_X;
        }

        @Override
        protected void init(View view) {
            this.mAbsOffset = view.getTranslationX();
            this.mMaxOffset = view.getWidth();
        }
    }

    protected static class MotionAttributesHorizontal
    extends OverScrollBounceEffectDecoratorBase.MotionAttributes {
        protected MotionAttributesHorizontal() {
        }

        @Override
        public boolean init(View view, MotionEvent event) {
            if (event.getHistorySize() == 0) {
                return false;
            }
            float dy = event.getY(0) - event.getHistoricalY(0, 0);
            float dx = event.getX(0) - event.getHistoricalX(0, 0);
            if (Math.abs(dx) < Math.abs(dy)) {
                return false;
            }
            this.mAbsOffset = view.getTranslationX();
            this.mDeltaOffset = dx;
            this.mDir = this.mDeltaOffset > 0.0f;
            return true;
        }
    }
}

