/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bubble;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import android.view.View;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;

public class ArrowView
extends YYView {
    private static final int DEFAULT_LINE_WIDTH = 4;
    private static final int DEFAULT_WIDTH = 30;
    private static final int DEFAULT_HEIGHT = 30;
    private static final int DEFAULT_COLOR = -1;
    private static final String SPEC_TYPE_WIDTH = "spec_typeWith";
    private int mLineWidth = ResolutionUtils.dip2Px((float)4.0f);
    private int arrowColor = -1;
    private Paint mPaint;
    private Path mPath;
    private int mArrowWidth = ResolutionUtils.dip2Px((float)30.0f);
    private int mArrowHeight = ResolutionUtils.dip2Px((float)30.0f);

    public ArrowView(Context context) {
        this(context, null);
    }

    public ArrowView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ArrowView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ArrowView);
        this.mLineWidth = (int)typedArray.getDimension(R.styleable.ArrowView_arrow_width, 4.0f);
        this.arrowColor = typedArray.getColor(R.styleable.ArrowView_arrow_color, -1);
        typedArray.recycle();
        this.mPaint = new Paint(1);
        this.mPaint.setDither(true);
        this.mPaint.setColor(this.arrowColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.mPaint.setPathEffect((PathEffect)new CornerPathEffect(1.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measure(widthMeasureSpec, SPEC_TYPE_WIDTH), this.measure(heightMeasureSpec, ""));
        this.mArrowWidth = this.getMeasuredWidth();
        this.mArrowHeight = this.getMeasuredHeight();
    }

    private int measure(int widthMeasureSpec, String specType) {
        int size = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int resultSize = 0;
        if (mode == 0x40000000) {
            resultSize = size;
        } else {
            int n = resultSize = SPEC_TYPE_WIDTH.equals(specType) ? this.mArrowWidth : this.mArrowHeight;
            if (mode == Integer.MIN_VALUE) {
                resultSize = Math.min(resultSize, size);
            }
        }
        return resultSize;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mPath = new Path();
        float top = (float)this.getPaddingTop() + (float)this.mLineWidth * 1.0f / 2.0f;
        float left = (float)this.getPaddingLeft() + (float)this.mLineWidth * 1.0f / 2.0f;
        float right = (float)(this.mArrowWidth - this.getPaddingRight()) - (float)this.mLineWidth * 1.0f / 2.0f;
        float bottom = top + ((float)(this.mArrowHeight - this.getPaddingBottom() - this.getPaddingTop()) - (float)this.mLineWidth * 1.0f / 2.0f) / 2.0f;
        this.mPath.moveTo(left, top);
        this.mPath.lineTo(right, bottom);
        this.mPath.lineTo(left, (float)(this.mArrowHeight - this.getPaddingBottom() - this.mLineWidth / 2));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

