/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.banner;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.R;
import com.yy.appbase.ui.press.PressScale;
import com.yy.appbase.ui.widget.banner.BannerActionAdapter;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import java.util.List;

public class ImageBannerActionAdapter
extends BannerActionAdapter<RecycleImageView> {
    private List<String> mImageUrlList = null;
    private TimeInterpolator interpolator = new AccelerateDecelerateInterpolator();

    public ImageBannerActionAdapter() {
        MLog.debug((Object)"ImageBannerActionAdapter", (String)"init", (Object[])new Object[0]);
    }

    public void updateUrlList(List<String> imageUrlList) {
        MLog.debug((Object)"ImageBannerActionAdapter", (String)"mImageUrlList: %s, newUrlList: %s", (Object[])new Object[]{this.mImageUrlList, imageUrlList});
        if (!FP.eq(this.mImageUrlList, imageUrlList)) {
            this.mImageUrlList = imageUrlList;
            this.notifyDataChanged();
        }
    }

    @Override
    public int getCount() {
        return this.mImageUrlList == null ? 0 : this.mImageUrlList.size();
    }

    @Override
    public void onClick(int position, @NonNull View itemContainer) {
    }

    @Override
    public boolean onTouch(int position, View itemContainer, MotionEvent event) {
        PressScale.startCardAnimation(itemContainer, event, this.interpolator);
        return false;
    }

    @Override
    public RecycleImageView createItem(Context context, int index) {
        RecycleImageView imageView = new RecycleImageView(context);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        ImageLoader.loadImage((ImageView)imageView, (String)this.mImageUrlList.get(index), (int)R.drawable.icon_default_photo);
        return imageView;
    }
}

