/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemServiceUtils;

public class EndlessListScrollListener
implements AbsListView.OnScrollListener {
    private int visibleThreshold = 1;
    private boolean mLoading = false;
    private View mFooter;
    private ListView mListView;
    private EndlessListener mListener;
    private AbsListView.OnScrollListener mOnScrollListener;
    private ViewGroup mLoadingViewContainer;
    private boolean mLastItemVisible;
    private boolean isShowLoadingMore = false;
    private int showLoadingMoreThreshold = 1;
    private CommonStatusLayout mStatus;

    public boolean ismLoading() {
        return this.mLoading;
    }

    public void setmLoading(boolean mLoading) {
        this.mLoading = mLoading;
    }

    public EndlessListScrollListener(CommonStatusLayout layout2) {
        this.mStatus = layout2;
    }

    public EndlessListScrollListener(ViewGroup loadingViewContainer, int resourceId) {
        this.mLoadingViewContainer = loadingViewContainer;
        this.setLoadingView(resourceId);
    }

    public void setListener(EndlessListener listener2) {
        this.mListener = listener2;
    }

    public void setParentOnScrollListener(AbsListView.OnScrollListener listener2) {
        this.mOnScrollListener = listener2;
    }

    protected void setLoadingView(int resourceId) {
        if (this.mLoadingViewContainer != null) {
            this.mFooter = SystemServiceUtils.getLayoutInflater((Context)this.mLoadingViewContainer.getContext()).inflate(resourceId, null);
        }
    }

    public void setVisibleThreshold(int visibleThreshold) {
        this.visibleThreshold = visibleThreshold;
    }

    public void setShowLoadingMoreThreshold(int showLoadingMoreThreshold) {
        this.showLoadingMoreThreshold = showLoadingMoreThreshold;
    }

    public void onLoadComplete() {
        MLog.verbose((Object)this, (String)"onLoadComplete", (Object[])new Object[0]);
        this.mLoading = false;
        if (this.mLoadingViewContainer != null) {
            this.mLoadingViewContainer.removeView(this.mFooter);
        }
        if (this.mListView != null) {
            this.mListView.removeFooterView(this.mFooter);
        }
        if (this.mStatus != null) {
            this.mStatus.hideLoadingMore();
        }
    }

    protected void onLoading() {
        MLog.verbose((Object)this, (String)"onLoading", (Object[])new Object[0]);
        this.mLoading = true;
        if (this.mLoadingViewContainer != null) {
            this.mLoadingViewContainer.addView(this.mFooter);
        }
        if (this.mListView != null) {
            this.mListView.addFooterView(this.mFooter);
        }
        if (this.mStatus != null) {
            this.mStatus.showLoadingMore();
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.mLastItemVisible = totalItemCount > 0 && firstVisibleItem + visibleItemCount >= totalItemCount - this.visibleThreshold;
        boolean bl = this.isShowLoadingMore = totalItemCount > 0 && firstVisibleItem + visibleItemCount >= totalItemCount - this.showLoadingMoreThreshold;
        if (!this.mLastItemVisible && this.mStatus != null) {
            this.mStatus.hideLoadingMore();
            this.mLoading = false;
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 0 && null != this.mListener && !this.mLoading && this.mListener.shouldLoadData()) {
            if (this.isShowLoadingMore) {
                this.onLoading();
            }
            if (this.mLastItemVisible) {
                this.mListener.onLoadData();
            }
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void setLastItemVisible(boolean visible) {
        this.mLastItemVisible = visible;
    }

    public static interface EndlessListener {
        public void onLoadData();

        public boolean shouldLoadData();
    }
}

