/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.toast;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.R;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DeviceManager;
import java.util.ArrayList;
import java.util.List;

public class GlobalTopToast {
    private YYTextView toastView;
    private final List<ToastMessage> msgList = new ArrayList<ToastMessage>(5);
    private ToastMessage curMsg;
    private Runnable toastTimer = new Runnable(){

        @Override
        public void run() {
            ToastMessage msg = GlobalTopToast.this.nextToast();
            if (msg == null) {
                GlobalTopToast.this.curMsg = null;
                GlobalTopToast.this.hide();
            } else {
                GlobalTopToast.this.show(msg);
                GlobalTopToast.this.curMsg = msg;
            }
        }
    };

    public GlobalTopToast(@NonNull Context context) {
        this.toastView = (YYTextView)LayoutInflater.from((Context)context).inflate(R.layout.layout_global_toast, null);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 49;
        this.toastView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.toastView.setBackgroundColor(ResourceUtils.getColor((int)R.color.warn_toast_bg));
        if (Build.VERSION.SDK_INT > 20) {
            this.toastView.setEllipsize(TextUtils.TruncateAt.END);
        }
    }

    public void setToastMsgSingleLine(boolean isSingleLine) {
        if (this.toastView != null) {
            this.toastView.setSingleLine(isSingleLine);
        }
    }

    public View getToastView() {
        return this.toastView;
    }

    public void showToast(ToastMessage msg) {
        if (msg == null || TextUtils.isEmpty((CharSequence)msg.msg)) {
            return;
        }
        if (msg.equals(this.curMsg)) {
            this.curMsg = msg;
            YYTaskExecutor.removeTask((Runnable)this.toastTimer);
            YYTaskExecutor.postToMainThread((Runnable)this.toastTimer, (long)msg.duration);
            return;
        }
        int idx = this.msgList.indexOf(msg);
        if (idx >= 0) {
            ToastMessage tm = this.msgList.get(idx);
            msg.duration = tm.duration = Math.max(tm.duration, msg.duration);
            if (tm.priority >= msg.priority) {
                return;
            }
            this.msgList.remove(tm);
        }
        this.insert(msg);
        if (this.curMsg == null) {
            this.toastTimer.run();
        }
    }

    public void removeToast(ToastMessage msg) {
        if (msg == null || TextUtils.isEmpty((CharSequence)msg.msg)) {
            return;
        }
        if (msg.equals(this.curMsg)) {
            YYTaskExecutor.removeTask((Runnable)this.toastTimer);
            this.toastTimer.run();
            return;
        }
        this.msgList.remove(msg);
    }

    private void show(@NonNull ToastMessage msg) {
        this.toastView.setBackgroundColor(msg.color);
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.toastView.getLayoutParams();
        if (lp != null && (float)lp.topMargin != msg.marginTop) {
            lp.topMargin = (int)msg.marginTop;
            this.toastView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (this.toastView.getContext() instanceof Activity) {
            DeviceManager.fullScreenOffsetView((Activity)((Activity)this.toastView.getContext()), (View)this.toastView);
        }
        this.toastView.setText(msg.msg);
        if (this.toastView.getVisibility() != 0) {
            this.toastView.setVisibility(0);
        }
        YYTaskExecutor.postToMainThread((Runnable)this.toastTimer, (long)msg.duration);
    }

    @Nullable
    private ToastMessage nextToast() {
        if (this.msgList.isEmpty()) {
            return null;
        }
        return this.msgList.remove(0);
    }

    private void hide() {
        if (this.toastView.getVisibility() == 0) {
            this.toastView.setVisibility(8);
        }
    }

    private void insert(ToastMessage msg) {
        int idx = 0;
        for (ToastMessage tm : this.msgList) {
            if (tm.priority < msg.priority) break;
            ++idx;
        }
        this.msgList.add(idx, msg);
    }
}

