/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.press;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.yy.appbase.ui.utils.AnimatorUtils;

public class PressScale {
    public static void apply(View view) {
        PressScale.apply(view, false);
    }

    public static void apply(View view, boolean isForceAnim) {
        PressScale.apply(view, isForceAnim, AnimationParam.DEFAULT);
    }

    public static void apply(View view, boolean isForceAnim, AnimationParam param) {
        if (!isForceAnim && !AnimatorUtils.canAnimation()) {
            return;
        }
        if (view == null) {
            return;
        }
        AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        view.setOnTouchListener(new View.OnTouchListener((TimeInterpolator)interpolator, param){
            final /* synthetic */ TimeInterpolator val$interpolator;
            final /* synthetic */ AnimationParam val$param;
            {
                this.val$interpolator = timeInterpolator;
                this.val$param = animationParam;
            }

            public boolean onTouch(View v, MotionEvent event) {
                PressScale.startCardAnimation(v, event, this.val$interpolator, this.val$param);
                return false;
            }
        });
    }

    public static void startCardAnimation(View view, MotionEvent event, TimeInterpolator interpolator) {
        PressScale.startCardAnimation(view, event, interpolator, AnimationParam.DEFAULT);
    }

    public static void startCardAnimation(View view, MotionEvent event, TimeInterpolator interpolator, AnimationParam param) {
        switch (event.getAction()) {
            case 0: {
                PressScale.animationDown(view, interpolator, param);
                break;
            }
            case 1: 
            case 3: {
                PressScale.animationUp(view, interpolator, param);
                break;
            }
        }
    }

    private static void animationDown(View view, TimeInterpolator interpolator, AnimationParam param) {
        if (view == null) {
            return;
        }
        view.setPivotX((float)view.getMeasuredWidth() / 2.0f);
        view.setPivotY((float)view.getMeasuredHeight() / 2.0f);
        int downDuration = param.downDuration;
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.9f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.9f});
        scaleX.setInterpolator(interpolator);
        scaleY.setInterpolator(interpolator);
        scaleX.setDuration((long)downDuration);
        scaleY.setDuration((long)downDuration);
        scaleX.start();
        scaleY.start();
    }

    private static void animationUp(View view, TimeInterpolator interpolator, AnimationParam param) {
        if (view == null) {
            return;
        }
        view.setPivotX((float)view.getMeasuredWidth() / 2.0f);
        view.setPivotY((float)view.getMeasuredHeight() / 2.0f);
        float x = view.getScaleX();
        float y = view.getScaleY();
        int upAnimationTime = param.upDuration;
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{x, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{y, 1.0f});
        scaleX.setInterpolator(interpolator);
        scaleY.setInterpolator(interpolator);
        scaleX.setDuration((long)upAnimationTime);
        scaleY.setDuration((long)upAnimationTime);
        scaleX.start();
        scaleY.start();
    }

    public static class AnimationParam {
        public static final int DEFAULT_UP_ANIMATION_TIME = 100;
        public static final int DEFAULT_DOWN_ANIMATION_TIME = 60;
        public int upDuration = 100;
        public int downDuration = 60;
        public static AnimationParam DEFAULT = new AnimationParam();
    }
}

