/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.annotation.SuppressLint;
import android.app.DatePickerDialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.yy.appbase.R;
import com.yy.appbase.ui.dialog.HDatePicker;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYAlertDialog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public class OkDatePickerDialog
extends YYAlertDialog
implements DatePicker.OnDateChangedListener,
View.OnClickListener {
    private HDatePicker mDatePicker;
    private static final String TAG = "OkDatePickerDialog";
    private ArrayList<NumberPicker> mPickers;
    private YYTextView okBtn;
    private YYTextView cancelBtn;
    private static final int type = 3;
    private ISelectCallBack mDateSetListener;
    private boolean mCanChooseFuture = false;

    public OkDatePickerDialog(Context context, int themeResId, @Nullable ISelectCallBack listener2) {
        this(context, themeResId, listener2, null, 2000, 0, 1);
    }

    private OkDatePickerDialog(@NonNull Context context, @StyleRes int themeResId, @Nullable ISelectCallBack listener2, @Nullable Calendar calendar, int year, int monthOfYear, int dayOfMonth) {
        super(context, OkDatePickerDialog.resolveDialogTheme(context, themeResId));
        Context themeContext = this.getContext();
        this.mDateSetListener = listener2;
        try {
            LayoutInflater inflater = LayoutInflater.from((Context)themeContext);
            View view = inflater.inflate(R.layout.okdate_picker_dialog, null);
            this.setView(view);
            if (calendar != null) {
                year = calendar.get(1);
                monthOfYear = calendar.get(2);
                dayOfMonth = calendar.get(5);
            }
            this.mDatePicker = (HDatePicker)view.findViewById(R.id.date_picker);
            this.okBtn = (YYTextView)view.findViewById(R.id.date_picker_ok);
            this.cancelBtn = (YYTextView)view.findViewById(R.id.date_picker_cancel);
            this.okBtn.setOnClickListener((View.OnClickListener)this);
            this.cancelBtn.setOnClickListener((View.OnClickListener)this);
            this.mDatePicker.init(year, monthOfYear, dayOfMonth, this);
            this.findNumberPicker();
            this.setDividerColor(ResourceUtils.getColor((int)R.color.date_packer_ok));
            this.setPickerMargin(ResourceUtils.getDimen((int)R.dimen.dialog_data_pick_topmargin), ResourceUtils.getDimen((int)R.dimen.dialog_data_pick_leftmargin));
        }
        catch (IllegalArgumentException e) {
            MLog.error((Object)TAG, (String)("OkDatePickerDialog init error : " + e.toString()), (Object[])new Object[0]);
            ToastUtils.showToast((Context)context, (int)R.string.tips_unknown_error);
        }
    }

    public void setCanChooseFuture(boolean canChooseFuture) {
        this.mCanChooseFuture = canChooseFuture;
    }

    public void setLastDate(String date) {
        Calendar calendar;
        Date birth = DateUtils.getDateFromStr((String)date, (String)"yyyy-MM-dd");
        if (birth == null) {
            birth = DateUtils.getDateFromStr((String)date, (String)"yyyy - MM - dd");
        }
        if ((calendar = Calendar.getInstance()) != null && birth != null) {
            calendar.setTime(birth);
            int year = calendar.get(1);
            int monthOfYear = calendar.get(2);
            int dayOfMonth = calendar.get(5);
            this.mDatePicker.init(year, monthOfYear, dayOfMonth, this);
        }
    }

    public DatePicker getDatePicker() {
        return this.mDatePicker;
    }

    public void setSelectRange(long start, long end) {
        this.setMinDate(start);
        this.setMaxDate(end);
    }

    public void setMinDate(long start) {
        this.mDatePicker.setMinDate(start);
    }

    public void setMaxDate(long end) {
        this.mDatePicker.setMaxDate(end);
    }

    private void findNumberPicker() {
        this.mPickers = new ArrayList();
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                LinearLayout llFirst = (LinearLayout)this.mDatePicker.getChildAt(0);
                LinearLayout mSpinners = (LinearLayout)llFirst.getChildAt(0);
                for (int i = 0; i < mSpinners.getChildCount(); ++i) {
                    NumberPicker picker = (NumberPicker)mSpinners.getChildAt(i);
                    this.mPickers.add(i, picker);
                }
                return;
            }
            Class<DatePicker> c = DatePicker.class;
            View daySpinner = null;
            View monthSpinner = null;
            View yearSpinner = null;
            Field fd = c.getDeclaredField("mDayPicker");
            Field fm = c.getDeclaredField("mMonthPicker");
            Field fy = c.getDeclaredField("mYearPicker");
            if (fd != null && fm != null && fy != null) {
                fd.setAccessible(true);
                fm.setAccessible(true);
                fy.setAccessible(true);
                daySpinner = (View)fd.get((Object)this);
                monthSpinner = (View)fm.get((Object)this);
                yearSpinner = (View)fy.get((Object)this);
            }
            if (daySpinner != null && monthSpinner != null && yearSpinner != null) {
                daySpinner.setVisibility(8);
                if (daySpinner instanceof NumberPicker && monthSpinner instanceof NumberPicker && yearSpinner instanceof NumberPicker) {
                    this.mPickers.add((NumberPicker)daySpinner);
                    this.mPickers.add((NumberPicker)monthSpinner);
                    this.mPickers.add((NumberPicker)yearSpinner);
                }
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    @SuppressLint(value={"ResourceAsColor"})
    public void setPickerMargin(int topMargin, int leftMargin) {
        for (NumberPicker picker : this.mPickers) {
            if (picker == null) continue;
            LinearLayout.LayoutParams lps = (LinearLayout.LayoutParams)picker.getLayoutParams();
            lps.setMargins(0, topMargin, 0, topMargin / 2);
            if (Build.VERSION.SDK_INT >= 17) {
                lps.setMarginStart(leftMargin);
                lps.setMarginEnd(leftMargin);
            }
            picker.setLayoutParams((ViewGroup.LayoutParams)lps);
        }
    }

    public void setDividerColor(int color2) {
        for (int i = 0; i < this.mPickers.size(); ++i) {
            NumberPicker picker = this.mPickers.get(i);
            try {
                Field pf = NumberPicker.class.getDeclaredField("mSelectionDivider");
                pf.setAccessible(true);
                pf.set(picker, new ColorDrawable(color2));
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SuppressLint(value={"ResourceType"})
    @StyleRes
    static int resolveDialogTheme(@NonNull Context context, @StyleRes int themeResId) {
        if (themeResId == 0) {
            return 3;
        }
        return themeResId;
    }

    public void onDateChanged(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
        this.mDatePicker.init(year, monthOfYear, dayOfMonth, this);
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt("y", this.mDatePicker.getYear());
        state.putInt("MMMM", this.mDatePicker.getMonth());
        state.putInt("d", this.mDatePicker.getDayOfMonth());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt("y");
        int month = savedInstanceState.getInt("MMMM");
        int day = savedInstanceState.getInt("d");
        this.mDatePicker.init(year, month, day, this);
    }

    public void cancel() {
        this.dismiss();
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.date_picker_ok) {
            if (this.mDateSetListener != null) {
                this.mDatePicker.clearFocus();
                int month = this.mDatePicker.getMonth() + 1;
                String birthday = this.mDatePicker.getYear() + "-" + month + "-" + this.mDatePicker.getDayOfMonth();
                if (DateUtils.before((String)birthday) && !this.mCanChooseFuture) {
                    ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.toast_after_now), (int)0);
                } else {
                    this.mDateSetListener.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), month, this.mDatePicker.getDayOfMonth());
                }
            }
        } else if (i == R.id.date_picker_cancel && i == R.id.date_picker_ok && this.mDateSetListener != null) {
            this.mDatePicker.clearFocus();
            this.mDateSetListener.onCancel();
        }
        this.cancel();
    }

    public static interface ISelectCallBack
    extends DatePickerDialog.OnDateSetListener {
        public void onCancel();
    }
}

