/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;

public class OkCancelDialog
implements BaseDialog {
    private CharSequence message;
    private CharSequence okLabel;
    private int okLabelColor = 0;
    private CharSequence cancelLabel;
    private int cancelLabelColor = 0;
    private float lineSpacingExtra = -1.0f;
    private float lineSpacingMultiplier = -1.0f;
    private boolean cancelable;
    private boolean outSideCancelable;
    private boolean isNeedCenter = false;
    boolean withCloseBtn = false;
    private OkCancelDialogListener listener;
    private DialogInterface.OnCancelListener cancleListener;

    public OkCancelDialog(Builder builder) {
        this(builder.message, builder.okLabel, builder.okLabelColor, builder.cancelLabel, builder.cancelLabelColor, builder.lineSpacingExtra, builder.lineSpacingMultiplier, builder.cancelable, builder.outSideCancelable, builder.isNeedCenter, builder.listener);
        this.withCloseBtn = builder.withCloseBtn;
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener2) {
        this.message = message;
        this.okLabel = okLabel;
        this.okLabelColor = okLabelColor;
        this.cancelLabel = cancelLabel;
        this.cancelLabelColor = cancelLabelColor;
        this.lineSpacingExtra = lineSpacingExtra;
        this.lineSpacingMultiplier = lineSpacingMultiplier;
        this.cancelable = cancelable;
        this.outSideCancelable = outSideCancelable;
        this.isNeedCenter = isNeedCenter;
        this.listener = listener2;
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, boolean cancelable, boolean outSideCancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, okLabelColor, cancelLabel, cancelLabelColor, -1.0f, -1.0f, cancelable, outSideCancelable, false, listener2);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, lineSpacingExtra, lineSpacingMultiplier, cancelable, outSideCancelable, isNeedCenter, listener2);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, lineSpacingExtra, lineSpacingMultiplier, cancelable, cancelable, false, listener2);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean outSideCancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, outSideCancelable, false, listener2);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, outSideCancelable, isNeedCenter, listener2);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, cancelable, false, listener2);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, true, true, false, listener2);
    }

    public OkCancelDialog(CharSequence message, boolean cancelable, OkCancelDialogListener listener2) {
        this(message, ResourceUtils.getString((int)R.string.dialog_btn_yes), 0, ResourceUtils.getString((int)R.string.dialog_btn_no), 0, -1.0f, -1.0f, cancelable, cancelable, false, listener2);
    }

    public void setCancelListener(DialogInterface.OnCancelListener listener2) {
        this.cancleListener = listener2;
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.outSideCancelable);
        Window window = dialog.getWindow();
        window.setContentView(R.layout.layout_ok_cancel_color_link_dialog);
        TextView tip = (TextView)window.findViewById(R.id.message);
        if (this.lineSpacingExtra != -1.0f && this.lineSpacingMultiplier != -1.0f) {
            tip.setLineSpacing(this.lineSpacingExtra, this.lineSpacingMultiplier);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            tip.setText(this.message);
        }
        if (this.isNeedCenter) {
            tip.setGravity(17);
        } else {
            tip.setGravity(0x800003);
            if (Build.VERSION.SDK_INT >= 17) {
                tip.setTextAlignment(5);
            }
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (this.okLabelColor != 0) {
            ok.setTextColor(this.okLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (OkCancelDialog.this.listener != null) {
                    OkCancelDialog.this.listener.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (this.cancelLabelColor != 0) {
            cancel.setTextColor(this.cancelLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.cancelLabel)) {
            cancel.setText(this.cancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (OkCancelDialog.this.listener != null) {
                    OkCancelDialog.this.listener.onCancel();
                }
            }
        });
        if (this.withCloseBtn) {
            RecycleImageView closeBtn = (RecycleImageView)window.findViewById(R.id.close_icon);
            closeBtn.setVisibility(0);
            closeBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                    if (OkCancelDialog.this.listener != null) {
                        OkCancelDialog.this.listener.onClose();
                    }
                }
            });
        }
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (OkCancelDialog.this.listener != null) {
                    OkCancelDialog.this.listener.onDismiss();
                }
            }
        });
        dialog.setOnCancelListener(this.cancleListener);
    }

    public int getId() {
        return DialogId.normalOkCancelDialog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        CharSequence message;
        CharSequence okLabel;
        int okLabelColor = 0;
        CharSequence cancelLabel;
        int cancelLabelColor = 0;
        float lineSpacingExtra = -1.0f;
        float lineSpacingMultiplier = -1.0f;
        boolean cancelable;
        boolean outSideCancelable;
        boolean isNeedCenter = true;
        boolean withCloseBtn = false;
        OkCancelDialogListener listener;

        public Builder message(CharSequence message) {
            this.message = message;
            return this;
        }

        public Builder okLabel(CharSequence okLabel) {
            this.okLabel = okLabel;
            return this;
        }

        public Builder okLabelColor(int okLabelColor) {
            this.okLabelColor = okLabelColor;
            return this;
        }

        public Builder setCancelLabel(CharSequence cancelLabel) {
            this.cancelLabel = cancelLabel;
            return this;
        }

        public Builder cancelLabelColor(int cancelLabelColor) {
            this.cancelLabelColor = cancelLabelColor;
            return this;
        }

        public Builder lineSpacingExtra(float lineSpacingExtra) {
            this.lineSpacingExtra = lineSpacingExtra;
            return this;
        }

        public Builder lineSpacingMultiplier(float lineSpacingMultiplier) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder outSideCancelable(boolean outSideCancelable) {
            this.outSideCancelable = outSideCancelable;
            return this;
        }

        public Builder needCenter(boolean needCenter) {
            this.isNeedCenter = needCenter;
            return this;
        }

        public Builder withCloseBtn(boolean withCloseBtn) {
            this.withCloseBtn = withCloseBtn;
            return this;
        }

        public Builder listener(OkCancelDialogListener listener2) {
            this.listener = listener2;
            return this;
        }

        public OkCancelDialog build() {
            return new OkCancelDialog(this);
        }
    }
}

