/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.span.SpannableUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;

public class GameErrorDialog
implements BaseDialog {
    private CharSequence message;
    private CharSequence okLabel;
    private int okLabelColor = 0;
    private boolean cancelable;
    private String mTitle;
    private String mOkText = null;
    private TextView btnCopy;

    public GameErrorDialog(String title, CharSequence message, CharSequence okLabel, int okLabelColor, boolean cancelable) {
        this.mTitle = title;
        this.message = message;
        this.okLabel = okLabel;
        this.okLabelColor = okLabelColor;
        this.cancelable = cancelable;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setOkText(String okText) {
        this.mOkText = okText;
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.show();
        Window window = dialog.getWindow();
        window.setContentView(R.layout.layout_game_error_dialog);
        TextView title = (TextView)window.findViewById(R.id.title);
        TextView msg = (TextView)window.findViewById(R.id.message);
        if (this.message instanceof String && !TextUtils.isEmpty((CharSequence)this.message)) {
            msg.setText((CharSequence)Html.fromHtml((String)((String)this.message)));
            msg.setMovementMethod(LinkMovementMethod.getInstance());
            SpannableUtils.setUrlSpans(msg);
        } else if (!TextUtils.isEmpty((CharSequence)this.message)) {
            msg.setText(this.message);
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (this.okLabelColor != 0) {
            ok.setTextColor(this.okLabelColor);
        }
        if (StringUtils.isNotEmpty((String)this.mOkText)) {
            ok.setText((CharSequence)this.mOkText);
        } else if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        this.btnCopy = (TextView)dialog.findViewById(R.id.btn_copy);
        this.btnCopy.setText((CharSequence)"Copy");
        this.btnCopy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ClipboardManager clipboard = (ClipboardManager)RuntimeContext.sApplicationContext.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"game_error", (CharSequence)GameErrorDialog.this.message);
                clipboard.setPrimaryClip(clip);
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"copy success", (int)0);
            }
        });
        if (StringUtils.isNotEmpty((String)this.mTitle)) {
            title.setText((CharSequence)this.mTitle);
            title.setVisibility(0);
        } else {
            title.setText((CharSequence)"");
            title.setVisibility(8);
        }
    }

    public int getId() {
        return DialogId.normalOkDialog;
    }
}

