/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateTimePickerDialog
extends YYDialog {
    private static final int startYear = 1900;

    public DateTimePickerDialog(Context context, int theme) {
        super(context, theme);
    }

    public static class Builder {
        private int year;
        private int month;
        private int day;
        int intervalYear;
        private Context context;
        private DialogInterface.OnClickListener positiveButtonClickListener;
        private DialogInterface.OnClickListener negativeButtonClickListener;
        private ArrayList yearList;
        private ArrayList monthList;
        private ArrayList dayList;
        ListView mListViewYear;
        ListView mListViewMonth;
        ListView mListViewDay;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setPositiveButton(DialogInterface.OnClickListener listener2) {
            this.positiveButtonClickListener = listener2;
            return this;
        }

        public Builder setNegativeButton(DialogInterface.OnClickListener listener2) {
            this.negativeButtonClickListener = listener2;
            return this;
        }

        public DateTimePickerDialog create() {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            final DateTimePickerDialog dialog = new DateTimePickerDialog(this.context, R.style.Theme_AppCompat_Dialog);
            Window dialogWindow = dialog.getWindow();
            dialogWindow.setGravity(17);
            WindowManager.LayoutParams p = dialogWindow.getAttributes();
            p.width = ScreenUtils.getInstance().getWidthPixels();
            dialogWindow.setAttributes(p);
            View layout2 = inflater.inflate(R.layout.time_picker_dialog, null);
            dialog.addContentView(layout2, new ViewGroup.LayoutParams(-1, -2));
            if (this.positiveButtonClickListener != null) {
                layout2.findViewById(R.id.sure).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        positiveButtonClickListener.onClick((DialogInterface)dialog, -1);
                    }
                });
            }
            if (this.negativeButtonClickListener != null) {
                layout2.findViewById(R.id.cancel).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        negativeButtonClickListener.onClick((DialogInterface)dialog, -2);
                    }
                });
            }
            this.mListViewYear = (ListView)layout2.findViewById(R.id.year_listView);
            this.mListViewMonth = (ListView)layout2.findViewById(R.id.month_listView);
            this.mListViewDay = (ListView)layout2.findViewById(R.id.day_listView);
            this.initListViews();
            dialog.setContentView(layout2);
            return dialog;
        }

        private void initListViews() {
            Calendar calendar = Calendar.getInstance();
            this.intervalYear = calendar.get(1) - 1900 + 1;
            this.yearList = new ArrayList();
            this.monthList = new ArrayList();
            this.dayList = new ArrayList();
            this.getContent(this.yearList, this.monthList, this.dayList);
            this.mListViewYear.setAdapter((ListAdapter)new MyAdapter(this.yearList));
            this.mListViewYear.setSelection(this.year - 1900);
            MyAdapter dayAdapter = new MyAdapter(this.dayList);
            this.mListViewMonth.setAdapter((ListAdapter)new MyAdapter(this.monthList));
            this.mListViewMonth.setSelection(this.month);
            this.mListViewDay.setAdapter((ListAdapter)dayAdapter);
            this.mListViewDay.setSelection(this.day - 1);
        }

        private void getContent(List yearList, List monthList, List dayList) {
            for (int i = 0; i < this.intervalYear + 2; ++i) {
                String my;
                if (i == 0 || i == this.intervalYear + 1) {
                    my = "";
                } else {
                    int m = 1900 + i - 1;
                    my = String.valueOf(m);
                }
                yearList.add(i, my);
            }
            for (int i = 0; i < 14; ++i) {
                String mm = i == 0 || i == 13 ? "" : i + "";
                monthList.add(i, mm);
            }
            for (int i = 0; i < 33; ++i) {
                String md = i == 0 || i == 32 ? "" : i + "";
                dayList.add(i, md);
            }
        }

        public String getStr() {
            int year = this.mListViewYear.getFirstVisiblePosition() + 1900;
            int month = this.mListViewMonth.getFirstVisiblePosition() + 1;
            int day = this.mListViewDay.getFirstVisiblePosition() + 1;
            String m = month < 10 ? "0" + String.valueOf(month) : String.valueOf(month);
            String d = day < 10 ? "0" + String.valueOf(day) : String.valueOf(day);
            return String.valueOf(year) + "-" + m + "-" + d;
        }

        public void setLastDate(String date) {
            Calendar calendar;
            Date birth = DateUtils.getDateFromStr((String)date, (String)"yyyy-MM-dd");
            if (birth == null) {
                birth = DateUtils.getDateFromStr((String)date, (String)"yyyy - MM - dd");
            }
            if ((calendar = Calendar.getInstance()) != null) {
                calendar.setTime(birth);
                this.year = calendar.get(1);
                this.month = calendar.get(2);
                this.day = calendar.get(5);
            }
        }

        public class ViewHolder {
            TextView textView;
        }

        private class MyAdapter
        extends BaseAdapter {
            private ArrayList list;

            public MyAdapter(ArrayList list) {
                this.list = list;
            }

            public int getCount() {
                return this.list.size();
            }

            public Object getItem(int position) {
                return null;
            }

            public long getItemId(int position) {
                return position;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                ViewHolder holder = null;
                if (convertView == null) {
                    holder = new ViewHolder();
                    convertView = LayoutInflater.from((Context)Builder.this.context).inflate(R.layout.layout_picker_list_item, null);
                    holder.textView = (TextView)convertView.findViewById(R.id.tv);
                    convertView.setTag((Object)holder);
                } else {
                    holder = (ViewHolder)convertView.getTag();
                }
                holder.textView.setText((CharSequence)(this.list.get(position) + ""));
                return convertView;
            }
        }
    }
}

