/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.handmark.pulltorefresh.library.internal.BallRotationProgressBar;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.yy.appbase.R;
import com.yy.base.utils.ResolutionUtils;

public class BallRecyclerHeader
extends InternalAbstract
implements RefreshHeader {
    private BallRotationProgressBar mBallView;
    private int mHeaderHeight;

    public BallRecyclerHeader(@NonNull View wrapper) {
        super(wrapper);
        this.mHeaderHeight = ResolutionUtils.dip2Px((float)70.0f);
        if (wrapper instanceof LinearLayout) {
            LinearLayout ll = (LinearLayout)wrapper;
            ll.setMinimumHeight(this.mHeaderHeight);
            this.mBallView = new BallRotationProgressBar(wrapper.getContext());
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)40.0f));
            lp.gravity = 80;
            this.mBallView.setId(R.id.smart_refresh_header_ball_view);
            ll.addView((View)this.mBallView, (ViewGroup.LayoutParams)lp);
            this.mBallView.setIsVibrator(true);
        }
    }

    public BallRecyclerHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        if (this.mBallView != null) {
            this.mBallView.stopAnimator();
        }
        return 0;
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        super.onMoving(isDragging, percent, offset, height, maxDragHeight);
    }

    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        super.onReleased(refreshLayout, height, maxDragHeight);
    }

    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        if (this.mBallView != null) {
            this.mBallView.startAnimator();
        }
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        super.onStateChanged(refreshLayout, oldState, newState);
        switch (newState) {
            case ReleaseToRefresh: {
                if (this.mBallView == null) break;
                this.mBallView.startvibrator();
                break;
            }
        }
    }

    public void clearRefreshBg() {
        this.mWrapperView.setBackgroundDrawable(null);
    }

    public void setIsVibrator(boolean isVibrator) {
        if (this.mBallView != null) {
            this.mBallView.setIsVibrator(isVibrator);
        }
    }
}

