/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.screenshot;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import com.yy.appbase.R;
import com.yy.appbase.screenshot.ScreenShotManager;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ReportMsgDef;

public class ScreenShotView
extends YYFrameLayout
implements View.OnClickListener,
View.OnTouchListener {
    public static final int TYPE_PROFILE_REPORT = 1;
    public static final int TYPE_VOICE_ROOM_REPORT = 2;
    private View mContentLayout;
    private OnPushLayoutAnimateListener mPushLayoutAnimateListener;
    private boolean mIsPlayAnim = false;
    private int mDownY = 0;
    private int mDistance = 0;
    private int mType;
    private long mUid;
    private TextView mTvReport;
    private ScreenShotManager.IScreenShotListener mScreenShotListener;

    public ScreenShotView(Context context, String imgUrl, long uid, int type2, OnPushLayoutAnimateListener pushLayoutAnimateListener) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_screenshot_view, (ViewGroup)this, true);
        FrameLayout.LayoutParams params = this.generateDefaultLayoutParams();
        params.height = -2;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mType = type2;
        this.mUid = uid;
        this.mPushLayoutAnimateListener = pushLayoutAnimateListener;
        this.initView(imgUrl);
    }

    private void initView(String imgUrl) {
        RecycleImageView rvHeader = (RecycleImageView)this.findViewById(R.id.iv_screenshot_header);
        this.mTvReport = (TextView)this.findViewById(R.id.tv_screenshot_report);
        this.mContentLayout = this.findViewById(R.id.rl_screenshot);
        this.setOnTouchListener(this);
        this.mTvReport.setOnClickListener((View.OnClickListener)this);
        this.enterAnim(rvHeader, imgUrl);
    }

    public void setScreenShotListener(ScreenShotManager.IScreenShotListener listener2) {
        this.mScreenShotListener = listener2;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_screenshot_report) {
            FeatureLog.i((String)"FTScreenShot", (String)"onClick", (Object[])new Object[0]);
            if (this.mTvReport != null) {
                this.mTvReport.setEnabled(false);
            }
            if (this.mPushLayoutAnimateListener != null) {
                this.mPushLayoutAnimateListener.onReportClick();
                this.mPushLayoutAnimateListener.onExit((View)this);
            }
            Message message = Message.obtain();
            if (this.mType == 1) {
                message.what = ReportMsgDef.PROFILE_REPORT;
                message.obj = this.mUid;
                MsgDispatcher.getInstance().sendMessage(message);
            } else if (this.mType == 2 && this.mScreenShotListener != null) {
                this.mScreenShotListener.onScreenShotSuccess(2);
            }
        }
    }

    public boolean onTouch(View v, MotionEvent motionEvent) {
        if (this.mIsPlayAnim) {
            return false;
        }
        switch (motionEvent.getAction()) {
            case 0: {
                this.mDistance = 0;
                this.mDownY = (int)motionEvent.getRawY();
                break;
            }
            case 2: {
                this.mDistance = (int)(motionEvent.getRawY() - (float)this.mDownY);
                if (this.mDistance < 0) {
                    this.scrollTo(0, -this.mDistance);
                    break;
                }
                this.scrollTo(0, 0);
                break;
            }
            default: {
                if (this.mDistance >= 0 || -this.mDistance <= this.mContentLayout.getMeasuredHeight() * 2 / 10) break;
                this.playExitAnim(-this.mDistance, this.getMeasuredHeight());
            }
        }
        return true;
    }

    private void playExitAnim(int distance, int totalHeight) {
        this.mIsPlayAnim = true;
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{distance, totalHeight});
        anim.setDuration(800L);
        anim.setRepeatCount(0);
        anim.setRepeatMode(1);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ScreenShotView.this.scrollTo(0, (Integer)valueAnimator.getAnimatedValue());
            }
        });
        anim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (ScreenShotView.this.mPushLayoutAnimateListener != null) {
                    ScreenShotView.this.mPushLayoutAnimateListener.onExit((View)ScreenShotView.this);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        anim.start();
    }

    public void onTimeOutExit() {
        ViewCompat.animate((View)this.mContentLayout).translationY((float)(-this.mContentLayout.getHeight())).setDuration(300L).setInterpolator((Interpolator)new AccelerateInterpolator()).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (ScreenShotView.this.mPushLayoutAnimateListener != null) {
                    ScreenShotView.this.mPushLayoutAnimateListener.onExit((View)ScreenShotView.this);
                }
            }
        }).start();
    }

    private void enterAnim(final RecycleImageView rvHeader, final String imgUrl) {
        if (this.mContentLayout == null) {
            return;
        }
        ViewCompat.animate((View)this.mContentLayout).translationY((float)this.mContentLayout.getHeight()).setDuration(300L).setInterpolator((Interpolator)new AccelerateInterpolator()).setListener(new ViewPropertyAnimatorListener(){

            public void onAnimationStart(View view) {
            }

            public void onAnimationEnd(View view) {
                if (rvHeader == null) {
                    FeatureLog.i((String)"FTScreenShot", (String)"image null", (Object[])new Object[0]);
                    return;
                }
                ImageLoader.loadBitmap((ImageView)rvHeader, (String)imgUrl, (int)0, (int)ResolutionUtils.dip2Px((float)40.0f), (int)ResolutionUtils.dip2Px((float)40.0f));
            }

            public void onAnimationCancel(View view) {
            }
        }).start();
    }

    public static interface OnPushLayoutAnimateListener {
        public void onExit(View var1);

        public void onReportClick();
    }
}

