/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.resource.file;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.common.BiCallback;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.resource.file.IFetchResourceFilePath;
import com.yy.appbase.resource.file.IFetchResourceWithDownload;
import com.yy.appbase.resource.file.InnerResInfo;
import com.yy.appbase.resource.file.ResDefine;
import com.yy.appbase.resource.file.ResInfo;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

class ResourcePersist {
    private static final String TAG = "ResourcePersist";
    private IQueueTaskExecutor mQueueExecutor;
    private String sResourceDir;
    private final Map<String, String> mUrlMd5Cache = new HashMap<String, String>();
    private final Map<String, String> mUrlPathCache = new ConcurrentHashMap<String, String>();
    private Map<ResPersistUtils.Dir, Set<InnerResInfo>> mPendingLoad;
    private final Set<InnerResInfo> mPendingDownload = new CopyOnWriteArraySet<InnerResInfo>();
    private INotify mNotify;
    private boolean isDownloading = false;

    ResourcePersist() {
    }

    public synchronized void preLoad(ResPersistUtils.Dir dir, Set<ResInfo> infos) {
        if (dir == null || FP.empty(infos)) {
            MLog.error((Object)TAG, (String)"preLoad dir: %s, urls.size: %d", (Object[])new Object[]{dir, FP.size(infos)});
            return;
        }
        HashSet<InnerResInfo> urlsCopy = new HashSet<InnerResInfo>(infos.size());
        for (ResInfo info : infos) {
            urlsCopy.add(new InnerResInfo(dir, info));
        }
        if (RuntimeContext.sIsAppStartFinishAfterThreeSecond) {
            this.executor(() -> this.loadResource(dir, urlsCopy));
        } else {
            if (this.mPendingLoad == null) {
                this.mPendingLoad = new HashMap<ResPersistUtils.Dir, Set<InnerResInfo>>();
                this.mPendingLoad.put(dir, urlsCopy);
            }
            if (this.mNotify == null) {
                this.mNotify = notification -> {
                    if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
                        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, this.mNotify);
                    }
                    this.executor(this::handlePending);
                };
            }
            YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, this.mNotify));
        }
    }

    public void fetchFilePath(ResPersistUtils.Dir dir, String url, IFetchResourceFilePath callback) {
        if (callback == null) {
            MLog.error((Object)TAG, (String)"fetchFilePath callback is null", (Object[])new Object[0]);
            return;
        }
        if (dir == null || TextUtils.isEmpty((CharSequence)url)) {
            callback.onFetch("");
        }
        this.executor(() -> {
            String path = this.fetchFilePath(dir, url);
            this.onCallbackUi(callback, path);
        });
    }

    public void fetchFilePathWithDownload(ResPersistUtils.Dir dir, ResInfo resInfo, IFetchResourceWithDownload callback) {
        this.fetchFilePathWithDownload(dir, resInfo, true, callback);
    }

    public void fetchFilePathWithDownload(final ResPersistUtils.Dir dir, final ResInfo resInfo, boolean autoDownload, final IFetchResourceWithDownload callback) {
        if (callback == null) {
            MLog.error((Object)TAG, (String)"fetchFilePath callback is null", (Object[])new Object[0]);
            return;
        }
        if (resInfo == null || dir == null || TextUtils.isEmpty((CharSequence)resInfo.getUrl())) {
            callback.onFetch("");
        }
        this.executor(() -> {
            String path = this.fetchFilePath(dir, resInfo.getUrl());
            if (StringUtils.isEmpty((String)path) && autoDownload) {
                InnerResInfo innerResInfo = new InnerResInfo(dir, resInfo);
                this.removePendingDownload(innerResInfo);
                this.downloadRes(innerResInfo, new BiCallback<InnerResInfo, InnerResInfo>(){

                    @Override
                    public void onSuccess(InnerResInfo data2) {
                        callback.onFetch(ResourcePersist.this.fetchFilePath(dir, resInfo.getUrl()));
                    }

                    @Override
                    public void onError(InnerResInfo error) {
                        callback.onError();
                    }
                });
            } else {
                this.onCallbackUi(callback, path);
            }
        });
    }

    private void removePendingDownload(ResInfo resInfo) {
        for (InnerResInfo info : this.mPendingDownload) {
            if (!info.getUrl().equals(resInfo.getUrl())) continue;
            this.mPendingDownload.remove(info);
            break;
        }
    }

    public String fetchFilePath(ResPersistUtils.Dir dir, String url) {
        if (url == null) {
            return "";
        }
        if (this.mUrlPathCache.containsKey(url)) {
            return this.mUrlPathCache.get(url);
        }
        String path = this.filePath(dir, url);
        File file = new File(path);
        boolean exist = file.exists();
        if (exist && file.length() > 0L) {
            this.mUrlPathCache.put(url, path);
            return path;
        }
        return "";
    }

    public void delete(ResPersistUtils.Dir dir, String url) {
        if (dir == null || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        this.executor(() -> {
            String path = this.filePath(dir, url);
            YYFileUtils.deleteFile((File)new File(path));
        });
    }

    private void handlePending() {
        if (FP.empty(this.mPendingLoad)) {
            return;
        }
        for (Map.Entry<ResPersistUtils.Dir, Set<InnerResInfo>> entry : this.mPendingLoad.entrySet()) {
            this.loadResource(entry.getKey(), entry.getValue());
        }
    }

    private void loadResource(ResPersistUtils.Dir dir, Set<InnerResInfo> urls) {
        Set<InnerResInfo> needDownload = this.filterFiles(dir, urls);
        if (FP.empty(needDownload)) {
            return;
        }
        this.mPendingDownload.addAll(urls);
        this.downloadNext();
    }

    private void downloadNext() {
        block1: {
            if (FP.empty(this.mPendingDownload) || this.isDownloading) {
                return;
            }
            Iterator<InnerResInfo> iterator2 = this.mPendingDownload.iterator();
            if (!iterator2.hasNext()) break block1;
            InnerResInfo info = iterator2.next();
            MLog.debug((Object)TAG, (String)"downloadNext resinfo=%s", (Object[])new Object[]{info});
            this.downloadRes(info, new BiCallback<InnerResInfo, InnerResInfo>(){

                @Override
                public void onSuccess(InnerResInfo data2) {
                    ResourcePersist.this.downloadSuccess(data2);
                }

                @Override
                public void onError(InnerResInfo data2) {
                    ResourcePersist.this.downloadFailed(data2);
                }
            });
        }
    }

    private void downloadRes(InnerResInfo info, BiCallback<InnerResInfo, InnerResInfo> callback) {
        String url = info.getUrl();
        String path = this.filePath(info.getDir(), url);
        String md5 = info.getMd5();
        this.isDownloading = true;
        this.downloadByDownloadCenter(url, path, md5, info, callback);
    }

    void downloadByGrace(final String url, final String path, String md5, final InnerResInfo info, final BiCallback<InnerResInfo, InnerResInfo> callback) {
        HttpUtil.downloadFile(url, path, md5, new Callback<File>(){

            public void onResponse(Call<File> call, Response<File> response) {
                MLog.info((Object)ResourcePersist.TAG, (String)"download dynamic resource success url: %s, path: %s", (Object[])new Object[]{url, path});
                FeatureLog.i((String)"FTQuicFileDownload", (String)"download dynamic resource success url: %s, path: %s", (Object[])new Object[]{url, path});
                ResourcePersist.this.executor(() -> callback.onSuccess(info));
            }

            public void onFailure(Call<File> call, Throwable e) {
                MLog.error((Object)ResourcePersist.TAG, (String)"downloadRes url: %s, path: %s", (Object[])new Object[]{url, path, e});
                FeatureLog.e((String)"FTQuicFileDownload", (String)"downloadRes url: %s, path: %s", (Object[])new Object[]{url, path, e});
                ResourcePersist.this.executor(() -> callback.onError(info));
            }
        });
    }

    void downloadByDownloadCenter(final String url, final String path, String md5, final InnerResInfo info, final BiCallback<InnerResInfo, InnerResInfo> callback) {
        final long speed = ResDefine.Companion.getLimitSpeed(info.getInfo().getSpeed());
        Downloader.Builder builder = new Downloader.Builder(url, path);
        builder.setTaskSpeedLimitPerMicsecondValue(speed);
        builder.setTaskGroup(DownloadBussinessGroup.RESOURCE_PRELOAD);
        builder.setSupportContinueTransfer(true);
        if (StringUtils.isNotEmpty((String)md5)) {
            builder.setFileEtagCheckContent("md5", md5);
        }
        builder.setCallBack(new IDownloadCallback(){

            public void onComplete(Downloader downloader) {
                MLog.info((Object)"ResourceDownloadCenter", (String)"download dynamic resource success url: %s, path: %s", (Object[])new Object[]{url, path});
                ResourcePersist.this.executor(() -> callback.onSuccess(info));
            }

            public void onError(Downloader downloader, int errorType, String errorInfo) {
                MLog.error((Object)"ResourceDownloadCenter", (String)"downloadRes url: %s, path: %s error:%s", (Object[])new Object[]{url, path, errorInfo});
                ResourcePersist.this.executor(() -> callback.onError(info));
            }

            public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
            }

            public void onStart(Downloader downloader) {
                MLog.debug((Object)"ResourceDownloadCenter", (String)"download dynamic resource start url: %s, path: %s\uff0cspeed:%s", (Object[])new Object[]{url, path, String.valueOf(speed)});
            }
        });
        Downloader downloader = builder.build();
        downloader.start();
    }

    private void downloadFailed(InnerResInfo info) {
        this.isDownloading = false;
        this.mPendingDownload.remove(info);
        this.downloadNext();
    }

    private void downloadSuccess(InnerResInfo info) {
        this.isDownloading = false;
        this.mPendingDownload.remove(info);
        this.downloadNext();
    }

    @Nullable
    private Set<InnerResInfo> filterFiles(ResPersistUtils.Dir dir, Set<InnerResInfo> urls) {
        String dirPath = this.getResDirPath(dir);
        File dirFile = new File(dirPath);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            MLog.info((Object)TAG, (String)"filterFiles dirPath: %s", (Object[])new Object[]{dirPath});
            return urls;
        }
        Object[] fileName = dirFile.list();
        if (FP.empty((Object[])fileName)) {
            MLog.info((Object)TAG, (String)"filterFiles fileName list is empty", (Object[])new Object[0]);
            return urls;
        }
        block0: for (Object name : fileName) {
            if (TextUtils.isEmpty((CharSequence)name)) continue;
            Iterator<InnerResInfo> it = urls.iterator();
            while (it.hasNext()) {
                InnerResInfo config = it.next();
                String url = config.getUrl();
                if (TextUtils.isEmpty((CharSequence)url)) {
                    it.remove();
                    continue;
                }
                String md5 = this.urlMd5(url);
                if (!((String)name).equals(md5)) continue;
                it.remove();
                continue block0;
            }
        }
        return urls;
    }

    private void onCallbackUi(IFetchResourceFilePath callback, String path) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFetch(path);
        } else {
            YYTaskExecutor.postToMainThread(() -> callback.onFetch(path));
        }
    }

    private String filePath(ResPersistUtils.Dir dir, String url) {
        return this.getResDirPath(dir) + this.urlMd5(url);
    }

    private String urlMd5(String url) {
        if (this.mUrlMd5Cache.containsKey(url)) {
            return this.mUrlMd5Cache.get(url);
        }
        String md5 = MD5Utils.getMd5StringNew((String)url);
        this.mUrlMd5Cache.put(url, md5);
        return md5;
    }

    private void executor(Runnable task2) {
        this.getExecutor().execute(task2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IQueueTaskExecutor getExecutor() {
        if (this.mQueueExecutor != null) return this.mQueueExecutor;
        Class<ResourcePersist> clazz = ResourcePersist.class;
        synchronized (ResourcePersist.class) {
            if (this.mQueueExecutor != null) return this.mQueueExecutor;
            this.mQueueExecutor = YYTaskExecutor.createAQueueExcuter();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mQueueExecutor;
        }
    }

    private String resourceDir() {
        if (StringUtils.isNotEmpty((String)this.sResourceDir)) {
            return this.sResourceDir;
        }
        this.sResourceDir = FileStorageUtils.getInstance().getExternalCacheRootDir() + "/persist/";
        return this.sResourceDir;
    }

    public String getResDirPath(ResPersistUtils.Dir dir) {
        return this.resourceDir() + dir.dir + "/";
    }
}

