/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push;

import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.extensions.EventExtensionsKt;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateFormatUtils;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\n\u0010$\u001a\u0004\u0018\u00010#H\u0002J\n\u0010%\u001a\u0004\u0018\u00010#H\u0002J\b\u0010&\u001a\u00020'H\u0007J\b\u0010(\u001a\u00020\u001fH\u0002J\u001e\u0010)\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\b\u0010+\u001a\u00020'H\u0007J\b\u0010,\u001a\u00020'H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00068B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\rR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/yy/appbase/push/PushShowLimitManager;", "", "()V", "LIMIT_TIME_THRESHOLD", "", "TAG", "", "value", "", "mContinuousLastPushClickDate", "getMContinuousLastPushClickDate", "()J", "setMContinuousLastPushClickDate", "(J)V", "mDefaultShieldPushIdList", "", "mLastPushClickDate", "getMLastPushClickDate", "()Ljava/lang/String;", "setMLastPushClickDate", "(Ljava/lang/String;)V", "mLastPushShowDate", "getMLastPushShowDate", "setMLastPushShowDate", "shownCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "splashFinishedTime", "checkRestrict", "Lcom/yy/appbase/push/PushShowLimitManager$LimitType;", "pushId", "checkRestrictByState", "", "checkRestrictForActiveUser", "checkRestrictForNoClick", "getActiveUserTest", "Lcom/yy/appbase/abtest/IAB;", "getNoClickTest", "getShowLimitTest", "init", "", "isActiveUser", "isPushMatchShield", "pushShieldList", "updateForPushClick", "updateForPushShow", "LimitType", "appbase_debug"})
public final class PushShowLimitManager {
    private static final String TAG = "PushShowLimitManager";
    private static final int LIMIT_TIME_THRESHOLD = 3000;
    private static long mLastPushShowDate;
    private static String mLastPushClickDate;
    private static long mContinuousLastPushClickDate;
    private static final List<String> mDefaultShieldPushIdList;
    private static AtomicInteger shownCount;
    private static volatile long splashFinishedTime;
    public static final PushShowLimitManager INSTANCE;

    private final long getMLastPushShowDate() {
        if (mLastPushShowDate < 0L) {
            mLastPushShowDate = SettingFlags.getLongValue((String)"key_push_last_show_day", (long)System.currentTimeMillis());
        }
        return mLastPushShowDate;
    }

    private final void setMLastPushShowDate(long value) {
        if (mLastPushShowDate != value && value > 0L) {
            mLastPushShowDate = value;
            SettingFlags.setLongValue((String)"key_push_last_show_day", (long)value);
        }
    }

    private final String getMLastPushClickDate() {
        if (mLastPushClickDate == null) {
            mLastPushClickDate = SettingFlags.getStringValue((String)"key_push_click_data", (String)"");
        }
        return mLastPushClickDate;
    }

    private final void setMLastPushClickDate(String value) {
        if (Intrinsics.areEqual((Object)mLastPushClickDate, (Object)value) ^ true && value != null) {
            mLastPushClickDate = value;
            SettingFlags.setStringValue((String)"key_push_click_data", (String)value);
        }
    }

    private final long getMContinuousLastPushClickDate() {
        if (mContinuousLastPushClickDate < 0L && (mContinuousLastPushClickDate = SettingFlags.getLongValue((String)"key_continuous_push_no_click_date", (long)0L)) == 0L) {
            MLog.debug((Object)TAG, (String)"init PUSH_CONTINUOUS_NO_CLICK_DATE", (Object[])new Object[0]);
            mContinuousLastPushClickDate = System.currentTimeMillis();
            SettingFlags.setLongValue((String)"key_continuous_push_no_click_date", (long)mContinuousLastPushClickDate);
        }
        return mContinuousLastPushClickDate;
    }

    private final void setMContinuousLastPushClickDate(long value) {
        if (mContinuousLastPushClickDate != value && value > 0L) {
            mContinuousLastPushClickDate = value;
            SettingFlags.setLongValue((String)"key_continuous_push_no_click_date", (long)value);
        }
    }

    private final IAB getShowLimitTest() {
        return NewABDefine.PUSH_SHOW_LIMIT.getTest();
    }

    private final IAB getNoClickTest() {
        return NewABDefine.CONTINUOUS_NO_CLICK_USER_PUSH_SHIELD.getTest();
    }

    private final IAB getActiveUserTest() {
        return NewABDefine.ACTIVE_USER_PUSH_SHIELD.getTest();
    }

    @JvmStatic
    @NotNull
    public static final LimitType checkRestrict(long pushId) {
        boolean isRestrict = INSTANCE.checkRestrictByState(pushId);
        MLog.info((Object)TAG, (String)("checkRestrictByState: " + isRestrict), (Object[])new Object[0]);
        if (isRestrict) {
            return LimitType.LIMIT_SHOW;
        }
        IAB abValue = INSTANCE.getShowLimitTest();
        MLog.info((Object)TAG, (String)("check show limit ab: " + abValue), (Object[])new Object[0]);
        if (abValue == null || Intrinsics.areEqual((Object)abValue, (Object)NAB.A)) {
            return LimitType.NO_LIMIT;
        }
        int limitCount = Intrinsics.areEqual((Object)abValue, (Object)NAB.B) || Intrinsics.areEqual((Object)abValue, (Object)NAB.C) ? 3 : 0;
        long duration = splashFinishedTime == 0L ? 0L : System.currentTimeMillis() - splashFinishedTime;
        MLog.info((Object)TAG, (String)("check limit: showCount = " + shownCount.get() + ", duration = " + duration), (Object[])new Object[0]);
        if (duration <= (long)3000) {
            if (shownCount.getAndIncrement() >= limitCount) {
                return Intrinsics.areEqual((Object)abValue, (Object)NAB.C) ? LimitType.LIMIT_PRIORITY : LimitType.LIMIT_SHOW;
            }
        } else {
            shownCount.set(0);
        }
        return LimitType.NO_LIMIT;
    }

    @JvmStatic
    public static final void updateForPushShow() {
        long today = System.currentTimeMillis();
        MLog.info((Object)TAG, (String)"push show, last show time: %s, new show time: %s", (Object[])new Object[]{DateUtils.dateToString((long)INSTANCE.getMLastPushShowDate(), (String)"yyyy-MM-dd"), DateUtils.dateToString((long)today, (String)"yyyy-MM-dd")});
        INSTANCE.setMLastPushShowDate(today);
    }

    @JvmStatic
    public static final void updateForPushClick() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        String today = DateFormatUtils.dateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        MLog.info((Object)TAG, (String)("push click, today: " + today), (Object[])new Object[0]);
        INSTANCE.setMLastPushClickDate(today);
        INSTANCE.setMContinuousLastPushClickDate(System.currentTimeMillis());
        SettingFlags.setLongValue((String)"key_push_click_time", (long)System.currentTimeMillis());
    }

    @JvmStatic
    public static final void init() {
        MLog.info((Object)TAG, (String)"init splash finish time", (Object[])new Object[0]);
        splashFinishedTime = System.currentTimeMillis();
    }

    private final boolean checkRestrictByState(long pushId) {
        return this.checkRestrictForActiveUser(pushId) || this.checkRestrictForNoClick(pushId);
    }

    private final boolean checkRestrictForActiveUser(long pushId) {
        if (Intrinsics.areEqual((Object)this.getActiveUserTest(), (Object)NAB.B) ^ true) {
            MLog.info((Object)TAG, (String)"checkRestrictForActiveUser: active_user_push_shield ab not hit", (Object[])new Object[0]);
            return false;
        }
        boolean isActiveUser = this.isActiveUser();
        MLog.info((Object)TAG, (String)("checkActiveUser: is active user: " + isActiveUser + ", pushId: " + pushId), (Object[])new Object[0]);
        if (!isActiveUser) {
            return false;
        }
        List pushIdShieldList = mDefaultShieldPushIdList;
        String pushIdShield = SettingFlags.getStringValue((String)"push_active_user_shield_id", null);
        if (pushIdShield != null) {
            pushIdShieldList = StringsKt.split$default((CharSequence)pushIdShield, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        }
        String string2 = this.getMLastPushClickDate();
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        boolean isTodayHasClicked = Intrinsics.areEqual((Object)string2, (Object)DateFormatUtils.dateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd"));
        MLog.info((Object)TAG, (String)("checkActiveUser, last push click day: " + this.getMLastPushClickDate() + ", isTodayclicked: " + isTodayHasClicked + ", pushIdShieldList: " + pushIdShieldList), (Object[])new Object[0]);
        if (isTodayHasClicked && this.isPushMatchShield(pushId, pushIdShieldList)) {
            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20025571").put("function_id", "show_limit").put("push_id", String.valueOf(pushId)).put("limit", "1");
            Intrinsics.checkExpressionValueIsNotNull((Object)hiidoEvent, (String)"HiidoEvent.obtain().even\u2026       .put(\"limit\", \"1\")");
            EventExtensionsKt.report(hiidoEvent);
            return true;
        }
        return false;
    }

    private final boolean isPushMatchShield(long pushId, List<String> pushShieldList) {
        boolean bl = pushShieldList.contains(StringsKt.take((String)String.valueOf(pushId), (int)3));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean it = bl;
        boolean bl4 = false;
        MLog.debug((Object)TAG, (String)("isPushMatchShield result: " + it + ", pushId: " + pushId), (Object[])new Object[0]);
        return bl;
    }

    private final boolean checkRestrictForNoClick(long pushId) {
        int n;
        boolean bl;
        String string2;
        IAB abValue = this.getNoClickTest();
        if (abValue == null || Intrinsics.areEqual((Object)abValue, (Object)NAB.A)) {
            return false;
        }
        String dayConfig = SettingFlags.getStringValue((String)"key_push_continuous_day_list");
        MLog.info((Object)TAG, (String)("checkContinuousNoClickUser: ab = " + abValue + ", dayConfig = " + dayConfig + ", pushId: " + pushId), (Object[])new Object[0]);
        String string3 = dayConfig;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dayConfig");
        List countList = StringsKt.split$default((CharSequence)string3, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        Collection collection = countList;
        boolean bl2 = false;
        boolean bl3 = false;
        if (collection == null || collection.isEmpty() || countList.size() != 3) {
            return false;
        }
        IAB iAB = abValue;
        if (Intrinsics.areEqual((Object)iAB, (Object)NAB.B)) {
            string2 = (String)countList.get(0);
            bl = false;
            n = Integer.parseInt(string2);
        } else if (Intrinsics.areEqual((Object)iAB, (Object)NAB.C)) {
            string2 = (String)countList.get(1);
            bl = false;
            n = Integer.parseInt(string2);
        } else {
            string2 = (String)countList.get(2);
            bl = false;
            n = Integer.parseInt(string2);
        }
        int continuousLimitDay = n;
        List pushIdShieldList = mDefaultShieldPushIdList;
        String pushIdShield = SettingFlags.getStringValue((String)"push_noclick_user_shield_id", null);
        if (pushIdShield != null) {
            pushIdShieldList = StringsKt.split$default((CharSequence)pushIdShield, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        }
        int noClickDays = DateUtils.getIntervalDays((long)this.getMContinuousLastPushClickDate(), (long)System.currentTimeMillis());
        MLog.info((Object)TAG, (String)("checkContinuousNoClickUser: no click days: " + noClickDays + ", continuousLimitDay: " + continuousLimitDay + ", " + "pushIdShieldList: " + pushIdShieldList), (Object[])new Object[0]);
        if (noClickDays >= continuousLimitDay && this.isPushMatchShield(pushId, pushIdShieldList)) {
            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20025571").put("function_id", "show_limit").put("push_id", String.valueOf(pushId)).put("limit", "2");
            Intrinsics.checkExpressionValueIsNotNull((Object)hiidoEvent, (String)"HiidoEvent.obtain().even\u2026       .put(\"limit\", \"2\")");
            EventExtensionsKt.report(hiidoEvent);
            return true;
        }
        return false;
    }

    private final boolean isActiveUser() {
        long firstInstalledTime = SettingFlags.getLongValue((String)"key_first_install_time", (long)0L);
        int installedDay = DateUtils.getIntervalDays((long)firstInstalledTime, (long)System.currentTimeMillis());
        MLog.info((Object)TAG, (String)("installed day  = " + installedDay), (Object[])new Object[0]);
        if (installedDay < 3) {
            return false;
        }
        long lastForegroundTime = SettingFlags.getLongValue((String)"key_last_foreground_time", (long)0L);
        if (lastForegroundTime > 0L) {
            int lastForegroundDuring = DateUtils.getIntervalDays((long)lastForegroundTime, (long)System.currentTimeMillis());
            MLog.info((Object)TAG, (String)("last foreground day difference: " + lastForegroundDuring), (Object[])new Object[0]);
            if (lastForegroundDuring < 3) {
                return true;
            }
        }
        return false;
    }

    private PushShowLimitManager() {
    }

    static {
        PushShowLimitManager pushShowLimitManager;
        INSTANCE = pushShowLimitManager = new PushShowLimitManager();
        mLastPushShowDate = -1L;
        mContinuousLastPushClickDate = -1L;
        mDefaultShieldPushIdList = CollectionsKt.listOf((Object[])new String[]{"718", "720", "728", "512"});
        shownCount = new AtomicInteger(0);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/yy/appbase/push/PushShowLimitManager$LimitType;", "", "type", "", "(Ljava/lang/String;II)V", "getType", "()I", "NO_LIMIT", "LIMIT_SHOW", "LIMIT_PRIORITY", "appbase_debug"})
    public static final class LimitType
    extends Enum<LimitType> {
        public static final /* enum */ LimitType NO_LIMIT;
        public static final /* enum */ LimitType LIMIT_SHOW;
        public static final /* enum */ LimitType LIMIT_PRIORITY;
        private static final /* synthetic */ LimitType[] $VALUES;
        private final int type;

        static {
            LimitType[] limitTypeArray = new LimitType[3];
            LimitType[] limitTypeArray2 = limitTypeArray;
            limitTypeArray[0] = NO_LIMIT = new LimitType(0);
            limitTypeArray[1] = LIMIT_SHOW = new LimitType(1);
            limitTypeArray[2] = LIMIT_PRIORITY = new LimitType(2);
            $VALUES = limitTypeArray;
        }

        public final int getType() {
            return this.type;
        }

        private LimitType(int type2) {
            this.type = type2;
        }

        public static LimitType[] values() {
            return (LimitType[])$VALUES.clone();
        }

        public static LimitType valueOf(String string2) {
            return Enum.valueOf(LimitType.class, string2);
        }
    }
}

