/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.widget.RemoteViews;
import androidx.annotation.DrawableRes;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.badger.ShortcutBadger;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.push.ChannelType;
import com.yy.appbase.push.GroupType;
import com.yy.appbase.push.NotificationIdGenerator;
import com.yy.appbase.push.NotificationManager;
import com.yy.appbase.push.NotificationTrack;
import com.yy.appbase.push.NotifyIdInfo;
import com.yy.appbase.push.NotifyIdPostInfo;
import com.yy.appbase.push.PushBuilderBundle;
import com.yy.appbase.push.PushChannelAndGroupKt;
import com.yy.appbase.push.PushConfigManager;
import com.yy.appbase.push.PushIntentBundle;
import com.yy.appbase.push.PushNotification;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.PushShowLimitManager;
import com.yy.appbase.push.PushViewBundle;
import com.yy.appbase.push.pushhiido.ISimpleCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import ikxd.msg.PushPayloadType;
import ikxd.msg.PushSourceType;
import ikxd.msg.StyleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import net.ihago.bbs.srv.entity.PostType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J@\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u000eH\u0002J;\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\n2!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020(0*H\u0002J\b\u0010.\u001a\u00020(H\u0002J\u000e\u0010/\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u00100\u001a\u00020\nH\u0002J\u000e\u00101\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u00101\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/yy/appbase/push/PushNotification;", "", "data", "Lcom/yy/appbase/push/PushNotificationData;", "(Lcom/yy/appbase/push/PushNotificationData;)V", "getData", "()Lcom/yy/appbase/push/PushNotificationData;", "mBuilderBundle", "Lcom/yy/appbase/push/PushBuilderBundle;", "mFirstScreenPresent", "", "mIdInfo", "Lcom/yy/appbase/push/NotifyIdInfo;", "createNotificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "ongoing", "createSummaryNotificationBuilder", "formatBbsPostContent", "", "context", "Landroid/content/Context;", "type", "Likxd/msg/PushSourceType;", "postType", "", "postId", "batchCount", "content", "lastNick", "getFriendPayloadString", "getProfilePayloadString", "getShowContent", "getShowTitle", "initIntentBundle", "Lcom/yy/appbase/push/PushIntentBundle;", "initViewBundle", "Lcom/yy/appbase/push/PushViewBundle;", "intentBundle", "builder", "prepareBuilder", "", "callback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "builderBundle", "prepareShow", "reshow", "shouldGroupBy", "show", "Companion", "appbase_debug"})
public final class PushNotification {
    private final NotifyIdInfo mIdInfo;
    private PushBuilderBundle mBuilderBundle;
    private boolean mFirstScreenPresent;
    @NotNull
    private final PushNotificationData data;
    private static final String TAG = "PushNotification";
    private static final String KEY_FIRST_SCREEN_PRESENT = "screen_present_time";
    private static final String PUSH_INTENT_FLAG = "push_intent_flag";
    private static final Map<Integer, List<NotifyIdInfo>> groupMap;
    private static final List<Integer> shownIds;
    private static int requestCode;
    private static final HashMap<String, NotifyIdPostInfo> mPostNotifyInfoMap;
    public static final Companion Companion;

    public final void show(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PushConfigManager.getInstance().getPushOngoingValue(this.data, new ISimpleCallback<Boolean>(this, context){
            final /* synthetic */ PushNotification this$0;
            final /* synthetic */ Context $context;

            public void onSuccess(boolean ongoing) {
                PushNotification.access$prepareShow(this.this$0);
                MLog.info((Object)"PushNotification", (String)("show data: " + this.this$0.getData() + ", ongoing: " + ongoing + ", idInfo: " + PushNotification.access$getMIdInfo$p(this.this$0)), (Object[])new Object[0]);
                PushNotification.access$prepareBuilder(this.this$0, this.$context, ongoing, (Function1)new Function1<PushBuilderBundle, Unit>(this){
                    final /* synthetic */ show.1 this$0;

                    public final void invoke(@NotNull PushBuilderBundle it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        PushNotification.access$show(this.this$0.this$0, this.this$0.$context, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        });
    }

    public final void reshow(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Companion.isNotifyIdExist(this.mIdInfo)) {
            if (!this.mFirstScreenPresent) {
                long lastScreenPresentTime = SettingFlags.getLongValue((String)KEY_FIRST_SCREEN_PRESENT);
                long during = System.currentTimeMillis() - lastScreenPresentTime;
                if (during < (long)3600000) {
                    MLog.warn((Object)TAG, (String)("reshow pushId: " + this.data.getPushId() + ", content: " + this.data.getContent() + " ignore, " + "during is less than one hour"), (Object[])new Object[0]);
                    return;
                }
            }
            MLog.info((Object)TAG, (String)("reshow pushId: " + this.data.getPushId() + ", content: " + this.data.getContent()), (Object[])new Object[0]);
            this.show(context, this.mBuilderBundle);
            SettingFlags.setLongValue((String)KEY_FIRST_SCREEN_PRESENT, (long)System.currentTimeMillis());
            this.mFirstScreenPresent = false;
            NotificationTrack.INSTANCE.reportShowAgain(this.data);
        }
    }

    private final NotificationCompat.Builder createNotificationBuilder(boolean ongoing) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(RuntimeContext.sApplicationContext, this.data.getNotifyChannel().getId());
        boolean bl = false;
        boolean bl2 = false;
        NotificationCompat.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.setVisibility(1);
        $this$apply.setAutoCancel(true);
        $this$apply.setShowWhen(true);
        $this$apply.setWhen(System.currentTimeMillis());
        $this$apply.setSmallIcon(Companion.getSmallIcon());
        $this$apply.setOngoing(ongoing);
        $this$apply.setPriority(this.data.getPushPriority().getPriority());
        $this$apply.setCategory(this.data.getNotifyChannel() == ChannelType.IM_MESSAGES ? "social" : "recommendation");
        if (this.shouldGroupBy()) {
            $this$apply.setGroup(String.valueOf(this.data.getGroup().getId()));
        }
        return builder;
    }

    private final NotificationCompat.Builder createSummaryNotificationBuilder() {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(RuntimeContext.sApplicationContext, this.data.getNotifyChannel().getId());
        boolean bl = false;
        boolean bl2 = false;
        NotificationCompat.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.setVisibility(1);
        $this$apply.setAutoCancel(true);
        $this$apply.setPriority(this.data.getPushPriority().getPriority());
        $this$apply.setShowWhen(true);
        $this$apply.setWhen(System.currentTimeMillis());
        $this$apply.setSmallIcon(Companion.getSmallIcon());
        $this$apply.setContentTitle((CharSequence)this.data.getGroup().getVisibleName());
        $this$apply.setContentText((CharSequence)this.data.getContent());
        $this$apply.setGroup(String.valueOf(this.data.getGroup().getId()));
        $this$apply.setGroupSummary(true);
        return builder;
    }

    private final boolean shouldGroupBy() {
        boolean can;
        boolean bl = can = AccountUtil.isTodayRegister() || this.data.getGroup() != GroupType.PUSH_BACKSTAGE;
        if (can) {
            PushConfigManager pushConfigManager = PushConfigManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)pushConfigManager, (String)"PushConfigManager.getInstance()");
            can = !pushConfigManager.isGroupBlackList();
        }
        MLog.debug((Object)TAG, (String)("shouldGroupBy " + can), (Object[])new Object[0]);
        return can;
    }

    private final void show(Context context, PushBuilderBundle builderBundle) {
        if (builderBundle == null) {
            return;
        }
        this.mBuilderBundle = builderBundle;
        Companion.notify(this.mIdInfo, builderBundle.getNormalBuilder(), builderBundle.getSummaryBuilder());
        if (builderBundle.getNormalBuilder() != null) {
            PushShowLimitManager.updateForPushShow();
            NotificationTrack.INSTANCE.reportShowPush(context, this.data);
            NotificationCenter.getGlobalInstance().notify(com.yy.framework.core.Notification.obtain((int)NotificationDef.N_DESKTOP_BADGE_REFRESH));
        }
    }

    private final void prepareBuilder(Context context, boolean ongoing, Function1<? super PushBuilderBundle, Unit> callback) {
        YYTaskExecutor.execute((Runnable)new Runnable(this, ongoing, context, callback){
            final /* synthetic */ PushNotification this$0;
            final /* synthetic */ boolean $ongoing;
            final /* synthetic */ Context $context;
            final /* synthetic */ Function1 $callback;

            public final void run() {
                try {
                    PushBuilderBundle builderBundle = new PushBuilderBundle();
                    NotificationCompat.Builder normalBuilder = PushNotification.access$createNotificationBuilder(this.this$0, this.$ongoing);
                    builderBundle.setNormalBuilder(normalBuilder);
                    PushIntentBundle intentBundle = PushNotification.access$initIntentBundle(this.this$0, this.$context);
                    PushNotification.access$initViewBundle(this.this$0, this.$context, intentBundle, normalBuilder);
                    normalBuilder.setContentIntent(intentBundle.getResultIntent());
                    if (Build.VERSION.SDK_INT >= 24 && PushNotification.access$shouldGroupBy(this.this$0)) {
                        builderBundle.setSummaryBuilder(PushNotification.access$createSummaryNotificationBuilder(this.this$0));
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, builderBundle){
                        final /* synthetic */ prepareBuilder.1 this$0;
                        final /* synthetic */ PushBuilderBundle $builderBundle;

                        public final void run() {
                            this.this$0.$callback.invoke((Object)this.$builderBundle);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$builderBundle = pushBuilderBundle;
                        }
                    });
                }
                catch (Exception ex) {
                    MLog.error((Object)"PushNotification", (String)"prepareBuilder fail", (Throwable)ex, (Object[])new Object[0]);
                }
            }
            {
                this.this$0 = pushNotification;
                this.$ongoing = bl;
                this.$context = context;
                this.$callback = function1;
            }
        });
    }

    private final void prepareShow() {
        JSONObject jsonObject;
        if ((this.data.getPushSource() == PushSourceType.kPushSourceBBSPostLike || this.data.getPushSource() == PushSourceType.kPushSourceBBSCommentLike) && (jsonObject = this.data.getPayloadJson().optJSONObject("post")) != null) {
            String postId = jsonObject.optString("postid", "");
            int batchCount = jsonObject.optInt("batch_count", 0);
            String string2 = postId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"postId");
            PushNotification.Companion.addPostNotifyInfo(this.mIdInfo, string2, batchCount);
        }
        this.data.setIdInfo(this.mIdInfo);
    }

    private final String getShowTitle(Context context) {
        String finalTitle;
        String string2 = this.data.getTitle();
        if (string2 == null) {
            string2 = finalTitle = "";
        }
        if (PushChannelAndGroupKt.isImPayload(this.data.getPushSource(), this.data.getPayloadJson())) {
            String string3;
            String string4;
            if (finalTitle.length() > 16) {
                string4 = finalTitle;
                int n = 0;
                int n2 = 16;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string7 = string6;
                string3 = stringBuilder.append(string7).append("...").toString();
            } else {
                string3 = finalTitle;
            }
            finalTitle = string3;
            try {
                int unreadCount = KvoModuleManager.getModule(ImModule.class).getSessionUnRead(this.data.getImSession()) + 1;
                String unreadString = unreadCount > 99 ? "99+" : String.valueOf(unreadCount);
                String string8 = finalTitle + "[" + unreadString + "]";
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"StringBuilder(finalTitle\u2026g).append(\"]\").toString()");
                string4 = string8;
            }
            catch (Exception e) {
                string4 = finalTitle;
            }
            finalTitle = string4;
        }
        return finalTitle;
    }

    private final String getShowContent(Context context) {
        JSONObject jsonObject;
        String finalContent;
        String string2 = this.data.getContent();
        if (string2 == null) {
            string2 = finalContent = "";
        }
        if ((this.data.getPushSource() == PushSourceType.kPushSourceBBSPostLike || this.data.getPushSource() == PushSourceType.kPushSourceBBSCommentLike) && (jsonObject = this.data.getPayloadJson().optJSONObject("post")) != null) {
            String postId = jsonObject.optString("postid", "");
            int batchCount = jsonObject.optInt("batch_count", 0);
            String lastNick = jsonObject.optString("last_nick", "");
            int postType = jsonObject.optInt("posttype", -1);
            PushSourceType pushSourceType = this.data.getPushSource();
            String string3 = postId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"postId");
            String string4 = lastNick;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"lastNick");
            finalContent = this.formatBbsPostContent(context, pushSourceType, postType, string3, batchCount, finalContent, string4);
        }
        return finalContent;
    }

    private final String getProfilePayloadString() {
        try {
            JSONObject payloadJson = JsonParser.obtainJSONObject();
            payloadJson.put("type", PushPayloadType.kPushPayloadUInfo.getValue());
            payloadJson.put("push_source", (Object)this.data.getPushSource());
            payloadJson.put("push_id", this.data.getPushId());
            payloadJson.put("notify_id", (Object)this.mIdInfo);
            JSONObject infoJson = JsonParser.obtainJSONObject();
            infoJson.put("uid", this.data.getUid());
            payloadJson.put("uinfo", (Object)infoJson);
            String string2 = payloadJson.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"payloadJson.toString()");
            return string2;
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return "";
        }
    }

    private final String getFriendPayloadString() {
        try {
            JSONObject payloadJson = JsonParser.obtainJSONObject();
            payloadJson.put("type", PushPayloadType.kPushPayloadFriend.getValue());
            payloadJson.put("push_source", (Object)this.data.getPushSource());
            payloadJson.put("push_id", this.data.getPushId());
            payloadJson.put("notify_id", (Object)this.mIdInfo);
            String string2 = payloadJson.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"payloadJson.toString()");
            return string2;
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return "";
        }
    }

    private final String formatBbsPostContent(Context context, PushSourceType type2, int postType, String postId, int batchCount, String content, String lastNick) {
        NotifyIdPostInfo notify2 = PushNotification.Companion.findPostNotifyId(postId);
        if (notify2 != null && batchCount > 0) {
            MLog.debug((Object)TAG, (String)"formatBbsPostContent lastCount:%d\uff0cbatchCount:%d", (Object[])new Object[]{notify2.getCount(), batchCount});
            Companion.cancel(notify2.getNotifyIdInfo());
            int otherCount = notify2.getCount() + batchCount - 1;
            if (otherCount <= 0) {
                return content;
            }
            if (type2 == PushSourceType.kPushSourceBBSPostLike) {
                if (postType == PostType.POST_TYPE_ROOT.getValue()) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = context.getString(R.string.push_bbs_post_like_batch);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026push_bbs_post_like_batch)");
                    String string3 = string2;
                    Object[] objectArray = new Object[]{lastNick, otherCount};
                    boolean bl = false;
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                    return string4;
                }
                if (postType == PostType.POST_TYPE_COMMENT.getValue()) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string5 = context.getString(R.string.push_bbs_comment_like_batch);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"context.getString(R.stri\u2026h_bbs_comment_like_batch)");
                    String string6 = string5;
                    Object[] objectArray = new Object[]{lastNick, otherCount};
                    boolean bl = false;
                    String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
                    return string7;
                }
            } else if (type2 == PushSourceType.kPushSourceBBSCommentLike) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string8 = context.getString(R.string.push_bbs_reply_like_batch);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"context.getString(R.stri\u2026ush_bbs_reply_like_batch)");
                String string9 = string8;
                Object[] objectArray = new Object[]{lastNick, otherCount};
                boolean bl = false;
                String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"java.lang.String.format(format, *args)");
                return string10;
            }
        }
        return content;
    }

    private final PushIntentBundle initIntentBundle(Context context) {
        ComponentName cn;
        Intent resultIntent = null;
        Intent profileResultIntent = null;
        Intent addIntent = null;
        if (Intrinsics.areEqual((Object)"128", (Object)this.data.getFromChannel())) {
            resultIntent = new Intent("android.intent.action.VIEW");
            resultIntent.addCategory("android.intent.category.DEFAULT");
            resultIntent.putExtra(PUSH_INTENT_FLAG, true);
            cn = new ComponentName(AppKeysDef.getAppPackageName(), "com.yy.hiyo.MainActivity");
            resultIntent.setComponent(cn);
            profileResultIntent = new Intent("android.intent.action.VIEW");
            profileResultIntent.addCategory("android.intent.category.DEFAULT");
            profileResultIntent.putExtra(PUSH_INTENT_FLAG, true);
            profileResultIntent.setComponent(cn);
            addIntent = new Intent("android.intent.action.VIEW");
            addIntent.addCategory("android.intent.category.DEFAULT");
            addIntent.putExtra(PUSH_INTENT_FLAG, true);
            addIntent.setComponent(cn);
        } else {
            resultIntent = new Intent();
            cn = new ComponentName(AppKeysDef.getAppPackageName(), AppKeysDef.getLauncherActivity());
            resultIntent.setComponent(cn);
            resultIntent.setAction("yylitepushinfo");
            profileResultIntent = new Intent();
            profileResultIntent.setAction("yylitepushinfo");
            profileResultIntent.setComponent(cn);
            addIntent = new Intent();
            addIntent.setAction("yylitepushinfo");
            addIntent.setComponent(cn);
        }
        resultIntent.putExtra("payload", this.data.getPayloadString());
        resultIntent.putExtra("offline_msg", this.data.isOffline());
        resultIntent.addFlags(0x10200000);
        profileResultIntent.addFlags(0x10200000);
        profileResultIntent.putExtra("payload", this.getProfilePayloadString());
        profileResultIntent.putExtra("offline_msg", this.data.isOffline());
        addIntent.addFlags(0x10200000);
        addIntent.putExtra("payload", this.getFriendPayloadString());
        addIntent.putExtra("offline_msg", this.data.isOffline());
        PushIntentBundle pushIntentBundle = new PushIntentBundle();
        boolean bl = false;
        boolean bl2 = false;
        PushIntentBundle $this$apply = pushIntentBundle;
        boolean bl3 = false;
        int n = requestCode;
        requestCode = n + 1;
        $this$apply.setResultIntent(PendingIntent.getActivity((Context)context, (int)n, (Intent)resultIntent, (int)0x8000000));
        n = requestCode;
        requestCode = n + 1;
        $this$apply.setProfileIntent(PendingIntent.getActivity((Context)context, (int)n, (Intent)profileResultIntent, (int)0x8000000));
        n = requestCode;
        requestCode = n + 1;
        $this$apply.setAddIntent(PendingIntent.getActivity((Context)context, (int)n, (Intent)addIntent, (int)0x8000000));
        return pushIntentBundle;
    }

    private final PushViewBundle initViewBundle(Context context, PushIntentBundle intentBundle, NotificationCompat.Builder builder) {
        PushViewBundle viewBundle = new PushViewBundle();
        if (this.data.getStyle() == StyleType.StyleTypeBig64.getValue()) {
            viewBundle.setNormalView(new RemoteViews(context.getPackageName(), R.layout.layout_push_activity_content));
        } else {
            viewBundle.setNormalView(new RemoteViews(context.getPackageName(), R.layout.layout_push_common_content));
        }
        viewBundle.setSmallView(new RemoteViews(context.getPackageName(), R.layout.layout_push_content));
        String newContent = this.getShowContent(context);
        String newTitle = this.getShowTitle(context);
        RemoteViews remoteViews = viewBundle.getNormalView();
        if (remoteViews != null) {
            remoteViews.setTextViewText(R.id.tv_push_content_content, (CharSequence)newContent);
        }
        RemoteViews remoteViews2 = viewBundle.getNormalView();
        if (remoteViews2 != null) {
            remoteViews2.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
        }
        int n = this.data.getStyle();
        if (n == StyleType.StyleTypeGameInvite.getValue()) {
            viewBundle.setBigView(new RemoteViews(context.getPackageName(), R.layout.layout_push_large_two_btn_content));
            RemoteViews remoteViews3 = viewBundle.getBigView();
            if (remoteViews3 != null) {
                remoteViews3.setOnClickPendingIntent(R.id.tv_left, intentBundle.getProfileIntent());
            }
            RemoteViews remoteViews4 = viewBundle.getBigView();
            if (remoteViews4 != null) {
                remoteViews4.setOnClickPendingIntent(R.id.tv_right, intentBundle.getResultIntent());
            }
            RemoteViews remoteViews5 = viewBundle.getBigView();
            if (remoteViews5 != null) {
                remoteViews5.setTextViewText(R.id.tv_left, (CharSequence)ResourceUtils.getString((int)R.string.btn_push_look));
            }
            RemoteViews remoteViews6 = viewBundle.getBigView();
            if (remoteViews6 != null) {
                remoteViews6.setTextViewText(R.id.tv_right, (CharSequence)ResourceUtils.getString((int)R.string.btn_push_go));
            }
        } else if (n == StyleType.StyleTypeFriend.getValue()) {
            viewBundle.setBigView(new RemoteViews(context.getPackageName(), R.layout.layout_push_large_two_btn_content));
            RemoteViews remoteViews7 = viewBundle.getBigView();
            if (remoteViews7 != null) {
                remoteViews7.setOnClickPendingIntent(R.id.tv_left, intentBundle.getProfileIntent());
            }
            RemoteViews remoteViews8 = viewBundle.getBigView();
            if (remoteViews8 != null) {
                remoteViews8.setOnClickPendingIntent(R.id.tv_right, intentBundle.getAddIntent());
            }
            RemoteViews remoteViews9 = viewBundle.getBigView();
            if (remoteViews9 != null) {
                remoteViews9.setTextViewText(R.id.tv_left, (CharSequence)ResourceUtils.getString((int)R.string.btn_push_look));
            }
            RemoteViews remoteViews10 = viewBundle.getBigView();
            if (remoteViews10 != null) {
                remoteViews10.setTextViewText(R.id.tv_right, (CharSequence)ResourceUtils.getString((int)R.string.profile_add));
            }
        } else if (n == StyleType.StyleTypeBigButton.getValue()) {
            viewBundle.setSmallView(new RemoteViews(context.getPackageName(), R.layout.layout_push_activity_small_content));
            viewBundle.setBigView(new RemoteViews(context.getPackageName(), R.layout.layout_push_activity_button_large_content));
            if (this.data.getBlurBitmapUri() != null) {
                RemoteViews remoteViews11 = viewBundle.getBigView();
                if (remoteViews11 != null) {
                    remoteViews11.setImageViewUri(R.id.blur_background, this.data.getBlurBitmapUri());
                }
            }
        } else if (n == StyleType.StyleTypeSmallButton.getValue()) {
            viewBundle.setSmallView(new RemoteViews(context.getPackageName(), R.layout.layout_push_content));
            viewBundle.setBigView(new RemoteViews(context.getPackageName(), R.layout.layout_push_large_one_btn_content));
            RemoteViews remoteViews12 = viewBundle.getBigView();
            if (remoteViews12 != null) {
                remoteViews12.setOnClickPendingIntent(R.id.tv_profile, intentBundle.getResultIntent());
            }
        } else if (n == StyleType.StyleTypeAcceptSquareSmallButton.getValue()) {
            viewBundle.setNormalView(new RemoteViews(context.getPackageName(), R.layout.layout_push_round_image_with_btn));
            RemoteViews remoteViews13 = viewBundle.getNormalView();
            if (remoteViews13 != null) {
                remoteViews13.setTextViewText(R.id.tv_profile, (CharSequence)ResourceUtils.getString((int)R.string.im_push_accept));
            }
            RemoteViews remoteViews14 = viewBundle.getNormalView();
            if (remoteViews14 != null) {
                remoteViews14.setOnClickPendingIntent(R.id.tv_profile, intentBundle.getResultIntent());
            }
            RemoteViews remoteViews15 = viewBundle.getNormalView();
            if (remoteViews15 != null) {
                remoteViews15.setTextViewText(R.id.tv_push_content_content, (CharSequence)newContent);
            }
            RemoteViews remoteViews16 = viewBundle.getNormalView();
            if (remoteViews16 != null) {
                remoteViews16.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
            }
        } else if (n == StyleType.StyleTypeViewSquareSmallButton.getValue()) {
            viewBundle.setNormalView(new RemoteViews(context.getPackageName(), R.layout.layout_push_round_image_with_btn));
            RemoteViews remoteViews17 = viewBundle.getNormalView();
            if (remoteViews17 != null) {
                remoteViews17.setTextViewText(R.id.tv_profile, (CharSequence)ResourceUtils.getString((int)R.string.btn_push_look));
            }
            RemoteViews remoteViews18 = viewBundle.getNormalView();
            if (remoteViews18 != null) {
                remoteViews18.setOnClickPendingIntent(R.id.tv_profile, intentBundle.getResultIntent());
            }
            RemoteViews remoteViews19 = viewBundle.getNormalView();
            if (remoteViews19 != null) {
                remoteViews19.setTextViewText(R.id.tv_push_content_content, (CharSequence)newContent);
            }
            RemoteViews remoteViews20 = viewBundle.getNormalView();
            if (remoteViews20 != null) {
                remoteViews20.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
            }
        } else if (n == StyleType.StyleTypeViewCircleSmallButton.getValue()) {
            viewBundle.setNormalView(new RemoteViews(context.getPackageName(), R.layout.layout_push_round_image_with_btn));
            RemoteViews remoteViews21 = viewBundle.getNormalView();
            if (remoteViews21 != null) {
                remoteViews21.setTextViewText(R.id.tv_profile, (CharSequence)ResourceUtils.getString((int)R.string.btn_push_look));
            }
            RemoteViews remoteViews22 = viewBundle.getNormalView();
            if (remoteViews22 != null) {
                remoteViews22.setOnClickPendingIntent(R.id.tv_profile, intentBundle.getResultIntent());
            }
            RemoteViews remoteViews23 = viewBundle.getNormalView();
            if (remoteViews23 != null) {
                remoteViews23.setTextViewText(R.id.tv_push_content_content, (CharSequence)newContent);
            }
            RemoteViews remoteViews24 = viewBundle.getNormalView();
            if (remoteViews24 != null) {
                remoteViews24.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
            }
        } else if (n == StyleType.StyleTypeTitleAcceptButton.getValue()) {
            viewBundle.setNormalView(new RemoteViews(context.getPackageName(), R.layout.layout_push_only_title_with_btn));
            RemoteViews remoteViews25 = viewBundle.getNormalView();
            if (remoteViews25 != null) {
                remoteViews25.setTextViewText(R.id.tv_profile, (CharSequence)ResourceUtils.getString((int)R.string.btn_push_look));
            }
            RemoteViews remoteViews26 = viewBundle.getNormalView();
            if (remoteViews26 != null) {
                remoteViews26.setOnClickPendingIntent(R.id.tv_profile, intentBundle.getResultIntent());
            }
            RemoteViews remoteViews27 = viewBundle.getNormalView();
            if (remoteViews27 != null) {
                remoteViews27.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
            }
        } else if (n == StyleType.StyleTypeBackgroundTitleStyle.getValue()) {
            viewBundle.setNormalView(new RemoteViews(context.getPackageName(), R.layout.layout_push_with_bg_only_title));
            RemoteViews remoteViews28 = viewBundle.getNormalView();
            if (remoteViews28 != null) {
                remoteViews28.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
            }
            if (this.data.getBitmapUri() != null) {
                RemoteViews remoteViews29 = viewBundle.getNormalView();
                if (remoteViews29 != null) {
                    remoteViews29.setImageViewUri(R.id.iv_bg, this.data.getBitmapUri());
                }
            }
        } else if (n != StyleType.StyleTypeMedia.getValue()) {
            viewBundle.setBigView(new RemoteViews(context.getPackageName(), R.layout.layout_push_large_content));
            if (this.data.getBitmapUri() != null) {
                RemoteViews remoteViews30 = viewBundle.getNormalView();
                if (remoteViews30 != null) {
                    remoteViews30.setImageViewUri(R.id.iv_bg, this.data.getBitmapUri());
                }
            }
        }
        RemoteViews remoteViews31 = viewBundle.getSmallView();
        if (remoteViews31 != null) {
            remoteViews31.setTextViewText(R.id.tv_push_content_content, (CharSequence)newContent);
        }
        RemoteViews remoteViews32 = viewBundle.getSmallView();
        if (remoteViews32 != null) {
            remoteViews32.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
        }
        RemoteViews remoteViews33 = viewBundle.getBigView();
        if (remoteViews33 != null) {
            remoteViews33.setTextViewText(R.id.tv_push_content_content, (CharSequence)newContent);
        }
        RemoteViews remoteViews34 = viewBundle.getBigView();
        if (remoteViews34 != null) {
            remoteViews34.setTextViewText(R.id.tv_push_tittle, (CharSequence)newTitle);
        }
        if (newContent.length() > 50 && viewBundle.getBigView() != null) {
            RemoteViews remoteViews35 = viewBundle.getNormalView();
            if (remoteViews35 != null) {
                remoteViews35.setTextViewTextSize(R.id.tv_push_content_content, 1, 12.0f);
            }
            RemoteViews remoteViews36 = viewBundle.getBigView();
            if (remoteViews36 != null) {
                remoteViews36.setTextViewTextSize(R.id.tv_push_content_content, 1, 12.0f);
            }
            RemoteViews remoteViews37 = viewBundle.getSmallView();
            if (remoteViews37 != null) {
                remoteViews37.setTextViewTextSize(R.id.tv_push_content_content, 1, 12.0f);
            }
        }
        if (this.data.getBitmapUri() != null) {
            RemoteViews remoteViews38 = viewBundle.getNormalView();
            if (remoteViews38 != null) {
                remoteViews38.setImageViewUri(R.id.iv_push_avatar, this.data.getBitmapUri());
            }
            RemoteViews remoteViews39 = viewBundle.getBigView();
            if (remoteViews39 != null) {
                remoteViews39.setImageViewUri(R.id.iv_push_avatar, this.data.getBitmapUri());
            }
            RemoteViews remoteViews40 = viewBundle.getSmallView();
            if (remoteViews40 != null) {
                remoteViews40.setImageViewUri(R.id.iv_push_avatar, this.data.getBitmapUri());
            }
        } else {
            RemoteViews remoteViews41 = viewBundle.getNormalView();
            if (remoteViews41 != null) {
                remoteViews41.setImageViewResource(R.id.iv_push_avatar, R.drawable.icon_avatar_default_male);
            }
            RemoteViews remoteViews42 = viewBundle.getBigView();
            if (remoteViews42 != null) {
                remoteViews42.setImageViewResource(R.id.iv_push_avatar, R.drawable.icon_avatar_default_male);
            }
            RemoteViews remoteViews43 = viewBundle.getSmallView();
            if (remoteViews43 != null) {
                remoteViews43.setImageViewResource(R.id.iv_push_avatar, R.drawable.icon_avatar_default_male);
            }
        }
        if (this.data.isNeedExpand()) {
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle());
                builder.setCustomContentView(viewBundle.getSmallView());
            } else {
                builder.setCustomContentView(viewBundle.getNormalView());
            }
            builder.setCustomBigContentView(viewBundle.getBigView());
        } else {
            builder.setCustomContentView(viewBundle.getNormalView());
        }
        builder.setContentText((CharSequence)newContent);
        builder.setContentTitle((CharSequence)newTitle);
        MLog.info((Object)TAG, (String)("show newContent: " + newContent + ", newTitle: " + newTitle + " idInfo: " + this.mIdInfo), (Object[])new Object[0]);
        return viewBundle;
    }

    @NotNull
    public final PushNotificationData getData() {
        return this.data;
    }

    private PushNotification(PushNotificationData data2) {
        this.data = data2;
        this.mIdInfo = new NotifyIdInfo(NotificationIdGenerator.getInstance().getId(this.data), this.data.getGroup().getId());
        this.mFirstScreenPresent = true;
        if (Build.VERSION.SDK_INT >= 26) {
            android.app.NotificationManager notificationManager = SystemServiceUtils.getNotificationManager((Context)RuntimeContext.sApplicationContext);
            NotificationChannel channel = new NotificationChannel(this.data.getNotifyChannel().getId(), (CharSequence)this.data.getNotifyChannel().getVisibleName(), this.data.getPushPriority().getImportance());
            channel.setShowBadge(true);
            notificationManager.createNotificationChannel(channel);
            channel.setLockscreenVisibility(1);
            MLog.info((Object)TAG, (String)("init, priority = " + this.data.getPushPriority() + ", NotificationChannel: " + channel), (Object[])new Object[0]);
        }
    }

    static {
        Pair[] pairArray;
        Companion = new Companion(null);
        Integer n = GroupType.IM_MESSAGES.getId();
        int n2 = 0;
        Pair[] pairArray2 = pairArray = new Pair[4];
        boolean bl = false;
        List list = new ArrayList();
        pairArray[n2] = TuplesKt.to((Object)n, (Object)list);
        n = GroupType.CHANNEL_MESSAGES.getId();
        n2 = 1;
        pairArray = pairArray2;
        bl = false;
        list = new ArrayList();
        pairArray[n2] = TuplesKt.to((Object)n, (Object)list);
        n = GroupType.PUSH_BACKSTAGE.getId();
        n2 = 2;
        pairArray = pairArray2;
        bl = false;
        list = new ArrayList();
        pairArray[n2] = TuplesKt.to((Object)n, (Object)list);
        n = GroupType.NOTIFICATIONS.getId();
        n2 = 3;
        pairArray = pairArray2;
        bl = false;
        list = new ArrayList();
        pairArray[n2] = TuplesKt.to((Object)n, (Object)list);
        groupMap = MapsKt.mapOf((Pair[])pairArray2);
        bl = false;
        shownIds = new ArrayList();
        mPostNotifyInfoMap = new HashMap();
    }

    public static final /* synthetic */ void access$prepareShow(PushNotification $this) {
        $this.prepareShow();
    }

    public static final /* synthetic */ NotifyIdInfo access$getMIdInfo$p(PushNotification $this) {
        return $this.mIdInfo;
    }

    public static final /* synthetic */ void access$prepareBuilder(PushNotification $this, Context context, boolean ongoing, Function1 callback) {
        $this.prepareBuilder(context, ongoing, (Function1<? super PushBuilderBundle, Unit>)callback);
    }

    public static final /* synthetic */ void access$show(PushNotification $this, Context context, PushBuilderBundle builderBundle) {
        $this.show(context, builderBundle);
    }

    public static final /* synthetic */ NotificationCompat.Builder access$createNotificationBuilder(PushNotification $this, boolean ongoing) {
        return $this.createNotificationBuilder(ongoing);
    }

    public static final /* synthetic */ PushIntentBundle access$initIntentBundle(PushNotification $this, Context context) {
        return $this.initIntentBundle(context);
    }

    public static final /* synthetic */ PushViewBundle access$initViewBundle(PushNotification $this, Context context, PushIntentBundle intentBundle, NotificationCompat.Builder builder) {
        return $this.initViewBundle(context, intentBundle, builder);
    }

    public static final /* synthetic */ boolean access$shouldGroupBy(PushNotification $this) {
        return $this.shouldGroupBy();
    }

    public static final /* synthetic */ NotificationCompat.Builder access$createSummaryNotificationBuilder(PushNotification $this) {
        return $this.createSummaryNotificationBuilder();
    }

    public /* synthetic */ PushNotification(PushNotificationData data2, DefaultConstructorMarker $constructor_marker) {
        this(data2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000bJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0016\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\tH\u0007J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u000bJ\"\u0010!\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#J\b\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/yy/appbase/push/PushNotification$Companion;", "", "()V", "KEY_FIRST_SCREEN_PRESENT", "", "PUSH_INTENT_FLAG", "TAG", "groupMap", "", "", "", "Lcom/yy/appbase/push/NotifyIdInfo;", "mPostNotifyInfoMap", "Ljava/util/HashMap;", "Lcom/yy/appbase/push/NotifyIdPostInfo;", "Lkotlin/collections/HashMap;", "requestCode", "shownIds", "addPostNotifyInfo", "", "notifyId", "postId", "batchCount", "cancel", "idInfo", "findPostNotifyId", "getChannelIdByChannelSource", "pushSource", "payloadJson", "Lorg/json/JSONObject;", "getSmallIcon", "isNotifyIdExist", "", "notify", "builder", "Landroidx/core/app/NotificationCompat$Builder;", "summaryBuilder", "notifyCompat", "Landroidx/core/app/NotificationManagerCompat;", "of", "Lcom/yy/appbase/push/PushNotification;", "data", "Lcom/yy/appbase/push/PushNotificationData;", "removePostNotifyInfo", "appbase_debug"})
    public static final class Companion {
        private final NotificationManagerCompat notifyCompat() {
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)RuntimeContext.sApplicationContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)notificationManagerCompat, (String)"NotificationManagerCompa\u2026text.sApplicationContext)");
            return notificationManagerCompat;
        }

        @NotNull
        public final PushNotification of(@NotNull PushNotificationData data2) {
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            MLog.info((Object)PushNotification.TAG, (String)("PushNotificationData " + data2), (Object[])new Object[0]);
            return new PushNotification(data2, null);
        }

        @DrawableRes
        public final int getSmallIcon() {
            return Build.VERSION.SDK_INT > 26 ? R.drawable.push_logo_white : R.drawable.push_logo;
        }

        public final int getChannelIdByChannelSource(@NotNull String pushSource, @NotNull JSONObject payloadJson) {
            PushSourceType type2;
            Intrinsics.checkParameterIsNotNull((Object)pushSource, (String)"pushSource");
            Intrinsics.checkParameterIsNotNull((Object)payloadJson, (String)"payloadJson");
            PushSourceType pushSourceType = type2 = NotificationManager.Instance.getPushSourceType(pushSource);
            Intrinsics.checkExpressionValueIsNotNull((Object)pushSourceType, (String)"type");
            return PushChannelAndGroupKt.getGroupType(pushSourceType, payloadJson).getId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void cancel(@NotNull NotifyIdInfo idInfo) {
            Intrinsics.checkParameterIsNotNull((Object)idInfo, (String)"idInfo");
            List groupNotifyList = (List)groupMap.get(idInfo.getGroupId());
            NotificationManagerCompat notificationManagerCompat = this.notifyCompat();
            boolean bl = false;
            boolean bl2 = false;
            NotificationManagerCompat $this$apply = notificationManagerCompat;
            boolean bl3 = false;
            if (groupNotifyList != null && groupNotifyList.isEmpty()) {
                $this$apply.cancel(idInfo.getGroupId());
            }
            $this$apply.cancel(idInfo.getNotifyId());
            boolean bl4 = false;
            bl = false;
            synchronized (this) {
                boolean bl5 = false;
                List list = groupNotifyList;
                if (list != null) {
                    list.remove(idInfo);
                }
                bl = shownIds.remove((Object)idInfo.getNotifyId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void notify(@NotNull NotifyIdInfo idInfo, @Nullable NotificationCompat.Builder builder, @Nullable NotificationCompat.Builder summaryBuilder) {
            boolean bl;
            boolean bl2;
            Companion companion;
            Intrinsics.checkParameterIsNotNull((Object)idInfo, (String)"idInfo");
            NotificationManagerCompat notificationManagerCompat = this.notifyCompat();
            boolean bl3 = false;
            boolean bl4 = false;
            NotificationManagerCompat $this$apply = notificationManagerCompat;
            boolean bl5 = false;
            if (builder != null) {
                companion = builder.build();
                int n = idInfo.getNotifyId();
                NotificationManagerCompat notificationManagerCompat2 = $this$apply;
                bl2 = false;
                bl = false;
                Companion it = companion;
                boolean bl6 = false;
                ShortcutBadger.setCurrentNotification((Notification)it);
                Companion companion2 = companion;
                notificationManagerCompat2.notify(n, (Notification)companion2);
            }
            if (summaryBuilder != null) {
                $this$apply.notify(idInfo.getGroupId(), summaryBuilder.build());
            }
            companion = Companion;
            bl2 = false;
            bl = false;
            synchronized (companion) {
                boolean bl7 = false;
                if (builder != null && !shownIds.contains(idInfo.getNotifyId())) {
                    shownIds.add(idInfo.getNotifyId());
                }
                if (summaryBuilder != null) {
                    List list = (List)groupMap.get(idInfo.getGroupId());
                    if (list != null) {
                        list.add(idInfo);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public final synchronized boolean isNotifyIdExist(@NotNull NotifyIdInfo idInfo) {
            Intrinsics.checkParameterIsNotNull((Object)idInfo, (String)"idInfo");
            return shownIds.contains(idInfo.getNotifyId());
        }

        private final synchronized void addPostNotifyInfo(NotifyIdInfo notifyId, String postId, int batchCount) {
            int finalCount = batchCount;
            NotifyIdPostInfo notify2 = this.findPostNotifyId(postId);
            if (notify2 != null) {
                finalCount += notify2.getCount();
            }
            NotifyIdPostInfo notifyIdPostInfo = new NotifyIdPostInfo(notifyId, postId, finalCount);
            String string2 = postId;
            Map map = mPostNotifyInfoMap;
            boolean bl = false;
            boolean bl2 = false;
            NotifyIdPostInfo it = notifyIdPostInfo;
            boolean bl3 = false;
            MLog.debug((Object)PushNotification.TAG, (String)("add post notify: " + it), (Object[])new Object[0]);
            NotifyIdPostInfo notifyIdPostInfo2 = notifyIdPostInfo;
            map.put(string2, notifyIdPostInfo2);
        }

        public final synchronized void removePostNotifyInfo(@Nullable String postId) {
            Map map = mPostNotifyInfoMap;
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            TypeIntrinsics.asMutableMap((Object)map2).remove(postId);
        }

        private final synchronized NotifyIdPostInfo findPostNotifyId(String postId) {
            return (NotifyIdPostInfo)mPostNotifyInfoMap.get(postId);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

