/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.content.FileProvider;
import com.bumptech.glide.load.DecodeFormat;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.R;
import com.yy.appbase.abtest.ReadAbTestConfigCallback;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.push.FloatPushItem;
import com.yy.appbase.push.NotificationSwitchSetting;
import com.yy.appbase.push.NotificationTrack;
import com.yy.appbase.push.NotifyIdInfo;
import com.yy.appbase.push.PushNotification;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.PushShowLimitManager;
import com.yy.appbase.push.ScreenBroadcastReceiver;
import com.yy.appbase.push.ScreenStateListener;
import com.yy.appbase.push.lockscreen.LockScreenPushManager;
import com.yy.appbase.service.IChannelPushStatService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.transform.GlideRoundTransform;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.blur.BlurProcess;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.NotificationCenter;
import ikxd.msg.PushSourceType;
import java.io.File;
import org.json.JSONObject;

public enum NotificationManager {
    Instance;

    private static final String TAG = "NotificationViewManager";
    private static final String PUSH_TYPE = "pushtype";
    public static final String PUSH_ACTION = "yylitepushinfo";
    public static final String PUSH_DATA_KEY = "payload";
    public static final String PUSH_OFFLINE_MSG = "offline_msg";
    private static final String PUSH_GID = "gid";
    private static final String CHANNEL_CUSTOM = "custom";
    private static final String CHANNEL_DEFAULT = "default";
    private static final String TIME_FORMAT = "year-mon-day";
    public static final String NOTIFY_ID_INFO = "notify_id";
    public static final String OTHER_CHANNEL = "-1";
    public static final String XIAOMI_CHANNEL = "1";
    public static final String HUAWEI_CHANNEL = "2";
    public static final String OPPO_CHANNEL = "4";
    public static final String MEIZU_CHANNEL = "16";
    public static final String FCM_CHANNEL = "128";
    public static final String LOCAL_CHANNEL = "512";
    public static final String SERVICE_CHANNEL = "256";
    private static final int PUSH_DELAY_TIME = 1000;
    public static final String TYPE_FRIEND_ADD = "1";
    public static final String TYPE_GAME_INVITE = "2";
    public static final String TYPE_FLOAT_PUSH = "6";
    public static final String TYPE_SHARE = "1017";
    public static final int NOTIFICATION_ID_LIVE = 1;
    public static final String DEF_CHANNELID = "notify";
    public static final String NOTIFICATION_DELETED_ACTION = "com.yy.hiyo.del_notification_aciton";
    public static final int MIC_STATIS_NOTIFICATION = 10000;
    private PushNotification mPushNotification;

    private NotificationManager() {
        this.registerScreenStateBR();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                NotificationManager.this.removePushImageFiles();
            }
        }, (long)5000L);
    }

    private void registerScreenStateBR() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        RuntimeContext.sApplicationContext.registerReceiver((BroadcastReceiver)new ScreenBroadcastReceiver(new ScreenStateListener(){

            @Override
            public void screenOnCallBack(Context context) {
            }

            @Override
            public void screenOffCallBack(Context context) {
            }

            @Override
            public void screenPresentCallBack(Context context) {
                MLog.debug((Object)NotificationManager.TAG, (String)"screenPresentCallBack", (Object[])new Object[0]);
                if (RuntimeContext.sIsForeground) {
                    return;
                }
                NotificationManager.this.reshowPush(context);
            }
        }), filter);
    }

    private void reshowPush(Context context) {
        if (this.mPushNotification == null) {
            MLog.debug((Object)TAG, (String)"reshowPush ignore, pushNotification is null", (Object[])new Object[0]);
            return;
        }
        this.mPushNotification.reshow(context);
    }

    public PushSourceType getPushSourceType(String pushSource) {
        if (!StringUtils.isEmpty((String)pushSource)) {
            try {
                return PushSourceType.fromValue((int)Integer.parseInt(pushSource));
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"getPushSourceType error", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return PushSourceType.kPushSourceUnknown;
    }

    public void showNotification(final Context context, final PushNotificationData pushNotificationData) {
        if (pushNotificationData == null) {
            return;
        }
        if (pushNotificationData.getPushSource() == PushSourceType.kPushSourceChannel && RuntimeContext.sIsMainProcess) {
            IServiceManager serviceManager;
            String cid = pushNotificationData.getCid();
            if (ServiceManagerProxy.hadInit() && (serviceManager = ServiceManagerProxy.getServiceManager()) != null) {
                serviceManager.observeService(IChannelPushStatService.class, channelPushStatService -> {
                    if (channelPushStatService != null && !TextUtils.isEmpty((CharSequence)cid)) {
                        channelPushStatService.onPushReceive(cid);
                    }
                });
            }
        }
        MLog.debug((Object)TAG, (String)"check before show notification start", (Object[])new Object[0]);
        this.checkBeforeShowNotification(new Runnable(){

            @Override
            public void run() {
                MLog.debug((Object)NotificationManager.TAG, (String)"check before show notification finish", (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MLog.info((Object)NotificationManager.TAG, (String)("show push payload: " + pushNotificationData.getPayloadString()), (Object[])new Object[0]);
                            }
                            catch (Exception ex) {
                                MLog.error((Object)NotificationManager.TAG, (String)"debug mode show push payload error", (Throwable)ex, (Object[])new Object[0]);
                            }
                        }
                    });
                }
                MLog.info((Object)NotificationManager.TAG, (String)("show push data: " + pushNotificationData), (Object[])new Object[0]);
                if (pushNotificationData.isFirstReceive()) {
                    NotificationTrack.INSTANCE.reportReceivePush(context, pushNotificationData);
                }
                if (!pushNotificationData.isComplete()) {
                    MLog.warn((Object)NotificationManager.TAG, (String)"showNotification ignore, is not complete", (Object[])new Object[0]);
                    return;
                }
                if (LockScreenPushManager.getInstance().isFilterLockScreenPush(pushNotificationData.getStyle())) {
                    MLog.info((Object)NotificationManager.TAG, (String)"is Lock screen push data: %s", (Object[])new Object[]{pushNotificationData});
                    LockScreenPushManager.getInstance().addLockScreenPush(pushNotificationData);
                    return;
                }
                if (NotificationManager.this.isPushShield(pushNotificationData)) {
                    MLog.warn((Object)NotificationManager.TAG, (String)"push data: %s is shield", (Object[])new Object[]{pushNotificationData});
                    return;
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JSONObject copy = pushNotificationData.getPayloadCopy();
                        YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().notify(com.yy.framework.core.Notification.obtain((int)NotificationIdDef.BADGER_NOTIFY, (Object)copy)));
                    }
                });
                if (pushNotificationData.isIgnore()) {
                    MLog.debug((Object)NotificationManager.TAG, (String)"push data: %s is ignore", (Object[])new Object[]{pushNotificationData});
                    return;
                }
                if (NotificationSwitchSetting.getTotalSwitch()) {
                    if (pushNotificationData.getShowPush() && NotificationSwitchSetting.isEnable(pushNotificationData.getPushSource())) {
                        NotificationManager.this.checkNotificationAvatar(context, pushNotificationData);
                    } else {
                        MLog.info((Object)NotificationManager.TAG, (String)"show notification ignore, showPush: %b, enable: %b", (Object[])new Object[]{pushNotificationData.getShowPush(), NotificationSwitchSetting.isEnable(pushNotificationData.getPushSource())});
                    }
                } else if (pushNotificationData.getFloatPush()) {
                    NotificationManager.this.showFloatPushView(context, pushNotificationData);
                } else {
                    MLog.info((Object)NotificationManager.TAG, (String)"total switch not open, not allow float push", (Object[])new Object[0]);
                }
            }
        });
    }

    public void showNotification(final Context context, final String payload, final String pushSource, final long pushId, final String fromChannel, final String content, final String title, final String avatar, final long uid, final String gameId, final boolean isShowPush, final boolean isOfflineMsg) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationManager.this.showNotification(context, new PushNotificationData(pushId, fromChannel, pushSource, payload).with(content, title, avatar).with(isShowPush, isOfflineMsg).withUid(uid).withGid(gameId));
                }
            });
        } else {
            this.showNotification(context, new PushNotificationData(pushId, fromChannel, pushSource, payload).with(content, title, avatar).with(isShowPush, isOfflineMsg).withUid(uid).withGid(gameId));
        }
    }

    private void checkBeforeShowNotification(final @NonNull Runnable afterAction) {
        NewABDefine.INSTANCE.waitReadConfigHistory(new ReadAbTestConfigCallback(){

            @Override
            public void onReadFinish() {
                YYTaskExecutor.postToMainThread((Runnable)afterAction);
            }
        });
    }

    private void checkNotificationAvatar(final Context context, final PushNotificationData pushNotificationData) {
        if (TextUtils.isEmpty((CharSequence)pushNotificationData.getAvatar())) {
            this.handleNotificationShow(context, pushNotificationData);
        } else {
            String avatar = pushNotificationData.getAvatar();
            if (SettingFlags.getBoolean((String)"notify_size", (boolean)true) && avatar != null && !avatar.contains("image/resize")) {
                avatar = avatar + YYImageUtils.getThumbSmall();
            }
            final String finalAvatar = avatar;
            final int width = pushNotificationData.getImageSize(true);
            final int height = pushNotificationData.getImageSize(false);
            final int finalRadius = pushNotificationData.getImageRadius();
            MLog.debug((Object)TAG, (String)("checkNotificationAvatar avatar: " + finalAvatar), (Object[])new Object[0]);
            ImageLoader.withBitmap((Context)context.getApplicationContext(), (String)finalAvatar, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onResourceReady(final Bitmap bitmap) {
                    MLog.debug((Object)NotificationManager.TAG, (String)"load avatar: %s success", (Object[])new Object[]{finalAvatar});
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String name = FileUtils.fixFileName((String)finalAvatar);
                            final Uri bitmapUri = NotificationManager.this.getPushBitmapUri(context, name, bitmap);
                            final Uri blurUri = pushNotificationData.useBigBackground() ? NotificationManager.this.getPushBitmapBlurUri(context, name, bitmap, finalRadius, width, height) : null;
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                @RequiresApi(api=16)
                                public void run() {
                                    pushNotificationData.setBitmapUri(bitmapUri);
                                    pushNotificationData.setBlurBitmapUri(blurUri);
                                    NotificationManager.this.handleNotificationShow(context, pushNotificationData);
                                }
                            });
                        }
                    }, (long)1000L);
                }

                public void onLoadFailed(Exception e) {
                    MLog.error((Object)NotificationManager.TAG, (String)"load avatar: %s fail", (Object[])new Object[]{finalAvatar});
                    YYTaskExecutor.postToMainThread(() -> NotificationManager.this.handleNotificationShow(context, pushNotificationData), (long)1000L);
                }
            }).setSize(width, height).setDecodeFormat(DecodeFormat.PREFER_RGB_565).setTransform(new YYBitmapTransformation[]{new GlideRoundTransform(finalRadius)}).load();
        }
    }

    private void handleNotificationShow(Context context, PushNotificationData notificationData) {
        PushNotification pushNotification;
        MLog.debug((Object)TAG, (String)("handleNotificationShow: " + notificationData), (Object[])new Object[0]);
        this.mPushNotification = pushNotification = PushNotification.Companion.of(notificationData);
        pushNotification.show(context);
    }

    public void showMicNotification(Context context) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, DEF_CHANNELID);
        Intent resultIntent = new Intent(context, context.getClass());
        PendingIntent pendingContentIntent = PendingIntent.getActivity((Context)context, (int)1, (Intent)resultIntent, (int)0x8000000);
        builder.setSmallIcon(PushNotification.Companion.getSmallIcon()).setContentTitle((CharSequence)ResourceUtils.getString((int)R.string.voice_chatting)).setContentText((CharSequence)ResourceUtils.getString((int)R.string.notify_click_return)).setAutoCancel(false).setContentIntent(pendingContentIntent);
        Notification notification = builder.build();
        notification.flags = 32;
        android.app.NotificationManager notifyMgr = (android.app.NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(DEF_CHANNELID, (CharSequence)ResourceUtils.getString((int)R.string.voice_calls), 3);
            channel.setShowBadge(true);
            notifyMgr.createNotificationChannel(channel);
        }
        try {
            notifyMgr.notify(10000, notification);
        }
        catch (SecurityException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void cancelNotification(Context context, String jsonIdInfo) {
        MLog.info((Object)TAG, (String)"cancelNotification id: %d", (Object[])new Object[]{jsonIdInfo});
        NotifyIdInfo idInfo = (NotifyIdInfo)JsonParser.parseJsonObject((String)jsonIdInfo, NotifyIdInfo.class);
        if (idInfo != null) {
            PushNotification.Companion.cancel(idInfo);
        }
    }

    public void cancelNotification(PushNotificationData pushNotificationData) {
        if (pushNotificationData == null) {
            MLog.debug((Object)TAG, (String)"cancelNotification fail, pushNotificationData is null", (Object[])new Object[0]);
            return;
        }
        NotifyIdInfo idInfo = pushNotificationData.getIdInfo();
        if (idInfo != null) {
            PushNotification.Companion.cancel(idInfo);
        }
    }

    public void showFloatPushView(Context context, PushNotificationData pushNotificationData) {
        MLog.info((Object)TAG, (String)"showFloatPushView", (Object[])new Object[0]);
        try {
            FloatPushItem floatPushItem = new FloatPushItem();
            floatPushItem.setContent(pushNotificationData.getContent());
            floatPushItem.setImageUrl(pushNotificationData.getAvatar());
            floatPushItem.setPushId(pushNotificationData.getPushId());
            floatPushItem.setPushSource(String.valueOf(pushNotificationData.getPushSource().getValue()));
            floatPushItem.setTitle(pushNotificationData.getTitle());
            floatPushItem.setUid(pushNotificationData.getUid());
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setFlags(0x10000000);
            ComponentName cn = new ComponentName(AppKeysDef.getAppPackageName(), "com.yy.hiyo.FloatWindowActivity");
            intent.setComponent(cn);
            intent.putExtra("push_float_data", (Parcelable)floatPushItem);
            intent.putExtra(PUSH_DATA_KEY, pushNotificationData.getPayloadString());
            intent.putExtra(PUSH_OFFLINE_MSG, pushNotificationData.isOffline());
            context.startActivity(intent);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"showFloatPushView error", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    private boolean isPushShield(PushNotificationData data2) {
        boolean isShield = false;
        if (data2 != null) {
            if (RuntimeContext.sIsForeground) {
                boolean bl = isShield = data2.getPushSource() == PushSourceType.kPushSourceOnmicro || data2.getPushSource() == PushSourceType.kPushSourcePlatformFriendChannelSitdown || data2.getPushSource() == PushSourceType.kPushSourceChannelOtherSitdownFollow || data2.getPushSource() == PushSourceType.kPushSourceChannelOtherSitdownFriend || data2.getPushSource() == PushSourceType.kPushSourceChannelDIYPush;
            }
            if (!isShield) {
                isShield = data2.getLimitType() == PushShowLimitManager.LimitType.LIMIT_SHOW;
            }
        }
        return isShield;
    }

    private void grantPermission(Uri bitmapUri) {
        RuntimeContext.sApplicationContext.grantUriPermission("com.android.systemui", bitmapUri, 1);
    }

    private Uri getPushBitmapUri(Context context, String name, Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            MLog.debug((Object)TAG, (String)"getPushBitmapUri empty, bitmap is null or recycled", (Object[])new Object[0]);
            return Uri.EMPTY;
        }
        MLog.debug((Object)TAG, (String)("getPushBitmapUri begin name: " + name), (Object[])new Object[0]);
        if (StringUtils.isEmpty((String)name)) {
            name = System.currentTimeMillis() + "";
        }
        try {
            String path = this.getPushImagePath(name + ".png");
            if (!YYFileUtils.isFileExisted((String)path)) {
                YYFileUtils.saveBitmap((Bitmap)bitmap, (String)path, (Bitmap.CompressFormat)Bitmap.CompressFormat.PNG, (int)80);
            } else {
                MLog.debug((Object)TAG, (String)"getPushBitmapUri already exist path: %s", (Object[])new Object[]{path});
            }
            Uri bitmapUri = Uri.EMPTY;
            try {
                bitmapUri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)new File(path));
                this.grantPermission(bitmapUri);
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"getPushBitmapUri error", (Throwable)ex, (Object[])new Object[0]);
                bitmapUri = Uri.parse((String)path);
                this.grantPermission(bitmapUri);
            }
            MLog.debug((Object)TAG, (String)"getPushBitmapUri finish path: %s, uri: %s", (Object[])new Object[]{path, bitmapUri});
            return bitmapUri;
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"savePushBitmapToUri error", (Throwable)ex, (Object[])new Object[0]);
            return Uri.EMPTY;
        }
    }

    private void removePushImageFiles() {
        String dirPath = this.getPushImageDir();
        if (!StringUtils.isEmpty((String)dirPath)) {
            try {
                boolean hasRemove = false;
                long timeNow = System.currentTimeMillis();
                long oneDayMills = 86400000L;
                File dir = new File(dirPath);
                File[] files = dir.listFiles();
                if (files != null) {
                    for (File file : files) {
                        if (timeNow - file.lastModified() <= oneDayMills) continue;
                        YYFileUtils.removeFile((File)file);
                        hasRemove = true;
                    }
                }
                if (hasRemove) {
                    MLog.info((Object)TAG, (String)"clear old push image files", (Object[])new Object[0]);
                }
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"removePushImageFiles error", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    private Uri getPushBitmapBlurUri(Context context, String name, Bitmap bitmap, int radius, int width, int height) {
        try {
            int corner = ResolutionUtils.dip2Px((float)radius);
            int tempWidth = bitmap.getWidth() - 2 * corner;
            int tempHeight = bitmap.getHeight() - 2 * corner;
            if (tempWidth <= 0) {
                tempWidth = bitmap.getWidth();
            }
            if (tempHeight <= 0) {
                tempHeight = bitmap.getHeight();
            }
            Bitmap toBlurBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)corner, (int)corner, (int)tempWidth, (int)tempHeight);
            Bitmap from = Bitmap.createScaledBitmap((Bitmap)toBlurBitmap, (int)width, (int)height, (boolean)true);
            Bitmap blurBitmap = BlurProcess.blur((Bitmap)from, (int)200, (boolean)false);
            return this.getPushBitmapUri(context, "blur_" + name, blurBitmap);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"getPushBitmapBlurUri error", (Throwable)ex, (Object[])new Object[0]);
            return Uri.EMPTY;
        }
    }

    private String getPushImageDir() {
        return YYFileUtils.getRootDir() + File.separator + "image" + File.separator;
    }

    private String getPushImagePath(String name) {
        String filename = name;
        int index = filename.lastIndexOf(File.separatorChar);
        if (index != -1) {
            filename = filename.substring(index + 1);
        }
        String dirPath = this.getPushImageDir();
        YYFileUtils.createDir((String)dirPath);
        return dirPath + filename;
    }
}

