/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.source;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.yy.appbase.permission.source.Source;

public class AppActivitySource
extends Source {
    private Activity mActivity;
    private IPermissionRequestRegister mRegister;
    private static int sRequestIndex = 1;

    public AppActivitySource(Activity activity, IPermissionRequestRegister requestRegister) {
        this.mActivity = activity;
        this.mRegister = requestRegister;
    }

    @Override
    public Context getContext() {
        return this.mActivity;
    }

    @Override
    public void startActivity(Intent intent) {
        this.mActivity.startActivity(intent);
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        this.mActivity.startActivityForResult(intent, requestCode);
    }

    @Override
    public void requestPermission(String[] permissions, Source.PermissionListener callback) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (callback != null && this.mRegister != null) {
                this.mRegister.onRegisterCall(sRequestIndex, callback);
            }
            this.mActivity.requestPermissions(permissions, sRequestIndex);
            ++sRequestIndex;
        }
    }

    public static interface IPermissionRequestRegister {
        public void onRegisterCall(int var1, Source.PermissionListener var2);
    }
}

