/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.checker;

import android.content.Context;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yy.appbase.permission.checker.PermissionTest;
import com.yy.base.logger.MLog;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;

class CameraTest
implements PermissionTest {
    private static volatile CameraTestInner sTestInner;

    CameraTest(Context context) {
        if (sTestInner == null) {
            sTestInner = new CameraTestInner(context);
        }
    }

    @Override
    public boolean test() throws Throwable {
        return sTestInner.test();
    }

    private static class CameraTestInner
    implements PermissionTest,
    INotify {
        private volatile SurfaceHolder mHolder;
        private volatile boolean mHasPer = true;
        private volatile boolean mHasTest = false;
        private static final Camera.PreviewCallback PREVIEW_CALLBACK = new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] data2, Camera camera) {
            }
        };
        private static final SurfaceHolder.Callback CALLBACK = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        };

        CameraTestInner(Context context) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
            SurfaceView surfaceView = new SurfaceView(context);
            this.mHolder = surfaceView.getHolder();
            this.mHolder.addCallback(CALLBACK);
        }

        @Override
        public synchronized boolean test() throws Throwable {
            if (this.mHasTest) {
                return this.mHasPer;
            }
            Camera camera = null;
            try {
                camera = Camera.open();
                Camera.Parameters parameters = camera.getParameters();
                camera.setParameters(parameters);
                camera.setPreviewDisplay(this.mHolder);
                camera.setPreviewCallback(PREVIEW_CALLBACK);
                camera.startPreview();
                this.mHasPer = true;
            }
            catch (Throwable e) {
                this.mHasPer = false;
            }
            finally {
                try {
                    if (camera != null) {
                        camera.stopPreview();
                        camera.setPreviewDisplay(null);
                        camera.setPreviewCallback(null);
                        camera.release();
                    }
                }
                catch (Throwable e) {
                    MLog.debug((Object)"CameraTest", (String)"e", (Object[])new Object[0]);
                }
            }
            this.mHasTest = true;
            return this.mHasPer;
        }

        public void notify(Notification notification) {
            if (notification == null || notification.id != NotificationDef.N_FOREGROUND_CHANGE) {
                return;
            }
            if (notification.extObj instanceof Boolean && !((Boolean)notification.extObj).booleanValue()) {
                this.mHasTest = false;
            }
        }
    }
}

