/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.kvomodule;

import com.yy.appbase.kvomodule.BaseModuleData;
import com.yy.appbase.kvomodule.IKvoModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BaseModule<Data extends BaseModuleData>
implements IKvoModule {
    private static final String TAG = "BaseModule";
    public List<Runnable> mCacheTask = new ArrayList<Runnable>();
    protected boolean isReady = false;
    protected boolean isDestroyed = false;
    protected Data mData;
    protected IServiceManager mService;
    protected Environment mEnv;

    private BaseModule() {
    }

    public BaseModule(Data mData) {
        this.mData = mData;
    }

    @Override
    public IServiceManager getService() {
        return this.mService;
    }

    @Override
    public Environment getEnv() {
        return this.mEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate(IServiceManager serviceManager, Environment evn) {
        this.mService = serviceManager;
        this.mEnv = evn;
        this.isReady = true;
        List<Runnable> list = this.mCacheTask;
        synchronized (list) {
            if (this.isReady && !this.mCacheTask.isEmpty()) {
                Iterator<Runnable> tasks = this.mCacheTask.iterator();
                while (tasks.hasNext()) {
                    Runnable r = tasks.next();
                    if (r != null) {
                        r.run();
                    }
                    tasks.remove();
                }
            }
        }
    }

    @Override
    public synchronized void onDestroy() {
        this.unbindDataWhenDestroy();
        if (this.mData != null) {
            ((BaseModuleData)((Object)this.mData)).resetData();
        }
        this.mCacheTask.clear();
        this.mService = null;
        this.mEnv = null;
        this.isReady = false;
        this.isDestroyed = true;
    }

    protected void unbindDataWhenDestroy() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)BaseModule.TAG, (String)("unbindDataWhenDestroy invoke:" + this.getClass().getSimpleName()), (Object[])new Object[0]);
            }
        });
    }

    protected synchronized boolean cacheTask(Runnable task2) {
        if (!this.isReady && task2 != null) {
            this.mCacheTask.add(task2);
            return true;
        }
        return false;
    }

    public KvoSource getData() {
        return this.mData;
    }
}

